/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.wage.gui.holiday.importer;

import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.importer.AbstractCsvImporter;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.importer.HolidaySetCsvImportDto;
import de.datomino.peppergis.dto.importer.HolidaySetCsvImportResultDto;
import de.datomino.peppergis.exception.ClientImportException;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.assistant.editor.Worker;
import de.datomino.util.assistant.model.ChoiceField;
import de.datomino.util.assistant.model.CsvColumnChoiceField;
import de.datomino.util.assistant.model.Fieldset;
import de.datomino.util.message.error.ErrorMessages;
import java.awt.Window;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ktde.util.NameGenerator;
import org.ktde.util.datatypes.Tupel;

public class HolidaySetImporter
extends AbstractCsvImporter<HolidaySetCsvImportDto> {
    private ChoiceField<AreaLayerModel> layerField;
    private CsvColumnChoiceField areaField;
    private CsvColumnChoiceField holidaySetField;
    private CsvColumnChoiceField deleteField;
    private ModelEnviroment modelEnviroment;

    public HolidaySetImporter(ModelEnviroment modelEnviroment) {
        this.modelEnviroment = modelEnviroment;
        Collection<AreaLayerModel> areaLayers = this.modelEnviroment.getAllCaller().getAreaCaller().getAreaLayerForWage(AreaObjectGenInfoDiscriminator.values());
        this.layerField = new ChoiceField<1>(ModelEnviroment.getMessageResolver().resolveMessage("messages.import.area.layer", new Serializable[0]), (Collection<1>)areaLayers, new NameGenerator<AreaLayerModel>(){

            @Override
            public String getName(AreaLayerModel t) {
                return t == null ? ModelEnviroment.getMessageResolver().resolveMessage("messages.default.pleaseChoose", new Serializable[0]) : t.getDisplayname();
            }
        });
        this.holidaySetField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.holiday.set.key", new Serializable[0]), (Serializable)((Object)HolidaySetCsvImportDto.Field.HOLIDAY_SET), null, true);
        this.areaField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.shortcut", new Serializable[0]), (Serializable)((Object)HolidaySetCsvImportDto.Field.AREA_SHORTCUT), "bezirk", false);
        this.deleteField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.deleteColumn", new Serializable[0]), (Serializable)((Object)HolidaySetCsvImportDto.Field.DELETE), "^del|delete$", true);
    }

    protected HolidaySetCsvImportDto getDto() {
        HolidaySetCsvImportDto dto = new HolidaySetCsvImportDto();
        this.writeToDto(dto);
        return dto;
    }

    @Override
    public Worker getWorker(final Window parent) {
        return new Worker(){
            private Worker.State state;
            private String resultString;

            @Override
            public void process() {
                StringBuilder builder = new StringBuilder();
                try {
                    Tupel result;
                    String message = ModelEnviroment.getMessageResolver().resolveMessage("messages.import.holiday.set.importing", new Serializable[0]);
                    AbstractAsynchronousDialog<HolidaySetCsvImportResultDto> asynchronousDialog = new AbstractAsynchronousDialog<HolidaySetCsvImportResultDto>(parent, message, message, 1, true, HolidaySetImporter.this.modelEnviroment){
                        private static final long serialVersionUID = -1127458576478099632L;

                        @Override
                        protected AsynchronousDto<HolidaySetCsvImportResultDto> getAsynchronousDto(String token) {
                            return this.getModelEnviroment().getAllCaller().getAsynchronousCaller().getImportAreaHolidaySetResult(token);
                        }

                        @Override
                        protected String startAsynchronous() {
                            return this.getModelEnviroment().getAllCaller().getAsynchronousCaller().importAreaHolidaySet(HolidaySetImporter.this.getDto());
                        }
                    };
                    try {
                        result = asynchronousDialog.run();
                    }
                    catch (Exception e) {
                        if (e instanceof ClientImportException) {
                            throw (ClientImportException)e;
                        }
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                    HolidaySetCsvImportResultDto report = (HolidaySetCsvImportResultDto)result.getElement1();
                    ClientSwingUtil.saveContentToFile(report.getContent(), parent);
                    String reportMessage = ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.holiday.set.result", Integer.valueOf(report.getSuccesfullCount()), Integer.valueOf(report.getErrorCount()));
                    builder.append(reportMessage).append("\n");
                    ErrorMessages errorMessages = report.getErrorMessages();
                    if (errorMessages.hasErrors()) {
                        builder.append(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0])).append(":\n\n");
                        builder.append(ModelEnviroment.getMessageResolver().resolveMessages(errorMessages, "\n"));
                        this.state = Worker.State.ERROR;
                    } else {
                        this.state = Worker.State.OK;
                    }
                }
                catch (ClientImportException e) {
                    ErrorMessages errorMessages = e.getErrorMessages();
                    if (errorMessages != null && errorMessages.hasErrors()) {
                        builder.append(ModelEnviroment.getMessageResolver().resolveMessages(errorMessages, "\n"));
                    }
                    builder.append(e.getMessage());
                }
                this.resultString = builder.toString();
            }

            @Override
            public String getResultString() {
                return this.resultString;
            }

            @Override
            public Worker.State getResultState() {
                return this.state;
            }
        };
    }

    @Override
    protected void writeToDto(HolidaySetCsvImportDto dto) {
        super.writeToDto(dto);
        AreaLayerModel areaLayer = (AreaLayerModel)this.layerField.getValue();
        dto.setAreaLayer(areaLayer.getDisplayname());
    }

    @Override
    protected void addCsvFields(List<CsvColumnChoiceField> choiceFields) {
        choiceFields.add(this.areaField);
        choiceFields.add(this.holidaySetField);
        choiceFields.add(this.deleteField);
    }

    @Override
    public String getTitle() {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.default.import", new Serializable[0]);
    }

    @Override
    protected List<Fieldset> getAdditionalFieldsets() {
        Fieldset geo = new Fieldset(ModelEnviroment.getMessageResolver().resolveMessage("messages.import.area.layer", new Serializable[0]));
        geo.addField(this.layerField);
        return Collections.singletonList(geo);
    }
}

