/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.wage.gui.holiday.area;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.wage.WageHolidaySetModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.StringUtil;

public class HolidaySetAreaObjectTableModel
implements TableModel {
    private WageHolidaySetModel wageHolidaySetModel;
    private AreaLayerModel areaLayerModel;
    private List<AreaObjectModel> areaList;
    private List<TableModelListener> listeners = new LinkedList<TableModelListener>();

    @Override
    public int getRowCount() {
        return this.areaLayerModel == null ? 0 : this.areaLayerModel.countAreaObjects();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "";
            }
            case 1: {
                return ModelEnviroment.getMessageResolver().resolveMessage("messages.area.shortcut", new Serializable[0]);
            }
            case 2: {
                return ModelEnviroment.getMessageResolver().resolveMessage("messages.area.name", new Serializable[0]);
            }
            case 3: {
                return ModelEnviroment.getMessageResolver().resolveMessage("messages.default.current", new Serializable[0]);
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        List<AreaObjectModel> areaList = this.getAreaList();
        if (areaList != null) {
            AreaObjectModel areaObjectModel = areaList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return new EqualsBuilder().append(this.wageHolidaySetModel, areaObjectModel.getWageHolidaySet()).isEquals();
                }
                case 1: {
                    return areaObjectModel.getShortcut();
                }
                case 2: {
                    return areaObjectModel.getDisplayname();
                }
                case 3: {
                    WageHolidaySetModel wageHolidaySet = areaObjectModel.getWageHolidaySet();
                    return wageHolidaySet == null ? "" : wageHolidaySet.getName();
                }
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        List<AreaObjectModel> areaList;
        if (columnIndex == 0 && (areaList = this.getAreaList()) != null) {
            AreaObjectModel areaObjectModel = areaList.get(rowIndex);
            areaObjectModel.setWageHolidaySet((Boolean)aValue != false ? this.wageHolidaySetModel : null);
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    protected void fireTableModelChanged(TableModelEvent e) {
        for (TableModelListener l : this.listeners) {
            l.tableChanged(e);
        }
    }

    private List<AreaObjectModel> getAreaList() {
        if (this.areaList == null) {
            if (this.areaLayerModel == null) {
                this.areaList = Collections.emptyList();
            } else {
                this.areaList = new ArrayList<AreaObjectModel>(this.areaLayerModel.countAreaObjects());
                for (AreaObjectModel areaObject : this.areaLayerModel.iterableAreaObjects()) {
                    this.areaList.add(areaObject);
                }
                Collections.sort(this.areaList, new Comparator<AreaObjectModel>(){

                    @Override
                    public int compare(AreaObjectModel o1, AreaObjectModel o2) {
                        return StringUtil.nullToEmpty(o1.getShortcut()).compareTo(StringUtil.nullToEmpty(o2.getShortcut()));
                    }
                });
            }
        }
        return this.areaList;
    }

    public void setWageHolidaySetModel(WageHolidaySetModel wageHolidaySetModel) {
        this.wageHolidaySetModel = wageHolidaySetModel;
        this.fireTableModelChanged(new TableModelEvent(this));
    }

    public void setAreaLayerModel(AreaLayerModel areaLayerModel) {
        this.areaLayerModel = areaLayerModel;
        this.areaList = null;
        this.fireTableModelChanged(new TableModelEvent(this));
    }
}

