/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.wage.gui.holiday;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.wage.SpecialWageHolidayModel;
import de.datomino.peppergis.client.model.wage.SpecialWageHolidayModelImpl;
import de.datomino.peppergis.client.model.wage.WageHolidaySetModel;
import de.datomino.peppergis.wage.gui.holiday.SpecialHolidayTableModel;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.WidthUnifier;
import de.datomino.util.time.TimeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;

public class HolidaySetPane
extends JPanel {
    private static final long serialVersionUID = -4019411524161112276L;
    private WageHolidaySetModel wageHolidaySetModel;
    private JTextField name;
    private JCheckBox newYear;
    private JCheckBox threeHolyKings;
    private JCheckBox goodFriday;
    private JCheckBox easterMonday;
    private JCheckBox laborDay;
    private JCheckBox ascensionDay;
    private JCheckBox whitMonday;
    private JCheckBox corpusChristi;
    private JCheckBox assumptionDay;
    private JCheckBox germanUnityDay;
    private JCheckBox reformationDay;
    private JCheckBox allSaintsDay;
    private JCheckBox penanceDay;
    private JCheckBox firstChristmasDay;
    private JCheckBox secondChristmasDay;
    private JCheckBox peacePartyDay;
    private JCheckBox monday;
    private JCheckBox tuesday;
    private JCheckBox wednesday;
    private JCheckBox thursday;
    private JCheckBox friday;
    private JCheckBox saturday;
    private JCheckBox sunday;
    private JTable specialHolidayTable;
    private Action addSpecialHoliday;
    private Action removeSpecialHoliday;

    public HolidaySetPane() {
        super(new BorderLayout());
        this.buildLayout();
    }

    private void buildLayout() {
        JPanel topLevel1 = new JPanel(new BorderLayout());
        JPanel upperPanel = new JPanel(new SpringLayout());
        JPanel namePanel1 = new JPanel(new BorderLayout());
        namePanel1.add((Component)new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0])), "West");
        this.name = new JTextField();
        namePanel1.add((Component)this.name, "Center");
        upperPanel.add(namePanel1);
        upperPanel.add(new JSeparator(0));
        WidthUnifier widthUnifier = new WidthUnifier();
        int cColCount = 2;
        this.newYear = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.holiday.newYear", new Serializable[0]));
        this.goodFriday = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.holiday.goodFriday", new Serializable[0]));
        this.easterMonday = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.holiday.easterMonday", new Serializable[0]));
        this.laborDay = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.holiday.laborDay", new Serializable[0]));
        this.ascensionDay = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.holiday.ascensionDay", new Serializable[0]));
        this.whitMonday = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.holiday.whitMonday", new Serializable[0]));
        this.germanUnityDay = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.holiday.germanUnityDay", new Serializable[0]));
        this.firstChristmasDay = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.holiday.firstChristmasDay", new Serializable[0]));
        this.secondChristmasDay = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.holiday.secondChristmasDay", new Serializable[0]));
        JPanel wholePanel = this.makeGridPanel(widthUnifier, cColCount, this.newYear, this.goodFriday, this.easterMonday, this.laborDay, this.ascensionDay, this.whitMonday, this.germanUnityDay, this.firstChristmasDay, this.secondChristmasDay);
        upperPanel.add(wholePanel);
        upperPanel.add(new JSeparator(0));
        this.threeHolyKings = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.holiday.threeHolyKings", new Serializable[0]));
        this.corpusChristi = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.holiday.corpusChristi", new Serializable[0]));
        this.assumptionDay = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.holiday.assumptionDay", new Serializable[0]));
        this.reformationDay = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.holiday.reformationDay", new Serializable[0]));
        this.allSaintsDay = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.holiday.allSaintsDay", new Serializable[0]));
        this.penanceDay = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.holiday.penanceDay", new Serializable[0]));
        this.peacePartyDay = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.holiday.peacePartyDay", new Serializable[0]));
        JPanel specialPanel = this.makeGridPanel(widthUnifier, cColCount, this.threeHolyKings, this.corpusChristi, this.assumptionDay, this.reformationDay, this.allSaintsDay, this.penanceDay, this.peacePartyDay);
        upperPanel.add(specialPanel);
        upperPanel.add(new JSeparator(0));
        this.monday = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.monday", new Serializable[0]));
        this.tuesday = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.tuesday", new Serializable[0]));
        this.wednesday = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.wednesday", new Serializable[0]));
        this.thursday = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.thursday", new Serializable[0]));
        this.friday = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.friday", new Serializable[0]));
        this.saturday = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.saturday", new Serializable[0]));
        this.sunday = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.sunday", new Serializable[0]));
        JPanel weekdayPanel = this.makeGridPanel(widthUnifier, cColCount, this.monday, this.tuesday, this.wednesday, this.thursday, this.friday, this.saturday, this.sunday);
        upperPanel.add(weekdayPanel);
        SpringUtilities.makeCompactGrid(upperPanel, 7, 1, 5, 5, 2, 2);
        topLevel1.add((Component)upperPanel, "North");
        this.add((Component)topLevel1, "West");
        JPanel specialTablePanel = new JPanel(new BorderLayout());
        this.specialHolidayTable = new JTable(new SpecialHolidayTableModel());
        this.specialHolidayTable.getTableHeader().setReorderingAllowed(false);
        DayIntegerEditor editor = new DayIntegerEditor(this.specialHolidayTable.getDefaultRenderer(Integer.class));
        this.specialHolidayTable.setDefaultEditor(Integer.class, editor);
        this.specialHolidayTable.setDefaultRenderer(Integer.class, editor);
        this.specialHolidayTable.getColumnModel().getColumn(1).setPreferredWidth(20);
        this.specialHolidayTable.getColumnModel().getColumn(2).setPreferredWidth(5);
        this.specialHolidayTable.getSelectionModel().addListSelectionListener(new SpecialWageHolidayListSelectionListener());
        specialTablePanel.add((Component)new JScrollPane(this.specialHolidayTable), "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        this.removeSpecialHoliday = new RemoveSpecialHolidayAction();
        buttonPanel.add((Component)new JButton(this.removeSpecialHoliday), "West");
        this.addSpecialHoliday = new AddSpecialHolidayAction();
        buttonPanel.add((Component)new JButton(this.addSpecialHoliday), "East");
        specialTablePanel.add((Component)buttonPanel, "South");
        this.add((Component)specialTablePanel, "Center");
        this.setEnabled(false);
    }

    private JPanel makeGridPanel(WidthUnifier widthUnifier, int colCount, Component ... components) {
        int rows = components.length / colCount;
        if (components.length % colCount > 0) {
            ++rows;
        }
        JPanel panel = new JPanel(new GridLayout(rows, colCount));
        for (Component comp : components) {
            panel.add(comp);
            widthUnifier.add(comp);
        }
        for (int i = components.length; i < rows * colCount; ++i) {
            panel.add(new JLabel());
        }
        return panel;
    }

    public void adaptValuesToModel() {
        if (this.wageHolidaySetModel != null) {
            this.wageHolidaySetModel.setName(this.name.getText());
            this.wageHolidaySetModel.setNewYear(this.newYear.isSelected());
            this.wageHolidaySetModel.setThreeHolyKings(this.threeHolyKings.isSelected());
            this.wageHolidaySetModel.setGoodFriday(this.goodFriday.isSelected());
            this.wageHolidaySetModel.setEasterMonday(this.easterMonday.isSelected());
            this.wageHolidaySetModel.setLaborDay(this.laborDay.isSelected());
            this.wageHolidaySetModel.setAscensionDay(this.ascensionDay.isSelected());
            this.wageHolidaySetModel.setWhitMonday(this.whitMonday.isSelected());
            this.wageHolidaySetModel.setCorpusChristi(this.corpusChristi.isSelected());
            this.wageHolidaySetModel.setAssumptionDay(this.assumptionDay.isSelected());
            this.wageHolidaySetModel.setGermanUnityDay(this.germanUnityDay.isSelected());
            this.wageHolidaySetModel.setReformationDay(this.reformationDay.isSelected());
            this.wageHolidaySetModel.setAllSaintsDay(this.allSaintsDay.isSelected());
            this.wageHolidaySetModel.setPenanceDay(this.penanceDay.isSelected());
            this.wageHolidaySetModel.setFirstChristmasDay(this.firstChristmasDay.isSelected());
            this.wageHolidaySetModel.setSecondChristmasDay(this.secondChristmasDay.isSelected());
            this.wageHolidaySetModel.setPeacePartyDay(this.peacePartyDay.isSelected());
            this.wageHolidaySetModel.setMonday(this.monday.isSelected());
            this.wageHolidaySetModel.setTuesday(this.tuesday.isSelected());
            this.wageHolidaySetModel.setWednesday(this.wednesday.isSelected());
            this.wageHolidaySetModel.setThursday(this.thursday.isSelected());
            this.wageHolidaySetModel.setFriday(this.friday.isSelected());
            this.wageHolidaySetModel.setSaturday(this.saturday.isSelected());
            this.wageHolidaySetModel.setSunday(this.sunday.isSelected());
        }
    }

    public void setWageHolidaySetModel(WageHolidaySetModel wageHolidaySetModel) {
        this.wageHolidaySetModel = wageHolidaySetModel;
        if (this.wageHolidaySetModel == null) {
            this.setEnabled(false);
            this.name.setText("");
            this.newYear.setSelected(false);
            this.threeHolyKings.setSelected(false);
            this.goodFriday.setSelected(false);
            this.easterMonday.setSelected(false);
            this.laborDay.setSelected(false);
            this.ascensionDay.setSelected(false);
            this.whitMonday.setSelected(false);
            this.corpusChristi.setSelected(false);
            this.assumptionDay.setSelected(false);
            this.germanUnityDay.setSelected(false);
            this.reformationDay.setSelected(false);
            this.allSaintsDay.setSelected(false);
            this.penanceDay.setSelected(false);
            this.firstChristmasDay.setSelected(false);
            this.secondChristmasDay.setSelected(false);
            this.peacePartyDay.setSelected(false);
            this.monday.setSelected(false);
            this.tuesday.setSelected(false);
            this.wednesday.setSelected(false);
            this.thursday.setSelected(false);
            this.friday.setSelected(false);
            this.saturday.setSelected(false);
            this.sunday.setSelected(false);
            SpecialHolidayTableModel model = (SpecialHolidayTableModel)this.specialHolidayTable.getModel();
            model.setWageHolidaySet(null);
        } else {
            this.name.setText(wageHolidaySetModel.getName());
            this.newYear.setSelected(wageHolidaySetModel.getNewYear());
            this.threeHolyKings.setSelected(wageHolidaySetModel.getThreeHolyKings());
            this.goodFriday.setSelected(wageHolidaySetModel.getGoodFriday());
            this.easterMonday.setSelected(wageHolidaySetModel.getEasterMonday());
            this.laborDay.setSelected(wageHolidaySetModel.getLaborDay());
            this.ascensionDay.setSelected(wageHolidaySetModel.getAscensionDay());
            this.whitMonday.setSelected(wageHolidaySetModel.getWhitMonday());
            this.corpusChristi.setSelected(wageHolidaySetModel.getCorpusChristi());
            this.assumptionDay.setSelected(wageHolidaySetModel.getAssumptionDay());
            this.germanUnityDay.setSelected(wageHolidaySetModel.getGermanUnityDay());
            this.reformationDay.setSelected(wageHolidaySetModel.getReformationDay());
            this.allSaintsDay.setSelected(wageHolidaySetModel.getAllSaintsDay());
            this.penanceDay.setSelected(wageHolidaySetModel.getPenanceDay());
            this.firstChristmasDay.setSelected(wageHolidaySetModel.getFirstChristmasDay());
            this.secondChristmasDay.setSelected(wageHolidaySetModel.getSecondChristmasDay());
            this.peacePartyDay.setSelected(wageHolidaySetModel.getPeacePartyDay());
            this.monday.setSelected(wageHolidaySetModel.getMonday());
            this.tuesday.setSelected(wageHolidaySetModel.getTuesday());
            this.wednesday.setSelected(wageHolidaySetModel.getWednesday());
            this.thursday.setSelected(wageHolidaySetModel.getThursday());
            this.friday.setSelected(wageHolidaySetModel.getFriday());
            this.saturday.setSelected(wageHolidaySetModel.getSaturday());
            this.sunday.setSelected(wageHolidaySetModel.getSunday());
            SpecialHolidayTableModel model = (SpecialHolidayTableModel)this.specialHolidayTable.getModel();
            model.setWageHolidaySet(wageHolidaySetModel);
            this.setEnabled(true);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.name.setEnabled(enabled);
        this.newYear.setEnabled(enabled);
        this.threeHolyKings.setEnabled(enabled);
        this.goodFriday.setEnabled(enabled);
        this.easterMonday.setEnabled(enabled);
        this.laborDay.setEnabled(enabled);
        this.ascensionDay.setEnabled(enabled);
        this.whitMonday.setEnabled(enabled);
        this.corpusChristi.setEnabled(enabled);
        this.assumptionDay.setEnabled(enabled);
        this.germanUnityDay.setEnabled(enabled);
        this.reformationDay.setEnabled(enabled);
        this.allSaintsDay.setEnabled(enabled);
        this.penanceDay.setEnabled(enabled);
        this.firstChristmasDay.setEnabled(enabled);
        this.secondChristmasDay.setEnabled(enabled);
        this.peacePartyDay.setEnabled(enabled);
        this.monday.setEnabled(enabled);
        this.tuesday.setEnabled(enabled);
        this.wednesday.setEnabled(enabled);
        this.thursday.setEnabled(enabled);
        this.friday.setEnabled(enabled);
        this.saturday.setEnabled(enabled);
        this.sunday.setEnabled(enabled);
        this.specialHolidayTable.setEnabled(enabled);
        this.addSpecialHoliday.setEnabled(enabled);
        int[] selectedRows = this.specialHolidayTable.getSelectedRows();
        this.removeSpecialHoliday.setEnabled(enabled && selectedRows != null && selectedRows.length > 0);
    }

    private class DayIntegerEditor
    extends DefaultCellEditor
    implements TableCellRenderer {
        private static final long serialVersionUID = 6434814994226267524L;
        private ListCellRenderer defaultRenderer;
        private MonthRenderer monthRenderer;
        private TableCellRenderer defaultTableCellRenderer;

        public DayIntegerEditor(TableCellRenderer defaultTableCellRenderer) {
            super(new JComboBox(new DefaultComboBoxModel()));
            JComboBox box = (JComboBox)this.editorComponent;
            this.defaultRenderer = box.getRenderer();
            this.monthRenderer = new MonthRenderer();
            this.defaultTableCellRenderer = defaultTableCellRenderer;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JComboBox box = (JComboBox)this.editorComponent;
            switch (column) {
                case 1: {
                    this.setBoxValues(0, 11);
                    box.setRenderer(this.monthRenderer);
                    break;
                }
                case 2: {
                    Integer month = (Integer)table.getValueAt(row, 1);
                    int dayCount = TimeUtil.getDayCountForMonth(2004, month);
                    this.setBoxValues(1, dayCount);
                    box.setRenderer(this.defaultRenderer);
                }
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        private void setBoxValues(int lower, int upper) {
            JComboBox box = (JComboBox)this.editorComponent;
            DefaultComboBoxModel dcm = (DefaultComboBoxModel)box.getModel();
            dcm.removeAllElements();
            for (int i = lower; i <= upper; ++i) {
                dcm.addElement(i);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object nValue = value;
            if (column == 1) {
                nValue = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.month." + TimeUtil.getConstantNameForMonth((Integer)value), new Serializable[0]);
            }
            return this.defaultTableCellRenderer.getTableCellRendererComponent(table, nValue, isSelected, hasFocus, row, column);
        }

        private class MonthRenderer
        implements ListCellRenderer {
            private MonthRenderer() {
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Integer iValue = (Integer)value;
                String s = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.month." + TimeUtil.getConstantNameForMonth(iValue), new Serializable[0]);
                return DayIntegerEditor.this.defaultRenderer.getListCellRendererComponent(list, s, index, isSelected, cellHasFocus);
            }
        }
    }

    private class SpecialWageHolidayListSelectionListener
    implements ListSelectionListener {
        private SpecialWageHolidayListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int[] selectedRows = HolidaySetPane.this.specialHolidayTable.getSelectedRows();
            HolidaySetPane.this.removeSpecialHoliday.setEnabled(selectedRows != null && selectedRows.length > 0);
        }
    }

    private class RemoveSpecialHolidayAction
    extends AbstractAction {
        private static final long serialVersionUID = 5333752973223416908L;

        public RemoveSpecialHolidayAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.remove", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int s = HolidaySetPane.this.specialHolidayTable.getSelectedRow();
            if (s >= 0) {
                SpecialHolidayTableModel model = (SpecialHolidayTableModel)HolidaySetPane.this.specialHolidayTable.getModel();
                SpecialWageHolidayModel specialWageHoliday = model.getSpecialWageHolidayAt(s);
                specialWageHoliday.setWageHolidaySet(null);
                specialWageHoliday.delete();
                model.setWageHolidaySet(HolidaySetPane.this.wageHolidaySetModel);
            }
        }
    }

    private class AddSpecialHolidayAction
    extends AbstractAction {
        private static final long serialVersionUID = 1794286334963113476L;

        public AddSpecialHolidayAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpecialWageHolidayModelImpl specialWageHoliday = new SpecialWageHolidayModelImpl();
            specialWageHoliday.setDay(1);
            specialWageHoliday.setMonth(0);
            specialWageHoliday.setName("");
            specialWageHoliday.setWageHolidaySet(HolidaySetPane.this.wageHolidaySetModel);
            SpecialHolidayTableModel model = (SpecialHolidayTableModel)HolidaySetPane.this.specialHolidayTable.getModel();
            model.setWageHolidaySet(HolidaySetPane.this.wageHolidaySetModel);
        }
    }
}

