/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.wage.gui.history.search;

import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.client.util.wage.HistoryAreaTourModelWageResult;
import de.datomino.peppergis.client.util.wage.WageDeltaModelUtil;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.wage.ProductWeightParameter;
import de.datomino.util.time.TimeUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class HistoryAreaTourTableModel
implements TableModel {
    private List<Tupel<Integer, HistoryAreaTourModelWageResult>> historyTours = Collections.emptyList();
    private List<TableModelListener> tableModelListeners = new ArrayList<TableModelListener>();

    @Override
    public int getRowCount() {
        return this.historyTours.size();
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return " \n#\n \n";
            }
            case 1: {
                return " \n" + ModelEnviroment.getMessageResolver().resolveMessage("gui.date.date", new Serializable[0]);
            }
            case 2: {
                return " \n" + ModelEnviroment.getMessageResolver().resolveMessage("messages.area.layer", new Serializable[0]);
            }
            case 3: {
                return " \n" + ModelEnviroment.getMessageResolver().resolveMessage("gui.area.areaObject", new Serializable[0]);
            }
            case 4: {
                return " \n" + ModelEnviroment.getMessageResolver().resolveMessage("gui.deliveryRound", new Serializable[0]);
            }
            case 5: {
                return " \n" + ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.personNumber", new Serializable[0]);
            }
            case 6: {
                return " \n" + ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.personName", new Serializable[0]);
            }
            case 7: {
                return " \n" + ModelEnviroment.getMessageResolver().resolveMessage("messages.offer.deliveryTime", new Serializable[0]);
            }
            case 8: {
                return " \n" + ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.difference.header", new Serializable[0]);
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Tupel<Integer, HistoryAreaTourModelWageResult> tupel = this.historyTours.get(rowIndex);
        HistoryAreaTourModelWageResult result = tupel.getElement2();
        HistoryAreaTourModel model = result.getModel();
        AreaDelivererModel deliverer = model.getDeliverer();
        switch (columnIndex) {
            case 0: {
                return tupel.getElement1();
            }
            case 1: {
                return TimeUtil.formatDate(model.getDate(), FormUtil.DATEFORMAT);
            }
            case 2: {
                return model.getLayerName();
            }
            case 3: {
                return model.getShortcut();
            }
            case 4: {
                return StringUtil.getNotNull(model.getDeliveryRound());
            }
            case 5: {
                return deliverer == null ? "" : deliverer.getDelivererNumber();
            }
            case 6: {
                return deliverer == null ? "" : deliverer.getName();
            }
            case 7: {
                if (model.getLength() == null) {
                    return null;
                }
                long sum = model.getDuration() == null ? 0L : (long)model.getDuration().intValue();
                sum = (long)((double)sum + (result.getReceptionTimeSum() + result.getThrowTimeSum()));
                return TimeUtil.formatDurationSeparated(sum * 1000L);
            }
            case 8: {
                if (model.getLength() == null) {
                    return null;
                }
                Integer difference = WageDeltaModelUtil.getDifferenceTime(model);
                if (difference == null) break;
                int abs = Math.abs(difference);
                String time = (difference < 0 ? "-" : "") + TimeUtil.formatDurationToHourMinSec((long)abs * 1000L);
                return time;
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.tableModelListeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.tableModelListeners.remove(l);
    }

    public void setResults(List<HistoryAreaTourModel> models, ModelEnviroment modelEnviroment) {
        if (models == null) {
            this.historyTours = Collections.emptyList();
        } else {
            ProductWeightParameter productWeightParameter = modelEnviroment.getAllCaller().getWageCaller().getProductWeightParameter();
            TourCaller tourCaller = modelEnviroment.getAllCaller().getTourCaller();
            this.historyTours = new ArrayList<Tupel<Integer, HistoryAreaTourModelWageResult>>(models.size());
            int index = 0;
            for (HistoryAreaTourModel model : models) {
                this.historyTours.add(new Tupel<Integer, HistoryAreaTourModelWageResult>(++index, new HistoryAreaTourModelWageResult(model, productWeightParameter, tourCaller)));
            }
        }
        this.fireChanged();
    }

    private void fireChanged() {
        TableModelEvent e = new TableModelEvent(this);
        for (TableModelListener l : this.tableModelListeners) {
            l.tableChanged(e);
        }
    }

    public HistoryAreaTourModelWageResult getModelAt(int index) {
        HistoryAreaTourModelWageResult model = null;
        for (Tupel<Integer, HistoryAreaTourModelWageResult> tupel : this.historyTours) {
            if (!tupel.getElement1().equals(index)) continue;
            model = tupel.getElement2();
            break;
        }
        return model;
    }
}

