/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.wage.gui.history.search;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.MultiLineHeaderRenderer;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.client.wage.HistoryAreaTourDialog;
import de.datomino.peppergis.wage.gui.history.search.HistoryAreaTourTableModel;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class HistoryAreaTourSearchResultPane
extends JPanel {
    private static final long serialVersionUID = 9178566491216415257L;
    private JTable historyAreaTourTable;
    private ModelEnviroment modelEnviroment;

    public HistoryAreaTourSearchResultPane(ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
    }

    private void buildLayout() {
        final HistoryAreaTourTableModel tableModel = new HistoryAreaTourTableModel();
        this.historyAreaTourTable = new JTable(tableModel);
        this.historyAreaTourTable.setCellSelectionEnabled(false);
        this.historyAreaTourTable.setRowHeight(40);
        this.historyAreaTourTable.setRowMargin(5);
        this.historyAreaTourTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                this.popUp(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                this.popUp(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                this.popUp(e);
            }

            private void popUp(MouseEvent e) {
                if (!e.isConsumed() && e.getClickCount() == 2) {
                    int row = HistoryAreaTourSearchResultPane.this.historyAreaTourTable.rowAtPoint(e.getPoint());
                    if (row >= 0) {
                        Integer index = (Integer)HistoryAreaTourSearchResultPane.this.historyAreaTourTable.getValueAt(row, 0);
                        HistoryAreaTourDialog.createAndShow(CollectionUtil.buildArrayList(tableModel.getModelAt(index)), HistoryAreaTourSearchResultPane.this.modelEnviroment, SwingUtils.findWindowParent(HistoryAreaTourSearchResultPane.this));
                    }
                    e.consume();
                }
            }
        });
        TableColumnModel columnModel = this.historyAreaTourTable.getColumnModel();
        columnModel.getColumn(0).setMaxWidth(150);
        columnModel.getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){
            private static final long serialVersionUID = -6632639031595610954L;

            @Override
            public int getHorizontalAlignment() {
                return 0;
            }
        });
        MultiLineHeaderRenderer headerHenderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = columnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setHeaderRenderer(headerHenderer);
        }
        this.add(new JScrollPane(this.historyAreaTourTable));
    }

    public void setResults(List<HistoryAreaTourModel> models, ModelEnviroment modelEnviroment) {
        HistoryAreaTourTableModel historyAreaTourTableModel = (HistoryAreaTourTableModel)this.historyAreaTourTable.getModel();
        historyAreaTourTableModel.setResults(models, modelEnviroment);
    }
}

