/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.wage.gui.history.create;

import de.datomino.peppergis.PeppergisConstants;
import de.datomino.peppergis.client.gui.areatour.AbstractAreaTourCalculationOrderNotPossibleDialog;
import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.common.AbstractCommonDialog;
import de.datomino.peppergis.client.gui.common.DialogDisposeAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.wage.HistoryAreaTourDto;
import de.datomino.peppergis.dto.wage.WageExportDto;
import de.datomino.peppergis.exception.TourCalculationBlockException;
import de.datomino.peppergis.tour.CalculationWay;
import de.datomino.peppergis.wage.HistoryAreaTourSearchDto;
import de.datomino.peppergis.wage.gui.history.create.CreateHistoryAreaTourCalculationPane;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.swing.ErrorMessageDialog;
import de.datomino.util.swing.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.ktde.util.datatypes.Tupel;

public class CreateHistoryAreaToursDialog
extends AbstractCommonDialog {
    private static final long serialVersionUID = -2376406089786430299L;
    private Component parent;
    private List<HistoryAreaTourModel> result = new ArrayList<HistoryAreaTourModel>();
    private CreateHistoryAreaTourCalculationPane areaTourCalculationPane;

    public CreateHistoryAreaToursDialog(ModelEnviroment modelEnviroment, Component parent) {
        super(modelEnviroment, parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.offer.deliveryTime.calc", new Serializable[0]), Dialog.ModalityType.DOCUMENT_MODAL);
        this.areaTourCalculationPane = new CreateHistoryAreaTourCalculationPane(modelEnviroment);
        this.parent = parent;
        this.buildLayout();
        this.pack();
        SwingUtils.center((Window)this, parent);
    }

    @Override
    protected Component getMainComponent() {
        return this.areaTourCalculationPane;
    }

    @Override
    protected Action getOkAction() {
        return new DialogDisposeAction(this, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = 6534772809889708649L;

            @Override
            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                CreateHistoryAreaToursDialog.this.startCalculation();
            }
        };
    }

    @Override
    protected Action getCancelAction() {
        return new DialogDisposeAction(this);
    }

    private void startCalculation() {
        Tupel<Collection<Tupel<AreaObjectModel, List<Model>>>, Collection<Tupel<AreaObjectModel, List<Model>>>> tupel = this.areaTourCalculationPane.checkForBrokenOrders();
        final Collection<Tupel<AreaObjectModel, List<Model>>> origAreas = tupel.getElement1();
        final Collection<Tupel<AreaObjectModel, List<Model>>> parcelAreas = tupel.getElement2();
        if (origAreas.isEmpty() && parcelAreas.isEmpty()) {
            this.startCalculation(this.areaTourCalculationPane.getSelectedAreaObjects(null), null);
        } else {
            AbstractAreaTourCalculationOrderNotPossibleDialog areaTourCalculationOrderNotPossibleDialog = new AbstractAreaTourCalculationOrderNotPossibleDialog(SwingUtils.findWindowParent(this.parent), origAreas, parcelAreas){
                private static final long serialVersionUID = -3689211896628686728L;

                @Override
                protected void doOk(Collection<Tupel<AreaObjectModel, List<Model>>> areaObjectsToSkip, Collection<Tupel<AreaObjectModel, List<Model>>> areaObjectsForOptimize, Collection<Tupel<AreaObjectModel, List<Model>>> areaObjectsForOrig, Collection<Tupel<AreaObjectModel, List<Model>>> areaObjectsForParcel) {
                    Collection selectedAreaObjects = CreateHistoryAreaToursDialog.this.areaTourCalculationPane.getSelectedAreaObjects(null);
                    CollectionUtil.setifyByFirst(selectedAreaObjects);
                    CollectionUtil.removeFromOnlyFirstMatch(selectedAreaObjects, origAreas);
                    CollectionUtil.removeFromOnlyFirstMatch(selectedAreaObjects, parcelAreas);
                    LinkedList<Tupel<Object, Object>> toOptimize = new LinkedList<Tupel<Object, Object>>();
                    LinkedList<Tupel<Object, Object>> toOrig = new LinkedList<Tupel<Object, Object>>();
                    LinkedList<Tupel<Object, Object>> toParcel = new LinkedList<Tupel<Object, Object>>();
                    switch (CreateHistoryAreaToursDialog.this.areaTourCalculationPane.getSelectedCalculationWay()) {
                        case OPTIMIZE: {
                            toOptimize.addAll(selectedAreaObjects);
                            break;
                        }
                        case PARCEL_ORDER: {
                            toParcel.addAll(selectedAreaObjects);
                            break;
                        }
                        case SAVED_ORDER: {
                            toOrig.addAll(selectedAreaObjects);
                            break;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                    toOptimize.addAll(areaObjectsForOptimize);
                    toOrig.addAll(areaObjectsForOrig);
                    toParcel.addAll(areaObjectsForParcel);
                    if (!toOptimize.isEmpty()) {
                        CreateHistoryAreaToursDialog.this.startCalculation(toOptimize, CalculationWay.OPTIMIZE);
                    }
                    if (!toOrig.isEmpty()) {
                        CreateHistoryAreaToursDialog.this.startCalculation(toOrig, CalculationWay.SAVED_ORDER);
                    }
                    if (!toParcel.isEmpty()) {
                        CreateHistoryAreaToursDialog.this.startCalculation(toParcel, CalculationWay.PARCEL_ORDER);
                    }
                }
            };
            areaTourCalculationOrderNotPossibleDialog.setVisible(true);
        }
    }

    private void startCalculation(Collection<Tupel<AreaObjectModel, List<Model>>> areas, CalculationWay calculationWay) {
        final HashSet<String> shortcuts = new HashSet<String>();
        for (Tupel<AreaObjectModel, List<Model>> area : areas) {
            shortcuts.add(area.getElement1().getShortcut());
        }
        final AreaLayerModel selectedAreaLayer = this.areaTourCalculationPane.getSelectedAreaLayer();
        if (selectedAreaLayer != null) {
            String title = ModelEnviroment.getMessageResolver().resolveMessage("messages.offer.deliveryTime.calc", new Serializable[0]);
            String message = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.pleaseWait", new Serializable[0]);
            boolean pdf = this.modelEnviroment.getAllCaller().getWageCaller().isHistoryAreaTourPdfCreationActive();
            AbstractAsynchronousDialog<WageExportDto> asynchronousDialog = new AbstractAsynchronousDialog<WageExportDto>(SwingUtils.findWindowParent(this.parent), title, message, pdf ? 2 : 1, true, this.getModelEnviroment()){
                private static final long serialVersionUID = 1084151788252987922L;

                @Override
                protected AsynchronousDto<WageExportDto> getAsynchronousDto(String token) {
                    ModelEnviroment modelEnviroment = super.getModelEnviroment();
                    return modelEnviroment.getAllCaller().getAsynchronousCaller().getCreateHistoryAreaToursResult(token);
                }

                @Override
                protected String startAsynchronous() {
                    HistoryAreaTourSearchDto searchDto = new HistoryAreaTourSearchDto(selectedAreaLayer.getDisplayname(), shortcuts, CreateHistoryAreaToursDialog.this.areaTourCalculationPane.getDate(), null, null);
                    return this.getModelEnviroment().getAllCaller().getAsynchronousCaller().createHistoryAreaTours(searchDto);
                }
            };
            try {
                Tupel tourExportDto = asynchronousDialog.run();
                if (tourExportDto.getElement1() == null) {
                    return;
                }
                if (((WageExportDto)tourExportDto.getElement1()).getErrorMessages() != null && ((WageExportDto)tourExportDto.getElement1()).getErrorMessages().hasErrors()) {
                    ErrorMessageDialog error = new ErrorMessageDialog(SwingUtils.findWindowParent(this.parent), ModelEnviroment.getMessageResolver(), ((WageExportDto)tourExportDto.getElement1()).getErrorMessages(), PeppergisConstants.ICON_IMAGE);
                    error.setVisible(true);
                } else {
                    SortedSet<String> sortedSet;
                    this.result.clear();
                    for (HistoryAreaTourDto historyAreaTourDto : ((WageExportDto)tourExportDto.getElement1()).getDtos()) {
                        if (historyAreaTourDto == null) continue;
                        this.result.add((HistoryAreaTourModel)this.getModelEnviroment().getModelCache().getModel(historyAreaTourDto));
                    }
                    StringBuilder sb = new StringBuilder(ModelEnviroment.getMessageResolver().resolveMessage("gui.area.successful", new Serializable[0]) + ":\n");
                    for (String string : ((WageExportDto)tourExportDto.getElement1()).getSuccessFullShortcuts()) {
                        sb.append("\n").append(string);
                    }
                    sb.append("\n\n" + ModelEnviroment.getMessageResolver().resolveMessage("gui.area.failed", new Serializable[0]) + ":\n");
                    for (String string : ((WageExportDto)tourExportDto.getElement1()).getFailedShortcuts()) {
                        sb.append("\n").append(string);
                    }
                    SortedSet<String> sortedSet2 = ((WageExportDto)tourExportDto.getElement1()).getEmptyShortcuts();
                    if (!sortedSet2.isEmpty()) {
                        sb.append("\n\n" + ModelEnviroment.getMessageResolver().resolveMessage("gui.area.noDeliveryRound", new Serializable[0]) + ":\n");
                        for (String string : sortedSet2) {
                            sb.append("\n").append(string);
                        }
                    }
                    if (!(sortedSet = ((WageExportDto)tourExportDto.getElement1()).getNoProductShortcuts()).isEmpty()) {
                        sb.append("\n\n" + ModelEnviroment.getMessageResolver().resolveMessage("gui.area.noProductForDr", new Serializable[0]) + ":\n");
                        for (String shortcut : sortedSet) {
                            sb.append("\n").append(shortcut);
                        }
                    }
                    JTextArea jTextArea = new JTextArea(sb.toString(), 20, 100);
                    jTextArea.setEditable(false);
                    JOptionPane.showMessageDialog(SwingUtils.findWindowParent(this.parent), new JScrollPane(jTextArea), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.protocol", new Serializable[0]), 1);
                }
            }
            catch (TourCalculationBlockException ex) {
                JOptionPane.showMessageDialog(SwingUtils.findWindowParent(this.parent), ModelEnviroment.getMessageResolver().resolveMessage("messages.tourCalculation.blocked", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]), 1);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public List<HistoryAreaTourModel> getResult() {
        return this.result;
    }

    public static List<HistoryAreaTourModel> show(ModelEnviroment modelEnviroment, Component parent) {
        Window window = SwingUtils.findWindowParent(parent);
        CreateHistoryAreaToursDialog dialog = new CreateHistoryAreaToursDialog(modelEnviroment, window);
        dialog.setModal(true);
        dialog.pack();
        SwingUtils.center((Window)dialog, parent);
        dialog.setVisible(true);
        return dialog.getResult();
    }
}

