/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.wage.gui.deliveryRound;

import de.datomino.peppergis.client.communication.WageCaller;
import de.datomino.peppergis.client.gui.area.AreaLayerComboBox;
import de.datomino.peppergis.client.gui.common.AbstractModelComboBox;
import de.datomino.peppergis.client.gui.common.TableCellComponentEditor;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.AbstractTableRenderer;
import de.datomino.peppergis.client.gui.renderer.MultiLineHeaderRenderer;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.client.model.wage.WageParameterModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.peppergis.type.WageParameterStatus;
import de.datomino.peppergis.util.StringComparator;
import de.datomino.peppergis.wage.gui.deliveryRound.DeliveryRoundConfigrationDialog;
import de.datomino.util.swing.TableHeaderWithComponentLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class DeliveryRoundWeekdayPlanPane
extends JPanel {
    private static final long serialVersionUID = -7917905256544227862L;
    private static final int PLAN_TABLE_COLUMN_SIZE = 8;
    private JComboBox<String> planAreaFilter = new JComboBox();
    private List<WageParameterModel> wageParameters;
    private AreaLayerComboBox layerComboBox;
    private DeliveryRoundConfigrationDialog parent;

    public DeliveryRoundWeekdayPlanPane(DeliveryRoundConfigrationDialog parent) {
        super(new BorderLayout());
        this.parent = parent;
        WageCaller wageCaller = parent.getModelEnviroment().getAllCaller().getWageCaller();
        WageParameterStatus[] statuses = new WageParameterStatus[]{WageParameterStatus.ACTIVE, WageParameterStatus.DEFAULT};
        this.wageParameters = new ArrayList<WageParameterModel>(wageCaller.fetchWageParameterWithStatus(statuses));
        Collections.sort(this.wageParameters, new StringComparator<WageParameterModel>(true){

            @Override
            protected String getString(WageParameterModel o) {
                return o.getName();
            }
        });
        this.initialize();
    }

    @Override
    public void repaint(long tm) {
        HashSet<AreaLayerModel> layers = new HashSet<AreaLayerModel>();
        for (AreaObjectModel area : this.parent.getSelectedAreas()) {
            layers.add(area.getAreaLayer());
        }
        this.layerComboBox.setModels(layers);
        super.repaint(tm);
    }

    private void initialize() {
        this.layerComboBox = new AreaLayerComboBox((Collection<AreaLayerModel>)new HashSet<AreaLayerModel>(), false);
        this.add((Component)this.layerComboBox, "North");
        final JTable planTable = this.createPlanTable();
        JScrollPane scrollPane = new JScrollPane(planTable);
        scrollPane.setBorder(new EmptyBorder(10, 0, 0, 0));
        this.add((Component)scrollPane, "Center");
        this.layerComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DeliveryRoundWeekdayPlanPane.this.planAreaFilter.setSelectedItem(null);
                    DeliveryRoundWeekdayPlanPane.this.sortAndFilterPlanTable(planTable, (AreaLayerModel)DeliveryRoundWeekdayPlanPane.this.layerComboBox.getSelectedItem(), true);
                }
            }
        });
        this.planAreaFilter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DeliveryRoundWeekdayPlanPane.this.sortAndFilterPlanTable(planTable, (AreaLayerModel)DeliveryRoundWeekdayPlanPane.this.layerComboBox.getSelectedItem(), false);
                }
            }
        });
        this.parent.getRoundList().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DeliveryRoundModel selectedValue = DeliveryRoundWeekdayPlanPane.this.parent.getRoundList().getSelectedValue();
                if (selectedValue == null) {
                    DeliveryRoundWeekdayPlanPane.this.parent.getSelectedAreas().clear();
                    DeliveryRoundWeekdayPlanPane.this.layerComboBox.setEnabled(false);
                    planTable.removeAll();
                } else if (!selectedValue.equals(DeliveryRoundWeekdayPlanPane.this.parent.getEditPane().getDeliveryRound())) {
                    DeliveryRoundWeekdayPlanPane.this.parent.getSelectedAreas().clear();
                    DeliveryRoundWeekdayPlanPane.this.layerComboBox.setEnabled(true);
                    DeliveryRoundWeekdayPlanPane.this.layerComboBox.removeAllItems();
                    Object[][] data = new Object[0][8];
                    DefaultTableModel tm = (DefaultTableModel)planTable.getModel();
                    tm.setDataVector(data, DeliveryRoundWeekdayPlanPane.this.createColumnHeader());
                    tm.fireTableDataChanged();
                    DeliveryRoundWeekdayPlanPane.this.setPlanTableStyle(planTable);
                    DeliveryRoundWeekdayPlanPane.this.parent.pack();
                }
            }
        });
    }

    private JTable createPlanTable() {
        DefaultTableModel tm = new DefaultTableModel();
        tm.setColumnIdentifiers(this.createColumnHeader());
        JTable planTable = new JTable(tm);
        this.setPlanTableStyle(planTable);
        return planTable;
    }

    private String[] createColumnHeader() {
        String[] columnHeader = new String[]{ModelEnviroment.getMessageResolver().resolveMessage("messages.area.area1", new Serializable[0]) + "\n \n \n", ModelEnviroment.getMessageResolver().resolveMessage("gui.date.monday.short", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("gui.date.tuesday.short", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("gui.date.wednesday.short", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("gui.date.thursday.short", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("gui.date.friday.short", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("gui.date.saturday.short", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("gui.date.sunday.short", new Serializable[0])};
        return columnHeader;
    }

    private Object[][] createPlanTableData(List<AreaObjectModel> areas) {
        Object[][] data = new Object[areas.size()][8];
        int row = 0;
        for (AreaObjectModel area : areas) {
            data[row] = new Object[8];
            data[row][0] = area;
            for (int column = 1; column < 8; ++column) {
                data[row][column] = this.getWeekdayParameter(area, column);
            }
            ++row;
        }
        return data;
    }

    private void setPlanTableStyle(final JTable planTable) {
        planTable.setCellSelectionEnabled(false);
        planTable.setRowHeight(25);
        planTable.setRowMargin(5);
        MultiLineHeaderRenderer headerHenderer = new MultiLineHeaderRenderer();
        int col = 0;
        Enumeration<TableColumn> enumeration = planTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setPreferredWidth(250);
            tableColumn.setHeaderRenderer(headerHenderer);
            if (col == 0) {
                tableColumn.setCellRenderer(new AbstractTableRenderer(){

                    @Override
                    protected String getString(Object value) {
                        return value == null ? "" : DeliveryRoundWeekdayPlanPane.this.areaToString((AreaObjectModel)value);
                    }
                });
            } else {
                final int fCol = col;
                tableColumn.setCellRenderer(new TableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        AreaObjectModel area = (AreaObjectModel)table.getValueAt(row, 0);
                        WageParameterModel parameter = DeliveryRoundWeekdayPlanPane.this.getWeekdayParameter(area, column);
                        JLabel label = new JLabel(parameter == null ? null : parameter.getName());
                        label.setVerticalAlignment(0);
                        label.setHorizontalAlignment(2);
                        label.setFont(table.getFont());
                        return label;
                    }
                });
                tableColumn.setCellEditor(new TableCellComponentEditor<JComboBox<WageParameterModel>>(planTable){

                    @Override
                    public void selectEditor(MouseEvent e) {
                        int row = e == null ? planTable.getSelectionModel().getAnchorSelectionIndex() : planTable.rowAtPoint(e.getPoint());
                        this.comboBoxEditor = new DefaultCellEditor(DeliveryRoundWeekdayPlanPane.this.createParameterComboBox(row, fCol, planTable));
                    }
                });
            }
            ++col;
        }
        JTableHeader th = planTable.getTableHeader();
        th.setLayout(new TableHeaderWithComponentLayout());
        th.add(this.planAreaFilter, (Object)0);
        for (col = 1; col < 8; ++col) {
            final AbstractModelComboBox<WageParameterModel> comboBox = new AbstractModelComboBox<WageParameterModel>(this.wageParameters, true){
                private static final long serialVersionUID = -8941673942606361611L;

                @Override
                protected String getStringRepresentation(WageParameterModel t) {
                    return t == null ? "" : t.getName();
                }
            };
            final int fCol = col;
            comboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DeliveryRoundWeekdayPlanPane.this.setWeekdayParameter((WageParameterModel)comboBox.getSelectedItem(), planTable, fCol);
                    planTable.repaint(10L);
                }
            });
            th.add((Component)comboBox, (Object)col);
        }
    }

    private void setWeekdayParameter(WageParameterModel parameter, JTable planTable, int column) {
        for (int row = 0; row < planTable.getRowCount(); ++row) {
            Object value = planTable.getValueAt(row, 0);
            this.setWeekdayParameter((AreaObjectModel)value, parameter, column);
        }
    }

    private JComboBox<WageParameterModel> createParameterComboBox(int row, final int column, final JTable planTable) {
        final AbstractModelComboBox<WageParameterModel> comboBox = new AbstractModelComboBox<WageParameterModel>(this.wageParameters, true){
            private static final long serialVersionUID = -8941673942606361611L;

            @Override
            protected String getStringRepresentation(WageParameterModel t) {
                return t == null ? "" : t.getName();
            }
        };
        final AreaObjectModel area = (AreaObjectModel)planTable.getValueAt(row, 0);
        WageParameterModel parameter = this.getWeekdayParameter(area, column);
        comboBox.setSelectedItem(parameter);
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DeliveryRoundWeekdayPlanPane.this.setWeekdayParameter(area, (WageParameterModel)comboBox.getSelectedItem(), column);
                    planTable.repaint(10L);
                }
            }
        });
        return comboBox;
    }

    private void setWeekdayParameter(AreaObjectModel area, WageParameterModel parameter, int column) {
        DeliveryRoundConfigrationDialog.DeliveryRoundEntity entity = this.parent.getDeliveryRoundMap().get(area);
        DeliveryRoundModel round = this.parent.getRoundList().getSelectedValue();
        switch (column) {
            case 1: {
                entity.monday.put(round, parameter);
                break;
            }
            case 2: {
                entity.tuesday.put(round, parameter);
                break;
            }
            case 3: {
                entity.wednesday.put(round, parameter);
                break;
            }
            case 4: {
                entity.thursday.put(round, parameter);
                break;
            }
            case 5: {
                entity.friday.put(round, parameter);
                break;
            }
            case 6: {
                entity.saturday.put(round, parameter);
                break;
            }
            case 7: {
                entity.sunday.put(round, parameter);
                break;
            }
        }
    }

    private WageParameterModel getWeekdayParameter(AreaObjectModel area, int column) {
        WageParameterModel parameter;
        DeliveryRoundConfigrationDialog.DeliveryRoundEntity entity = this.parent.getDeliveryRoundMap().get(area);
        DeliveryRoundModel round = this.parent.getRoundList().getSelectedValue();
        switch (column) {
            case 1: {
                parameter = entity.monday.get(round);
                break;
            }
            case 2: {
                parameter = entity.tuesday.get(round);
                break;
            }
            case 3: {
                parameter = entity.wednesday.get(round);
                break;
            }
            case 4: {
                parameter = entity.thursday.get(round);
                break;
            }
            case 5: {
                parameter = entity.friday.get(round);
                break;
            }
            case 6: {
                parameter = entity.saturday.get(round);
                break;
            }
            case 7: {
                parameter = entity.sunday.get(round);
                break;
            }
            default: {
                parameter = null;
            }
        }
        return parameter;
    }

    private void fillPlanAreaFilter(List<AreaObjectModel> areas) {
        ArrayList<String> list = new ArrayList<String>();
        for (int row = 0; row < areas.size(); ++row) {
            AreaObjectModel area = areas.get(row);
            list.add(this.areaToString(area));
        }
        Collections.sort(list, new StringComparator(true));
        list.add(0, "");
        this.planAreaFilter.removeAllItems();
        for (String s : list) {
            this.planAreaFilter.addItem(s);
        }
    }

    private String areaToString(AreaObjectModel area) {
        return AreaObjectModelUtil.getShortcutAndDisplayname(area);
    }

    private void sortAndFilterPlanTable(JTable planTable, AreaLayerModel layer, boolean initFilter) {
        Object selected = this.planAreaFilter.getSelectedItem();
        ArrayList<AreaObjectModel> filtered = new ArrayList<AreaObjectModel>();
        for (AreaObjectModel area : this.parent.getSelectedAreas()) {
            if (!area.getAreaLayer().equals(layer) || selected != null && !selected.equals("") && !selected.equals(this.areaToString(area))) continue;
            filtered.add(area);
        }
        Collections.sort(filtered, new StringComparator<AreaObjectModel>(true){

            @Override
            protected String getString(AreaObjectModel o) {
                return DeliveryRoundWeekdayPlanPane.this.areaToString(o);
            }
        });
        if (initFilter) {
            this.fillPlanAreaFilter(filtered);
        }
        Object[][] data = this.createPlanTableData(filtered);
        DefaultTableModel tm = (DefaultTableModel)planTable.getModel();
        tm.setDataVector(data, this.createColumnHeader());
        tm.fireTableDataChanged();
        this.setPlanTableStyle(planTable);
        planTable.repaint(10L);
    }
}

