/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.util;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class NightSurchargeTimeWindow
implements Serializable {
    private static final long serialVersionUID = -929663767305021056L;
    private int startHour;
    private int startMinute;
    private int endHour;
    private int endMinute;

    public NightSurchargeTimeWindow(int startHour, int startMinute, int endHour, int endMinute) {
        this.startHour = startHour;
        this.startMinute = startMinute;
        this.endHour = endHour;
        this.endMinute = endMinute;
    }

    public int getStartHour() {
        return this.startHour;
    }

    public void setStartHour(int startHour) {
        this.startHour = startHour;
    }

    public int getStartMinute() {
        return this.startMinute;
    }

    public void setStartMinute(int startMinute) {
        this.startMinute = startMinute;
    }

    public int getEndHour() {
        return this.endHour;
    }

    public void setEndHour(int endHour) {
        this.endHour = endHour;
    }

    public int getEndMinute() {
        return this.endMinute;
    }

    public void setEndMinute(int endMinute) {
        this.endMinute = endMinute;
    }

    public NightSurchargeTimeWindow clone() {
        return new NightSurchargeTimeWindow(this.startHour, this.startMinute, this.endHour, this.endMinute);
    }

    public String toString() {
        return this.format(this.startHour) + ":" + this.format(this.startMinute) + "-" + this.format(this.endHour) + ":" + this.format(this.endMinute);
    }

    public int nightSecondSum() {
        int nightSeconds = (this.endHour + 23 - this.startHour) * 3600;
        return nightSeconds += (this.endMinute + 60 - this.startMinute) * 60;
    }

    private String format(int i) {
        return StringUtils.leftPad(String.valueOf(i), 2, "0");
    }

    public int getNightSeconds(Date date) {
        if (date == null) {
            return 0;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        if (c.get(11) < this.startHour && c.get(11) > this.endHour) {
            return 0;
        }
        if (c.get(11) == this.startHour && c.get(12) < this.startMinute) {
            return 0;
        }
        if (c.get(11) == this.endHour && c.get(12) > this.endMinute) {
            return 0;
        }
        int nightSeconds = (c.get(11) + 23 - this.startHour) * 3600;
        nightSeconds += (c.get(12) + 60 - this.startMinute) * 60;
        return nightSeconds += c.get(13);
    }
}

