/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.util;

import de.datomino.logistic.dto.LogisticStopDto;
import de.datomino.logistic.dto.LogisticTourDto;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.logistic.type.StopType;
import de.datomino.peppergis.helper.PointEntityId;
import de.datomino.peppergis.tour.AreaTourParameter;
import de.datomino.peppergis.util.DefaultLogisticTourUtil;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.peppergis.util.NightSurchargeTimeWindow;
import de.datomino.peppergis.util.RewardEntity;
import de.datomino.util.NumericUtil;
import de.datomino.util.collection.CollectionUtil;
import java.util.List;
import org.ktde.util.datatypes.Tupel;

public class LogisticTourResult {
    private LogisticTourDto<PointEntityId> logisticTour;
    private Integer streetDistanceFromPoi = 0;
    private Integer streetDistanceToPoi = 0;
    private Integer streetDistanceFromPickPoint = 0;
    private Integer streetDistanceToPickPoint = 0;
    private Integer streetDurationFromPoi = 0;
    private Integer streetDurationToPoi = 0;
    private Integer streetDurationFromPickPoint = 0;
    private Integer streetDurationToPickPoint = 0;

    public LogisticTourResult(LogisticTourDto<PointEntityId> logisticTour) {
        this.logisticTour = logisticTour;
        List<LogisticStopDto<PointEntityId>> stopDtos = DefaultLogisticTourUtil.getAllStops(logisticTour);
        if (stopDtos.size() > 1) {
            LogisticStopDto<PointEntityId> firstStop = stopDtos.get(0);
            LogisticStopDto<PointEntityId> secondStop = stopDtos.get(1);
            int streetDistanceToSecond = NumericUtil.getIntegerValue(secondStop.getStreetMileageMetersFromStart());
            int streetDurationToSecond = NumericUtil.getIntegerValue(secondStop.getSecondsFromStart());
            if (!DefaultLogisticTourUtil.areSameAccess(firstStop.getLocation(), secondStop.getLocation(), null)) {
                double d0 = GeoUtil.calculateDistance(CollectionUtil.buildArrayList(firstStop.getLocation().getGeom(), firstStop.getLocation().getAccessGeom()));
                double d1 = GeoUtil.calculateDistance(CollectionUtil.buildArrayList(secondStop.getLocation().getGeom(), secondStop.getLocation().getAccessGeom()));
                int parcelLocationDurationRound = this.calculateParcelLocationDuration(logisticTour.getParcelLocation(), d0, d1);
                int parcelLocationDistanceRound = this.calculateParcelLocationDistance(logisticTour.getParcelLocation(), d0, d1);
                streetDistanceToSecond -= parcelLocationDistanceRound;
                streetDurationToSecond -= parcelLocationDurationRound;
            } else {
                streetDistanceToSecond = 0;
                streetDurationToSecond = 0;
            }
            if (firstStop.getStopType() == StopType.POI_START) {
                this.streetDistanceFromPoi = streetDistanceToSecond;
                this.streetDurationFromPoi = streetDurationToSecond;
            } else if (firstStop.getStopType() == StopType.PICK_POINT_START) {
                this.streetDistanceFromPickPoint = streetDistanceToSecond;
                this.streetDurationFromPickPoint = streetDurationToSecond;
            }
            LogisticStopDto<PointEntityId> lastStop = stopDtos.get(stopDtos.size() - 1);
            LogisticStopDto<PointEntityId> predLastStop = stopDtos.get(stopDtos.size() - 2);
            int streetDistanceToLast = NumericUtil.getIntegerValue(logisticTour.getDistanceSum()) - NumericUtil.getIntegerValue(predLastStop.getStreetMileageMetersFromStart());
            int streetDurationToLast = NumericUtil.getIntegerValue(logisticTour.getDurationSum()) - NumericUtil.getIntegerValue(predLastStop.getSecondsFromStart());
            if (!DefaultLogisticTourUtil.areSameAccess(lastStop.getLocation(), predLastStop.getLocation(), null)) {
                double d10 = GeoUtil.calculateDistance(CollectionUtil.buildArrayList(lastStop.getLocation().getGeom(), lastStop.getLocation().getAccessGeom()));
                double d11 = GeoUtil.calculateDistance(CollectionUtil.buildArrayList(predLastStop.getLocation().getGeom(), predLastStop.getLocation().getAccessGeom()));
                int parcelLocationDurationRound = this.calculateParcelLocationDuration(logisticTour.getTourParts().get(logisticTour.getTourParts().size() - 1).getParcelLocation(), d10, d11);
                int parcelLocationDistanceRound = this.calculateParcelLocationDistance(logisticTour.getTourParts().get(logisticTour.getTourParts().size() - 1).getParcelLocation(), d10, d11);
                streetDistanceToLast -= parcelLocationDistanceRound;
                streetDurationToLast -= parcelLocationDurationRound;
            } else {
                streetDistanceToLast = 0;
                streetDurationToLast = 0;
            }
            if (lastStop.getStopType() == StopType.POI_END) {
                this.streetDistanceToPoi = streetDistanceToLast;
                this.streetDurationToPoi = streetDurationToLast;
            } else if (stopDtos.get(stopDtos.size() - 1).getStopType() == StopType.PICK_POINT_END) {
                this.streetDistanceToPickPoint = streetDistanceToLast;
                this.streetDurationToPickPoint = streetDurationToLast;
            }
        }
        if (stopDtos.size() > 2) {
            LogisticStopDto<PointEntityId> secondStop = stopDtos.get(1);
            if (stopDtos.get(1).getStopType() == StopType.PICK_POINT_START) {
                LogisticStopDto<PointEntityId> thridStop = stopDtos.get(2);
                if (!DefaultLogisticTourUtil.areSameAccess(secondStop.getLocation(), thridStop.getLocation(), null)) {
                    double d1 = GeoUtil.calculateDistance(CollectionUtil.buildArrayList(secondStop.getLocation().getGeom(), secondStop.getLocation().getAccessGeom()));
                    double d2 = GeoUtil.calculateDistance(CollectionUtil.buildArrayList(thridStop.getLocation().getGeom(), thridStop.getLocation().getAccessGeom()));
                    int parcelLocationDurationRound = this.calculateParcelLocationDuration(logisticTour.getTourParts().get(0).getParcelLocation(), d1, d2);
                    int parcelLocationDistanceRound = this.calculateParcelLocationDistance(logisticTour.getTourParts().get(0).getParcelLocation(), d1, d2);
                    this.streetDistanceFromPickPoint = NumericUtil.getIntegerValue(thridStop.getStreetMileageMetersFromStart()) - NumericUtil.getIntegerValue(secondStop.getStreetMileageMetersFromStart()) - parcelLocationDistanceRound;
                    this.streetDurationFromPickPoint = NumericUtil.getIntegerValue(thridStop.getSecondsFromStart()) - NumericUtil.getIntegerValue(secondStop.getSecondsFromStart()) - parcelLocationDurationRound;
                }
            }
            if (stopDtos.get(stopDtos.size() - 2).getStopType() == StopType.PICK_POINT_END) {
                LogisticStopDto<PointEntityId> lastStop = stopDtos.get(stopDtos.size() - 2);
                LogisticStopDto<PointEntityId> predLastStop = stopDtos.get(stopDtos.size() - 3);
                if (!DefaultLogisticTourUtil.areSameAccess(lastStop.getLocation(), predLastStop.getLocation(), null)) {
                    double d10 = GeoUtil.calculateDistance(CollectionUtil.buildArrayList(lastStop.getLocation().getGeom(), lastStop.getLocation().getAccessGeom()));
                    double d11 = GeoUtil.calculateDistance(CollectionUtil.buildArrayList(predLastStop.getLocation().getGeom(), predLastStop.getLocation().getAccessGeom()));
                    int parcelLocationDurationRound = this.calculateParcelLocationDuration(logisticTour.getTourParts().get(logisticTour.getTourParts().size() - 1).getParcelLocation(), d10, d11);
                    int parcelLocationDistanceRound = this.calculateParcelLocationDistance(logisticTour.getTourParts().get(logisticTour.getTourParts().size() - 1).getParcelLocation(), d10, d11);
                    int predLastDistance = NumericUtil.getIntegerValue(lastStop.getStreetMileageMetersFromStart()) - NumericUtil.getIntegerValue(predLastStop.getStreetMileageMetersFromStart());
                    this.streetDistanceToPickPoint = predLastDistance - parcelLocationDistanceRound;
                    int predLastDuration = NumericUtil.getIntegerValue(lastStop.getSecondsFromStart()) - NumericUtil.getIntegerValue(predLastStop.getSecondsFromStart());
                    this.streetDurationToPickPoint = predLastDuration - parcelLocationDurationRound;
                }
            }
        }
    }

    private int calculateParcelLocationDistance(Double parcelLocation, double d0, double d1) {
        double parcelLocationDistance = d0 + d1;
        int parcelLocationRound = (int)Math.round(parcelLocationDistance *= parcelLocation / 100.0);
        return parcelLocationRound;
    }

    private int calculateParcelLocationDuration(double parcelLocation, double d0, double d1) {
        double parcelLocationDuration = (d0 + d1) / 1.3888888888888888;
        int parcelLocationRound = (int)Math.round(parcelLocationDuration *= parcelLocation / 100.0);
        return parcelLocationRound;
    }

    public Integer getStreetDistanceFromPoi() {
        return this.streetDistanceFromPoi;
    }

    public Integer getStreetDistanceToPoi() {
        return this.streetDistanceToPoi;
    }

    public Integer getStreetDistanceFromPickPoint() {
        return this.streetDistanceFromPickPoint;
    }

    public Integer getStreetDistanceToPickPoint() {
        return this.streetDistanceToPickPoint;
    }

    public Integer getStreetDurationFromPoi() {
        return this.streetDurationFromPoi;
    }

    public Integer getStreetDurationToPoi() {
        return this.streetDurationToPoi;
    }

    public Integer getStreetDurationFromPickPoint() {
        return this.streetDurationFromPickPoint;
    }

    public Integer getStreetDurationToPickPoint() {
        return this.streetDurationToPickPoint;
    }

    public Double getCostDuration(AreaTourParameter parameter) {
        RewardEntity rewardEntity = parameter.getRewardEntity();
        RouteVehicleType vehiclePoi = parameter.getRouteVehicleTypeFromPoi();
        Tupel<Double, Double> rewardEntityPoi = rewardEntity.getRewardForVehicle(vehiclePoi);
        double durationCost = (double)this.streetDurationFromPoi.intValue() * rewardEntityPoi.getElement2() + (double)this.streetDurationToPoi.intValue() * rewardEntityPoi.getElement2();
        RouteVehicleType vehiclePickPoint = parameter.getRouteVehicleTypeFromPickPoint();
        Tupel<Double, Double> rewardEntityPickPoint = rewardEntity.getRewardForVehicle(vehiclePickPoint);
        durationCost += (double)this.streetDurationFromPickPoint.intValue() * rewardEntityPickPoint.getElement2() + (double)this.streetDurationToPickPoint.intValue() * rewardEntityPickPoint.getElement2();
        RouteVehicleType vehicleArea = parameter.getRouteVehicleTypeInArea();
        Tupel<Double, Double> rewardEntityArea = rewardEntity.getRewardForVehicle(vehicleArea);
        int durationSum = NumericUtil.getIntegerValue(this.logisticTour.getDurationSum());
        double streetDurationArea = (double)durationSum - (double)NumericUtil.getIntegerValue(this.logisticTour.getAccessSum()) / 1.3888888888888888;
        durationCost += (streetDurationArea -= (double)(this.streetDurationFromPoi - this.streetDurationToPoi - this.streetDurationFromPickPoint - this.streetDurationToPickPoint)) * rewardEntityArea.getElement2();
        Tupel<Double, Double> rewardEntityAccess = rewardEntity.getRewardForVehicle(RouteVehicleType.FOOT);
        return (durationCost += (double)NumericUtil.getIntegerValue(this.logisticTour.getAccessSum()) / 1.3888888888888888 * rewardEntityAccess.getElement2()) / 3600.0;
    }

    public Double getCostDistance(AreaTourParameter parameter) {
        RewardEntity rewardEntity = parameter.getRewardEntity();
        RouteVehicleType vehiclePoi = parameter.getRouteVehicleTypeFromPoi();
        Tupel<Double, Double> rewardEntityPoi = rewardEntity.getRewardForVehicle(vehiclePoi);
        double distanceCost = (double)this.streetDistanceFromPoi.intValue() * rewardEntityPoi.getElement1() + (double)this.streetDistanceToPoi.intValue() * rewardEntityPoi.getElement1();
        RouteVehicleType vehiclePickPoint = parameter.getRouteVehicleTypeFromPickPoint();
        Tupel<Double, Double> rewardEntityPickPoint = rewardEntity.getRewardForVehicle(vehiclePickPoint);
        distanceCost += (double)this.streetDistanceFromPickPoint.intValue() * rewardEntityPickPoint.getElement1() + (double)this.streetDistanceToPickPoint.intValue() * rewardEntityPickPoint.getElement1();
        RouteVehicleType vehicleArea = parameter.getRouteVehicleTypeInArea();
        Tupel<Double, Double> rewardEntityArea = rewardEntity.getRewardForVehicle(vehicleArea);
        int streetDistanceArea = NumericUtil.getIntegerValue(this.logisticTour.getDistanceSum()) - NumericUtil.getIntegerValue(this.logisticTour.getAccessSum());
        distanceCost += (double)(streetDistanceArea -= this.streetDistanceFromPoi - this.streetDistanceToPoi - this.streetDistanceFromPickPoint - this.streetDistanceToPickPoint) * rewardEntityArea.getElement1();
        Tupel<Double, Double> rewardEntityAccess = rewardEntity.getRewardForVehicle(RouteVehicleType.FOOT);
        return (distanceCost += (double)NumericUtil.getIntegerValue(this.logisticTour.getAccessSum()) * rewardEntityAccess.getElement1()) / 1000.0;
    }

    public Double getCostNightSurcharge(AreaTourParameter parameter) {
        RewardEntity rewardEntity = parameter.getRewardEntity();
        RouteVehicleType vehiclePoi = parameter.getRouteVehicleTypeFromPoi();
        Tupel<Double, Double> rewardEntityPoi = rewardEntity.getRewardForVehicle(vehiclePoi);
        double durationCost = (double)this.streetDurationFromPoi.intValue() * rewardEntityPoi.getElement2() + (double)this.streetDurationToPoi.intValue() * rewardEntityPoi.getElement2();
        RouteVehicleType vehiclePickPoint = parameter.getRouteVehicleTypeFromPickPoint();
        Tupel<Double, Double> rewardEntityPickPoint = rewardEntity.getRewardForVehicle(vehiclePickPoint);
        durationCost += (double)this.streetDurationFromPickPoint.intValue() * rewardEntityPickPoint.getElement2() + (double)this.streetDurationToPickPoint.intValue() * rewardEntityPickPoint.getElement2();
        RouteVehicleType vehicleArea = parameter.getRouteVehicleTypeInArea();
        Tupel<Double, Double> rewardEntityArea = rewardEntity.getRewardForVehicle(vehicleArea);
        int durationSum = NumericUtil.getIntegerValue(this.logisticTour.getDurationSum());
        double streetDurationArea = (double)durationSum - (double)NumericUtil.getIntegerValue(this.logisticTour.getAccessSum()) / 1.3888888888888888;
        durationCost += (streetDurationArea -= (double)(this.streetDurationFromPoi - this.streetDurationToPoi - this.streetDurationFromPickPoint - this.streetDurationToPickPoint)) * rewardEntityArea.getElement2();
        Tupel<Double, Double> rewardEntityAccess = rewardEntity.getRewardForVehicle(RouteVehicleType.FOOT);
        durationCost += (double)NumericUtil.getIntegerValue(this.logisticTour.getAccessSum()) / 1.3888888888888888 * rewardEntityAccess.getElement2();
        int nightTime = this.getNightTime(parameter.getNight());
        if (nightTime < rewardEntity.getNightSurchargeMinMinutes() * 60) {
            nightTime = 0;
        }
        if (nightTime > 0) {
            nightTime = durationSum == 0 ? 0 : nightTime / durationSum;
        }
        return durationCost * (double)nightTime * rewardEntity.getNightSurcharge() / 100.0 / 3600.0;
    }

    public Double getCostExtraCharge(AreaTourParameter parameter) {
        return this.getCostSum(parameter) - this.getCostDuration(parameter) - this.getCostDistance(parameter) - this.getCostNightSurcharge(parameter);
    }

    public Double getCostSum(AreaTourParameter parameter) {
        RewardEntity rewardEntity = parameter.getRewardEntity();
        RouteVehicleType vehiclePoi = parameter.getRouteVehicleTypeFromPoi();
        Tupel<Double, Double> rewardEntityPoi = rewardEntity.getRewardForVehicle(vehiclePoi);
        double distanceCost = (double)this.streetDistanceFromPoi.intValue() * rewardEntityPoi.getElement1() + (double)this.streetDistanceToPoi.intValue() * rewardEntityPoi.getElement1();
        double durationCost = (double)this.streetDurationFromPoi.intValue() * rewardEntityPoi.getElement2() + (double)this.streetDurationToPoi.intValue() * rewardEntityPoi.getElement2();
        RouteVehicleType vehiclePickPoint = parameter.getRouteVehicleTypeFromPickPoint();
        Tupel<Double, Double> rewardEntityPickPoint = rewardEntity.getRewardForVehicle(vehiclePickPoint);
        distanceCost += (double)this.streetDistanceFromPickPoint.intValue() * rewardEntityPickPoint.getElement1() + (double)this.streetDistanceToPickPoint.intValue() * rewardEntityPickPoint.getElement1();
        durationCost += (double)this.streetDurationFromPickPoint.intValue() * rewardEntityPickPoint.getElement2() + (double)this.streetDurationToPickPoint.intValue() * rewardEntityPickPoint.getElement2();
        RouteVehicleType vehicleArea = parameter.getRouteVehicleTypeInArea();
        Tupel<Double, Double> rewardEntityArea = rewardEntity.getRewardForVehicle(vehicleArea);
        int streetDistanceArea = NumericUtil.getIntegerValue(this.logisticTour.getDistanceSum()) - NumericUtil.getIntegerValue(this.logisticTour.getAccessSum());
        int durationSum = NumericUtil.getIntegerValue(this.logisticTour.getDurationSum());
        double streetDurationArea = (double)durationSum - (double)NumericUtil.getIntegerValue(this.logisticTour.getAccessSum()) / 1.3888888888888888;
        distanceCost += (double)(streetDistanceArea -= this.streetDistanceFromPoi - this.streetDistanceToPoi - this.streetDistanceFromPickPoint - this.streetDistanceToPickPoint) * rewardEntityArea.getElement1();
        durationCost += (streetDurationArea -= (double)(this.streetDurationFromPoi - this.streetDurationToPoi - this.streetDurationFromPickPoint - this.streetDurationToPickPoint)) * rewardEntityArea.getElement2();
        Tupel<Double, Double> rewardEntityAccess = rewardEntity.getRewardForVehicle(RouteVehicleType.FOOT);
        distanceCost += (double)NumericUtil.getIntegerValue(this.logisticTour.getAccessSum()) * rewardEntityAccess.getElement1();
        durationCost += (double)NumericUtil.getIntegerValue(this.logisticTour.getAccessSum()) / 1.3888888888888888 * rewardEntityAccess.getElement2();
        int nightTime = this.getNightTime(parameter.getNight());
        if (nightTime < rewardEntity.getNightSurchargeMinMinutes() * 60) {
            nightTime = 0;
        }
        if (nightTime > 0) {
            nightTime = durationSum == 0 ? 0 : nightTime / durationSum;
        }
        durationCost += durationCost * (double)nightTime * rewardEntity.getNightSurcharge() / 100.0;
        return distanceCost / 1000.0 + durationCost * (1.0 + rewardEntity.getExtraCharge() / 100.0) / 3600.0;
    }

    private int getNightTime(NightSurchargeTimeWindow night) {
        int startNightSeconds = night.getNightSeconds(this.logisticTour.getStartTime());
        int endNightSeconds = night.getNightSeconds(this.logisticTour.getEndTime());
        int nightTime = 0;
        if (startNightSeconds > 0 && endNightSeconds > 0) {
            nightTime = endNightSeconds - startNightSeconds;
        } else if (startNightSeconds > 0) {
            nightTime = night.nightSecondSum() - startNightSeconds;
        } else if (endNightSeconds > 0) {
            nightTime = endNightSeconds;
        }
        return nightTime;
    }
}

