/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.print.saarbruecken;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.base.ImportedLocationModel;
import de.datomino.peppergis.client.model.base.ServiceModel;
import de.datomino.peppergis.client.model.base.ServiceValueDescriptorModel;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.ServiceTicketStopRelationModel;
import de.datomino.peppergis.client.model.tour.ServiceValueModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.client.model.tour.VehicleModel;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.dto.AbstractProxyDto;
import de.datomino.peppergis.dto.AbstractSpecificDto;
import de.datomino.peppergis.dto.Dto;
import de.datomino.util.international.country.Country;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.ktde.model.ValueChangeEvent;
import org.ktde.model.ValueChangeListener;
import org.ktde.util.StringUtil;

public class SaarbrueckenTourData
implements TourModel {
    private static String AREA_ATTRIBUTE_KEY = "AREA";
    private static String WEIGHT_ATTRIBUTE_KEY = "WEIGHT";
    private static String SAAR_SERVICE_NUMBER = "SAAR-DELIVERY-1";
    private TourModel tourModel;
    private String dateString;
    private int calendarWeek;
    private int stopCount;
    private int areaCount;
    private double weightCount;
    private String tourLengthKilometers;

    public SaarbrueckenTourData(TourModel tourModel) {
        this.tourModel = tourModel;
        SimpleDateFormat tourDateFormat = new SimpleDateFormat("dd.MM.yyyy");
        this.setDateString(tourDateFormat.format(tourModel.getPlannedStartTime()));
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(tourDateFormat.parse(this.dateString));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.setCalendarWeek(cal.get(3));
        Iterator<TourPartModel> parts = this.iterateTourParts();
        HashSet<String> stopsAddressSet = new HashSet<String>();
        while (parts.hasNext()) {
            TourPartModel tourPart = parts.next();
            Iterator<StopModel> stopsList = tourPart.iterateStops();
            while (stopsList.hasNext()) {
                String country2;
                String address2;
                StopModel stopTemp = stopsList.next();
                if (stopTemp.getLocation() != null && stopTemp.getLocation().getParcel() != null) {
                    ParcelModel parcelTemp = stopTemp.getLocation().getParcel();
                    StreetModel street = parcelTemp.getStreet();
                    PostcodeDistrictRelationModel pDRModel = street == null ? null : street.getPostcodeDistrictRelation();
                    PostcodeModel postcode = pDRModel == null ? null : pDRModel.getPostcode();
                    Country country = postcode == null ? null : postcode.getCountry();
                    DistrictModel district = pDRModel == null ? null : pDRModel.getDistrict();
                    CityModel city = district == null ? null : district.getCity();
                    String address1 = (country == null ? "" : country.toString()) + " " + (postcode == null ? "" : postcode.getName()) + " " + (city == null ? "" : city.getName()) + " " + (district == null ? "" : district.getName()) + " " + (street == null ? "" : street.getName()) + " " + parcelTemp.getHouseNumber() + " " + parcelTemp.getHouseNumberExtension();
                    if (stopsAddressSet.contains(address1)) continue;
                    stopsAddressSet.add(address1);
                    continue;
                }
                ImportedLocationModel locationTemp = stopTemp.getLocation() == null ? null : stopTemp.getLocation().getImportedLocation();
                if (locationTemp == null || stopsAddressSet.contains(address2 = (country2 = locationTemp.getCountry() == null ? "" : locationTemp.getCountry().toString()) + " " + locationTemp.getPostcode() + " " + locationTemp.getCity() + " " + locationTemp.getDistrict() + " " + locationTemp.getStreet() + " " + locationTemp.getHousenumber() + " " + locationTemp.getHousenumberExtension())) continue;
                stopsAddressSet.add(address2);
            }
        }
        this.setStopCount(stopsAddressSet.size());
        HashSet<String> areaSet = new HashSet<String>();
        double wCount = 0.0;
        Iterator<TourPartModel> tourAllParts = this.iterateTourParts();
        while (tourAllParts.hasNext()) {
            TourPartModel tourPart = tourAllParts.next();
            Iterator<StopModel> tourAllStops = tourPart.iterateStops();
            while (tourAllStops.hasNext()) {
                StopModel tourStop = tourAllStops.next();
                Iterator<ServiceTicketStopRelationModel> serviceTicketStopRelations = tourStop.iterateServiceStopRelations();
                while (serviceTicketStopRelations.hasNext()) {
                    ServiceTicketStopRelationModel srvcTktStopRelationModel = serviceTicketStopRelations.next();
                    ServiceModel service = srvcTktStopRelationModel.getServiceTicket().getService();
                    if (!service.getServiceNumber().equals(SAAR_SERVICE_NUMBER)) continue;
                    Iterator<ServiceValueModel> serviceValueModels = srvcTktStopRelationModel.iterateServiceValues();
                    while (serviceValueModels.hasNext()) {
                        ServiceValueModel srvcValModel = serviceValueModels.next();
                        ServiceValueDescriptorModel descriptorModel = srvcValModel.getServiceValueDescriptor();
                        String key = descriptorModel.getKey();
                        if (key.equals(AREA_ATTRIBUTE_KEY)) {
                            areaSet.add(srvcValModel.getStringValue());
                            continue;
                        }
                        if (!key.equals(WEIGHT_ATTRIBUTE_KEY)) continue;
                        try {
                            wCount += Double.parseDouble(srvcValModel.getStringValue().replace(".", "").replace(",", "."));
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        this.setAreaCount(areaSet.size());
        this.setWeightCount(Math.round(wCount));
        int meters = 0;
        if (TourModelUtil.getStreetMileageMeters(this) != null) {
            meters = TourModelUtil.getStreetMileageMeters(this);
        }
        double km = (double)meters / 1000.0;
        this.setTourLengthKilometers(Long.toString(Math.round(km)));
    }

    public String getSaarAttributeValue(StopModel model, String keyToBeFound) {
        Iterator<TourPartModel> tourAllParts = this.iterateTourParts();
        while (tourAllParts.hasNext()) {
            TourPartModel tourPart = tourAllParts.next();
            Iterator<StopModel> tourAllStops = tourPart.iterateStops();
            while (tourAllStops.hasNext()) {
                StopModel tourStop = tourAllStops.next();
                if (!tourStop.equals(model)) continue;
                Iterator<ServiceTicketStopRelationModel> serviceTicketStopRelations = tourStop.iterateServiceStopRelations();
                while (serviceTicketStopRelations.hasNext()) {
                    ServiceTicketStopRelationModel srvcTktStopRelationModel = serviceTicketStopRelations.next();
                    ServiceModel service = srvcTktStopRelationModel.getServiceTicket().getService();
                    if (!service.getServiceNumber().equals(SAAR_SERVICE_NUMBER)) continue;
                    Iterator<ServiceValueModel> serviceValueModels = srvcTktStopRelationModel.iterateServiceValues();
                    while (serviceValueModels.hasNext()) {
                        ServiceValueModel srvcValModel = serviceValueModels.next();
                        ServiceValueDescriptorModel descriptorModel = srvcValModel.getServiceValueDescriptor();
                        String key = descriptorModel.getKey();
                        if (!key.equals(keyToBeFound)) continue;
                        switch (descriptorModel.getServiceValueType()) {
                            case INTEGER: {
                                Integer iValue = srvcValModel.getIntegerValue();
                                return StringUtil.nullToEmpty(iValue);
                            }
                            case STRING: {
                                return StringUtil.nullToEmpty(srvcValModel.getStringValue());
                            }
                            case TEXT: {
                                return StringUtil.nullToEmpty(srvcValModel.getTextValue());
                            }
                            case STATIC_CHOICE: {
                                return srvcValModel.getStaticChoiceValue().getValue();
                            }
                        }
                        throw new RuntimeException();
                    }
                }
            }
        }
        return "";
    }

    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
        this.tourModel.addValueChangeListener(listener);
    }

    @Override
    public void removeValueChangeListener(ValueChangeListener listener) {
        this.tourModel.removeValueChangeListener(listener);
    }

    @Override
    public Long getTempUUID() {
        return this.tourModel.getTempUUID();
    }

    @Override
    public String getName() {
        return this.tourModel.getName();
    }

    @Override
    public void setName(String name) {
        this.tourModel.setName(name);
    }

    @Override
    public Long getId() {
        return this.tourModel.getId();
    }

    @Override
    public Long getVersion() {
        return this.tourModel.getVersion();
    }

    @Override
    public String getInformation() {
        return this.tourModel.getInformation();
    }

    @Override
    public boolean isDirty() {
        return this.tourModel.isDirty();
    }

    @Override
    public void setInformation(String information) {
        this.tourModel.setInformation(information);
    }

    @Override
    public void delete() {
        this.tourModel.delete();
    }

    @Override
    public boolean isDeleted() {
        return this.tourModel.isDeleted();
    }

    @Override
    public Date getPlannedStartTime() {
        return this.tourModel.getPlannedStartTime();
    }

    @Override
    public boolean isProxy() {
        return this.tourModel.isProxy();
    }

    @Override
    public void setPlannedStartTime(Date plannedStartTime) {
        this.tourModel.setPlannedStartTime(plannedStartTime);
    }

    @Override
    public AbstractProxyDto createProxy() {
        return this.tourModel.createProxy();
    }

    @Override
    public AbstractSpecificDto createDto() {
        return this.tourModel.createDto();
    }

    @Override
    public Date getActualStartTime() {
        return this.tourModel.getActualStartTime();
    }

    @Override
    public void setActualStartTime(Date actualStartTime) {
        this.tourModel.setActualStartTime(actualStartTime);
    }

    @Override
    public DelivererModel getDeliverer() {
        return this.tourModel.getDeliverer();
    }

    @Override
    public void setDeliverer(DelivererModel deliverer) {
        this.tourModel.setDeliverer(deliverer);
    }

    @Override
    public VehicleModel getVehicle() {
        return this.tourModel.getVehicle();
    }

    @Override
    public void setVehicle(VehicleModel vehicle) {
        this.tourModel.setVehicle(vehicle);
    }

    @Override
    public BranchModel getBranch() {
        return this.tourModel.getBranch();
    }

    @Override
    public void setBranch(BranchModel branch) {
        this.tourModel.setBranch(branch);
    }

    @Override
    public int countTourParts() {
        return this.tourModel.countTourParts();
    }

    @Override
    public Iterator<TourPartModel> iterateTourParts() {
        return this.tourModel.iterateTourParts();
    }

    @Override
    public Iterable<TourPartModel> iterableTourParts() {
        return this.tourModel.iterableTourParts();
    }

    @Override
    public void addTourPart(TourPartModel tourPart) {
        this.tourModel.addTourPart(tourPart);
    }

    @Override
    public void removeTourPart(TourPartModel tourPart) {
        this.tourModel.removeTourPart(tourPart);
    }

    @Override
    public TourPartModel getTourPartAt(int index) {
        return this.tourModel.getTourPartAt(index);
    }

    @Override
    public void insertTourPart(TourPartModel tourPart, int index) {
        this.tourModel.insertTourPart(tourPart, index);
    }

    @Override
    public void removeTourPartAt(int index) {
        this.tourModel.removeTourPartAt(index);
    }

    @Override
    public void setTourPartAt(TourPartModel tourPart, int index) {
        this.tourModel.setTourPartAt(tourPart, index);
    }

    @Override
    public void clearTourParts() {
        this.tourModel.clearTourParts();
    }

    @Override
    public boolean isTourPartsEmpty() {
        return this.tourModel.isTourPartsEmpty();
    }

    @Override
    public boolean containsTourPart(TourPartModel tourPart) {
        return this.tourModel.containsTourPart(tourPart);
    }

    @Override
    public int indexOfTourPart(TourPartModel tourPart) {
        return this.tourModel.indexOfTourPart(tourPart);
    }

    @Override
    public boolean isTourPartsInitialized() {
        return this.tourModel.isTourPartsInitialized();
    }

    @Override
    public Boolean getMobileActive() {
        return this.tourModel.getMobileActive();
    }

    @Override
    public void setMobileActive(Boolean mobileActive) {
        this.tourModel.setMobileActive(mobileActive);
    }

    @Override
    public Boolean getMobileAlreadySynced() {
        return this.tourModel.getMobileAlreadySynced();
    }

    @Override
    public void setMobileAlreadySynced(Boolean mobileAlreadySynced) {
        this.tourModel.setMobileAlreadySynced(mobileAlreadySynced);
    }

    @Override
    public Integer getKilometerStart() {
        return this.tourModel.getKilometerStart();
    }

    @Override
    public void setKilometerStart(Integer kilometerStart) {
        this.tourModel.setKilometerStart(kilometerStart);
    }

    @Override
    public Integer getKilometerEnd() {
        return this.tourModel.getKilometerEnd();
    }

    @Override
    public void setKilometerEnd(Integer kilometerEnd) {
        this.tourModel.setKilometerEnd(kilometerEnd);
    }

    public int getAreaCount() {
        return this.areaCount;
    }

    public void setAreaCount(int areaCount) {
        this.areaCount = areaCount;
    }

    public int getStopCount() {
        return this.stopCount;
    }

    public void setStopCount(int stopCount) {
        this.stopCount = stopCount;
    }

    public String getDateString() {
        return this.dateString;
    }

    public void setDateString(String dateString) {
        this.dateString = dateString;
    }

    public int getCalendarWeek() {
        return this.calendarWeek;
    }

    public void setCalendarWeek(int calendarWeek) {
        this.calendarWeek = calendarWeek;
    }

    public double getWeightCount() {
        return this.weightCount;
    }

    public void setWeightCount(double weightCount) {
        this.weightCount = weightCount;
    }

    public String getTourLengthKilometers() {
        return this.tourLengthKilometers;
    }

    public void setTourLengthKilometers(String tourLengthKilometers) {
        this.tourLengthKilometers = tourLengthKilometers;
    }

    @Override
    public Date getCreationDate() {
        return this.tourModel.getCreationDate();
    }

    @Override
    public Date getLastModifiedDate() {
        return this.tourModel.getLastModifiedDate();
    }

    @Override
    public Date getActualEndTime() {
        return this.tourModel.getActualEndTime();
    }

    @Override
    public void setActualEndTime(Date actualEndTime) {
        this.tourModel.setActualEndTime(actualEndTime);
    }

    @Override
    public void fireModelValueChangeEvent(ValueChangeEvent e) {
    }

    @Override
    public void updateByDto(Dto dto) {
    }

    @Override
    public void undelete() {
    }

    @Override
    public Double getStartWeight() {
        return 0.0;
    }

    @Override
    public void setStartWeight(Double startWeight) {
    }

    @Override
    public CommonCaller getCommonCaller() {
        return null;
    }
}

