/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.print;

import de.datomino.pdf.engine.Format;
import de.datomino.pdf.engine.PdfCreatorImpl;
import de.datomino.pdf.printer.PrintRenderer;
import de.datomino.pdf.printer.PrinterInformation;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.osm.NotThreadingOsmNavigatorRenderer;
import de.datomino.peppergis.client.gui.osm.ThreadingOsmNavigatorRenderer;
import de.datomino.peppergis.client.gui.renderer.area.AreaLayerRenderer;
import de.datomino.peppergis.client.manager.printer.AbstractManagerPrinter;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.print.PlaceNameRenderer;
import de.datomino.peppergis.client.print.StreetNameRenderer;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.print.TourInfoPrintType;
import de.datomino.peppergis.tourmanager.gui.map.TourLayerRenderer;
import de.datomino.peppergis.tourmanager.gui.map.TourMapGui;
import de.datomino.peppergis.tourmanager.handler.action.printer.TourPrintingInformation;
import de.datomino.peppergis.tourmanager.print.TourManagerPrinter;
import de.datomino.peppergis.tourmanager.print.saarbruecken.SaarbrueckenTourData;
import de.datomino.util.collection.CollectionUtil;
import java.awt.Color;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.batik.svggen.SVGGraphics2D;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TourManagerPrinterImpl
extends AbstractManagerPrinter<TourModel>
implements TourManagerPrinter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TourManagerPrinter.class);
    private static final String TEMPLATEFORSCREEN = "fo/screenshot2pdf.vm";
    private static final String TEMPLATEFORTOURS = "fo/tours2pdf.vm";
    private static final String TEMPLATEFORLEGEND = "fo/legend2pdf.vm";
    private TourMapGui tourMapGui;

    public TourManagerPrinterImpl(TourMapGui tourMapGui) {
        super(tourMapGui.getModelEnviroment(), TEMPLATEFORSCREEN, TEMPLATEFORLEGEND);
        this.tourMapGui = tourMapGui;
    }

    @Override
    public InputStream printSelectedTours(NavigatorPanel navigatorPanel, Map<TourModel, Color> toursWithColor, PrinterInformation printerInformation) throws Exception {
        return this.printSelectedTourDefault(navigatorPanel, toursWithColor, printerInformation, null);
    }

    @Override
    public InputStream printSelectedTourSaarbruecken(NavigatorPanel navigatorPanel, Map<TourModel, Color> toursWithColor) throws Exception {
        HashMap<String, Object> inputDatas = new HashMap<String, Object>();
        Set<TourModel> tourModelObjects = toursWithColor.keySet();
        ArrayList<SaarbrueckenTourData> saarbrueckenTourDatas = new ArrayList<SaarbrueckenTourData>();
        for (TourModel tourModel : tourModelObjects) {
            saarbrueckenTourDatas.add(new SaarbrueckenTourData(tourModel));
        }
        inputDatas.put("tours", saarbrueckenTourDatas);
        inputDatas.put("creationDate", new SimpleDateFormat("dd.MM.yyyy hh:mm:ss").format(new Date()));
        inputDatas.put("locationWrapperObj", LocationWrapperFactory.INSTANCE);
        PdfCreatorImpl pdfCreator = new PdfCreatorImpl();
        return pdfCreator.createPdf("fo/tours2pdfSaarbruecken.vm", inputDatas, null, ModelEnviroment.getMessageResolver());
    }

    protected InputStream printSelectedTourDefault(NavigatorPanel navigatorPanel, Map<TourModel, Color> toursWithColor, PrinterInformation printerInformation, byte[] layerLogoImage) throws Exception, IOException, InterruptedException {
        HashMap<String, Object> inputDatas = new HashMap<String, Object>();
        Tupel<Integer, Integer> rectangle = super.setParameter(printerInformation, inputDatas, layerLogoImage, null);
        TourPrintingInformation tourPrintingInformation = new TourPrintingInformation((List<TourModel>)new LinkedList<TourModel>(toursWithColor.keySet()), null, (Format)inputDatas.get("format"), this.tourMapGui.getModelEnviroment());
        Set<Coordinate> coordinates = TourModelUtil.getAreaRectangle(toursWithColor.keySet(), printerInformation.isWithPoi(), this.tourMapGui.getModelEnviroment());
        NavigatorPanel printNavigatorPanel = this.createPrintNavigatorPanelForTour(navigatorPanel, toursWithColor, rectangle.getElement1(), rectangle.getElement2(), printerInformation);
        if (printerInformation.isUseVector()) {
            String fetchSvg = super.createSvgForModel(printNavigatorPanel, toursWithColor, coordinates, rectangle.getElement1().intValue(), rectangle.getElement2().intValue(), printerInformation);
            tourPrintingInformation.setImagePath(fetchSvg);
        } else {
            Image image = super.getImageFromNavigatorPanel(printNavigatorPanel, coordinates, printerInformation.isOptimalZoom());
            int logoWidth = 0;
            int logoHeight = 0;
            if (inputDatas.get("logoImage") != null) {
                float f;
                int w;
                String s = (String)inputDatas.get("logoWidth");
                try {
                    w = Integer.parseInt(s);
                }
                catch (Exception ex) {
                    f = Float.parseFloat(s);
                    w = Math.round(f);
                }
                logoWidth = (int)((double)w * printerInformation.getScale());
                s = (String)inputDatas.get("logoHeight");
                try {
                    w = Integer.parseInt(s);
                }
                catch (Exception ex) {
                    f = Float.parseFloat(s);
                    w = Math.round(f);
                }
                logoHeight = (int)((double)w * printerInformation.getScale() / 1.2);
            }
            Image imageWithLogo = inputDatas.get("logoImage") == null ? image : ClientSwingUtil.addLogoOnImage(image, (Image)inputDatas.get("logoImage"), logoWidth, logoHeight, printerInformation.getPosition());
            tourPrintingInformation.setImagePath(PdfCreatorImpl.saveImageToTempFile(imageWithLogo));
        }
        tourPrintingInformation.initialize(printerInformation);
        inputDatas.put("tours", CollectionUtil.buildLinkedList(tourPrintingInformation));
        PdfCreatorImpl pdfCreator = new PdfCreatorImpl();
        return pdfCreator.createPdf(TEMPLATEFORTOURS, inputDatas, null, ModelEnviroment.getMessageResolver());
    }

    @Override
    public InputStream printSelectedToursInPages(NavigatorPanel navigatorPanel, Map<TourModel, Color> toursWithColor, PrinterInformation printerInformation) throws Exception {
        if (toursWithColor == null || toursWithColor.isEmpty()) {
            return null;
        }
        int i = 1;
        HashMap<String, Object> inputDatas = new HashMap<String, Object>();
        Tupel<Integer, Integer> rectangle = super.setParameter(printerInformation, inputDatas, null, null);
        HashSet<TourPrintingInformation> tourPrintingInformations = new HashSet<TourPrintingInformation>();
        ArrayList<TourModel> keySet = new ArrayList<TourModel>(toursWithColor.keySet());
        for (TourModel tour : keySet) {
            TourPrintingInformation tourPrintingInformation = new TourPrintingInformation(tour, null, (Format)inputDatas.get("format"), this.tourMapGui.getModelEnviroment());
            HashMap<TourModel, Color> map = new HashMap<TourModel, Color>();
            map.put(tour, toursWithColor.get(tour));
            Set<Coordinate> coordinates = TourModelUtil.getAreaRectangle(CollectionUtil.buildHashSet(tour), printerInformation.isWithPoi(), this.tourMapGui.getModelEnviroment());
            NavigatorPanel printNavigatorPanel = this.createPrintNavigatorPanelForTour(navigatorPanel, map, rectangle.getElement1(), rectangle.getElement2(), printerInformation);
            if (printerInformation.isUseVector()) {
                String fetchSvg = super.createSvgForModel(printNavigatorPanel, toursWithColor, coordinates, rectangle.getElement1().intValue(), rectangle.getElement2().intValue(), printerInformation);
                tourPrintingInformation.setImagePath(fetchSvg);
            } else {
                Image image = super.getImageFromNavigatorPanel(printNavigatorPanel, coordinates, printerInformation.isOptimalZoom());
                if (inputDatas.get("logoImage") != null) {
                    String s = (String)inputDatas.get("logoWidth");
                    int logoWidth = (int)((double)Math.round(Float.parseFloat(s)) * printerInformation.getScale());
                    s = (String)inputDatas.get("logoWidth");
                    int logoHeight = (int)((double)Math.round(Float.parseFloat(s)) * printerInformation.getScale() / 1.2);
                    image = ClientSwingUtil.addLogoOnImage(image, (Image)inputDatas.get("logoImage"), logoWidth, logoHeight, printerInformation.getPosition());
                }
                tourPrintingInformation.setImagePath(PdfCreatorImpl.saveImageToTempFile(image));
            }
            TourInfoPrintType tourInfoPrintType = (TourInfoPrintType)printerInformation.getNamePrintType();
            if (tourInfoPrintType != TourInfoPrintType.NONE) {
                switch (tourInfoPrintType) {
                    case TOP: {
                        tourPrintingInformation.setTop(true);
                        break;
                    }
                    case DOWN: {
                        tourPrintingInformation.setDown(true);
                        break;
                    }
                }
            }
            tourPrintingInformation.initialize(printerInformation);
            tourPrintingInformations.add(tourPrintingInformation);
            LOGGER.info("create pdf from tours - " + i++ + "/" + keySet.size());
        }
        inputDatas.put("tours", tourPrintingInformations);
        PdfCreatorImpl pdfCreator = new PdfCreatorImpl();
        return pdfCreator.createPdf(TEMPLATEFORTOURS, inputDatas, null, ModelEnviroment.getMessageResolver());
    }

    @Override
    protected Tupel<AreaLayerModel, AreaObjectModel> getAreaObject() {
        AreaObjectModel aom = this.tourMapGui.getFilterAreaObject();
        return new Tupel<AreaLayerModel, AreaObjectModel>(aom == null ? null : aom.getAreaLayer(), aom);
    }

    @Override
    protected Tupel<SVGGraphics2D, Double> renderSvg(NavigatorPanel navigatorPanel, Map<TourModel, Color> toursWithColor, int width, int height, Coordinate topLeft, Coordinate bottomRight, PrinterInformation printInformation) {
        NavigatorPanel printNavigatorPanel = new NavigatorPanel(null, navigatorPanel.getCoordinateFactory(), null);
        TourLayerRenderer tourLayerRenderer = new TourLayerRenderer(this.tourMapGui, this.tourMapGui.getModelEnviroment());
        for (NavigatorRenderer navigatorRenderer : navigatorPanel.getRenderers()) {
            if (!(navigatorRenderer instanceof TourLayerRenderer) || !navigatorRenderer.isActive()) continue;
            if (toursWithColor != null) {
                tourLayerRenderer.setTourWithColorOnMap(toursWithColor);
                tourLayerRenderer.setNavigatorPanel(printNavigatorPanel);
                printNavigatorPanel.addRenderer(tourLayerRenderer);
                tourLayerRenderer.setWithStack(((TourLayerRenderer)navigatorRenderer).isWithStack());
                continue;
            }
            navigatorRenderer.setNavigatorPanel(printNavigatorPanel);
            printNavigatorPanel.addRenderer(navigatorRenderer);
        }
        PrintRenderer printRenderer = new PrintRenderer(navigatorPanel, tourLayerRenderer, topLeft, bottomRight);
        return printRenderer.render(width, height);
    }

    private NavigatorPanel createPrintNavigatorPanelForTour(NavigatorPanel navigatorPanel, Map<TourModel, Color> toursWithColor, int width, int height, PrinterInformation printerInformation) throws IOException {
        NavigatorPanel printNavigatorPanel = super.creatEmptyPrintNavigatorPanel(navigatorPanel, width, height, printerInformation);
        ModelEnviroment modelEnviroment = this.tourMapGui.getModelEnviroment();
        for (NavigatorRenderer navigatorRenderer : navigatorPanel.getRenderers()) {
            if (navigatorRenderer instanceof TourLayerRenderer && navigatorRenderer.isActive()) {
                if (toursWithColor != null) {
                    TourLayerRenderer tourLayerRenderer = new TourLayerRenderer(this.tourMapGui, modelEnviroment);
                    tourLayerRenderer.setTourWithColorOnMap(toursWithColor);
                    tourLayerRenderer.setNavigatorPanel(printNavigatorPanel);
                    printNavigatorPanel.addRenderer(tourLayerRenderer);
                    tourLayerRenderer.setWithStack(((TourLayerRenderer)navigatorRenderer).isWithStack());
                    continue;
                }
                navigatorRenderer.setNavigatorPanel(printNavigatorPanel);
                printNavigatorPanel.addRenderer(navigatorRenderer);
                continue;
            }
            if (navigatorRenderer instanceof ThreadingOsmNavigatorRenderer) {
                NotThreadingOsmNavigatorRenderer osmrenderer = new NotThreadingOsmNavigatorRenderer(ModelEnviroment.getProperties());
                osmrenderer.setNavigatorPanel(printNavigatorPanel);
                printNavigatorPanel.addRenderer(osmrenderer);
                try {
                    if (printerInformation.getPrintPlacesFont() != null) {
                        PlaceNameRenderer placeNameRenderer = new PlaceNameRenderer(modelEnviroment, printerInformation.getPrintPlacesFont());
                        placeNameRenderer.setNavigatorPanel(printNavigatorPanel);
                        printNavigatorPanel.addRenderer(placeNameRenderer);
                    }
                }
                catch (Exception placeNameRenderer) {
                    // empty catch block
                }
                try {
                    if (printerInformation.getPrintStreetsFont() == null) continue;
                    StreetNameRenderer streetNameRenderer = new StreetNameRenderer(modelEnviroment, printerInformation.getPrintStreetsFont());
                    streetNameRenderer.setNavigatorPanel(printNavigatorPanel);
                    printNavigatorPanel.addRenderer(streetNameRenderer);
                }
                catch (Exception exception) {}
                continue;
            }
            if (navigatorRenderer instanceof AreaLayerRenderer && navigatorRenderer.isActive()) {
                navigatorRenderer.setNavigatorPanel(printNavigatorPanel);
                printNavigatorPanel.addRenderer(navigatorRenderer);
                continue;
            }
            if (toursWithColor != null) continue;
            navigatorRenderer.setNavigatorPanel(printNavigatorPanel);
            printNavigatorPanel.addRenderer(navigatorRenderer);
        }
        return printNavigatorPanel;
    }
}

