/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.listener.tour;

import de.datomino.logistic.type.OptimizationType;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.tourmanager.gui.tour.TourSettingDialog;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import org.ktde.util.datatypes.Tripel;

public class PointComboBoxListener
implements ItemListener {
    private TourModel tour;
    private TourSettingDialog tourSettingDialog;
    private String startPoint;
    private String endPoint;

    public PointComboBoxListener(TourModel tour, TourSettingDialog tourSettingDialog) {
        this.tour = tour;
        this.tourSettingDialog = tourSettingDialog;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean isForStart = false;
        if (((JComboBox)e.getSource()).getActionCommand().equals("startpoint")) {
            isForStart = true;
        }
        this.setPointRegulation(e.getItem(), isForStart);
        if (this.endPoint == null || this.startPoint == null) {
            return;
        }
        if (e.getStateChange() == 1) {
            this.recalculate();
        }
        this.tourSettingDialog.repaintStopTablePanel();
    }

    private void recalculate() {
        int d;
        List<StopModel> pois = this.tourSettingDialog.getTourCaller().fetchAllStopsWithPoi();
        if (pois.isEmpty() && (this.startPoint.equals(TourModelUtil.OPTIMISESTARTITEMS[2]) || this.endPoint.equals(TourModelUtil.OPTIMISEENDITEMS[2])) && (d = JOptionPane.showConfirmDialog(this.tourSettingDialog, "Keine Standorte sind vorhanden. Wollen Sie ohne Standort die Tour optimieren?", "Meldung", 0)) == 1) {
            return;
        }
    }

    private Tripel<OptimizationType, Integer, Integer> getCurrentOptimizationType() {
        PoiModel delivererPoi = TourModelUtil.getDelivererPoi(this.tour, this.tourSettingDialog.getTourCaller());
        OptimizationType type = null;
        type = this.startPoint.equals(TourModelUtil.OPTIMISESTARTITEMS[0]) && this.endPoint.equals(TourModelUtil.OPTIMISEENDITEMS[0]) ? OptimizationType.NONFIX : (this.startPoint.equals(TourModelUtil.OPTIMISESTARTITEMS[1]) && this.endPoint.equals(TourModelUtil.OPTIMISEENDITEMS[0]) ? OptimizationType.STARTPOINTFIX : (this.startPoint.equals(TourModelUtil.OPTIMISESTARTITEMS[0]) && this.endPoint.equals(TourModelUtil.OPTIMISEENDITEMS[1]) ? OptimizationType.ENDPOINTFIX : (this.startPoint.equals(TourModelUtil.OPTIMISESTARTITEMS[1]) && this.endPoint.equals(TourModelUtil.OPTIMISEENDITEMS[1]) ? OptimizationType.BOTHPOINTFIX : (this.startPoint.equals(TourModelUtil.OPTIMISESTARTITEMS[2]) && this.endPoint.equals(TourModelUtil.OPTIMISEENDITEMS[0]) ? OptimizationType.STARTWITHPOI : (this.startPoint.equals(TourModelUtil.OPTIMISESTARTITEMS[2]) && this.endPoint.equals(TourModelUtil.OPTIMISEENDITEMS[1]) ? OptimizationType.STARTWITHPOIENDFIX : (this.startPoint.equals(TourModelUtil.OPTIMISESTARTITEMS[0]) && this.endPoint.equals(TourModelUtil.OPTIMISEENDITEMS[2]) ? OptimizationType.ENDWITHPOI : (this.startPoint.equals(TourModelUtil.OPTIMISESTARTITEMS[1]) && this.endPoint.equals(TourModelUtil.OPTIMISEENDITEMS[2]) ? OptimizationType.STARTFIXENDWITHPOI : OptimizationType.BOTHWITHPOI)))))));
        TourModelUtil.adaptTourForOptimization(this.tour, delivererPoi, null, type);
        return new Tripel<OptimizationType, Integer, Integer>(type, 0, 0);
    }

    private void setPointRegulation(Object item, boolean isForStart) {
        if (isForStart) {
            this.startPoint = String.valueOf(item);
        } else {
            this.endPoint = String.valueOf(item);
        }
    }
}

