/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.listener.stop;

import de.datomino.peppergis.client.model.base.ServiceValueDescriptorModel;
import de.datomino.peppergis.client.model.tour.ServiceTicketStopRelationModel;
import de.datomino.peppergis.client.model.tour.ServiceValueModel;
import de.datomino.peppergis.client.model.tour.ServiceValueModelImpl;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.tourmanager.listener.AbstractTextComponentListener;
import de.datomino.peppergis.type.AttributeValueType;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

public class ServiceValueListener
extends AbstractTextComponentListener {
    private ServiceTicketStopRelationModel relationModel;
    private ServiceValueModel serviceValueModel;
    private ServiceValueDescriptorModel serviceValueDescriptorModel;

    public ServiceValueListener(ServiceTicketStopRelationModel relationModel, ServiceValueDescriptorModel serviceValueDescriptorModel, ServiceValueModel serviceValueModel, JTextField textField) {
        super(textField);
        this.relationModel = relationModel;
        this.serviceValueDescriptorModel = serviceValueDescriptorModel;
        this.serviceValueModel = serviceValueModel;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.serviceValueDescriptorModel.getEditable().booleanValue()) {
            this.textComponent.setEditable(true);
        }
    }

    @Override
    public void focusGainedAction() {
    }

    @Override
    public void validateAndStoreInput() {
        if (!this.serviceValueDescriptorModel.getEditable().booleanValue()) {
            return;
        }
        if (this.serviceValueModel == null) {
            this.serviceValueModel = new ServiceValueModelImpl();
            this.serviceValueModel.setServiceValueDescriptor(this.serviceValueDescriptorModel);
            this.serviceValueModel.setServiceStopRelation(this.relationModel);
            this.relationModel.addServiceValue(this.serviceValueModel);
        }
        Object validatedInput = null;
        try {
            validatedInput = this.validateInput();
        }
        catch (NullPointerException e) {
            this.textComponent.setEditable(false);
            return;
        }
        if (validatedInput == null) {
            this.textComponent.setFocusable(true);
            this.textComponent.setText("Der Eingabetyp muss " + this.serviceValueDescriptorModel.getServiceValueType().name() + " sein.");
        } else {
            this.storeInput(validatedInput);
            this.textComponent.setEditable(false);
        }
    }

    private void storeInput(Object validatedInput) {
        AttributeValueType serviceValueType = this.serviceValueModel.getServiceValueDescriptor().getServiceValueType();
        switch (serviceValueType) {
            case INTEGER: {
                this.serviceValueModel.setIntegerValue((Integer)validatedInput);
                break;
            }
            case STRING: {
                this.serviceValueModel.setStringValue((String)validatedInput);
                break;
            }
            case TEXT: {
                this.serviceValueModel.setTextValue((String)validatedInput);
                break;
            }
            case FLOAT: {
                this.serviceValueModel.setFloatValue((Double)validatedInput);
                break;
            }
            case BOOLEAN: {
                this.serviceValueModel.setBooleanValue((Boolean)validatedInput);
            }
        }
    }

    private Object validateInput() {
        Object validateInput = null;
        AttributeValueType serviceValueType = this.serviceValueModel.getServiceValueDescriptor().getServiceValueType();
        String text = this.textComponent.getText();
        switch (serviceValueType) {
            case INTEGER: {
                try {
                    validateInput = Integer.valueOf(text.trim());
                }
                catch (Exception exception) {}
                break;
            }
            case FLOAT: {
                try {
                    validateInput = ClientFormUtil.getNumber(text.trim());
                }
                catch (Exception exception) {}
                break;
            }
            case STRING: 
            case TEXT: {
                validateInput = text;
            }
        }
        return validateInput;
    }

    private JPopupMenu createServiceValueMenu() {
        JPopupMenu serviceValueMenu = new JPopupMenu();
        JMenuItem updateServiceValueItem = new JMenuItem("Bearbeiten");
        updateServiceValueItem.addActionListener(this);
        serviceValueMenu.add(updateServiceValueItem);
        JMenuItem deleteServiceValueItem = new JMenuItem("L\u00f6schen");
        deleteServiceValueItem.addActionListener(this);
        serviceValueMenu.add(deleteServiceValueItem);
        return serviceValueMenu;
    }
}

