/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.listener.map;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.tourmanager.gui.map.TourMapGui;
import de.datomino.peppergis.type.UserRole;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;

public class TourMapMouseListener
extends MouseAdapter {
    private TourMapGui tourMapGui;

    public TourMapMouseListener(TourMapGui tourMapGui) {
        this.tourMapGui = tourMapGui;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3 && ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.DISPONENT_SUPER)) {
            this.showPopupMenu(e);
            double upp = this.tourMapGui.getNavigatorPanel().getUpp();
            this.tourMapGui.getGeoTrackingRenderer().doMouseRightClicked(e.getX(), e.getY(), upp);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 3) {
            this.tourMapGui.updateParcelAndSubscription();
        }
        this.tourMapGui.getNavigatorPanel().getMouseManipulator().mouseReleased(e);
    }

    private void showPopupMenu(MouseEvent e) {
        if (this.tourMapGui.getSelectedStopsForRemove().isEmpty() && this.tourMapGui.getSelectedStopsForAdd().isEmpty()) {
            return;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        if (!this.tourMapGui.getSelectedStopsForRemove().isEmpty()) {
            popupMenu.add(this.tourMapGui.getTourMapActions().getRemoveStopFromTourAction());
            popupMenu.add(this.tourMapGui.getTourMapActions().getChangeTourOfStopsItem());
        }
        if (this.tourMapGui.getSelectedStopsForRemove().size() == 1 || this.tourMapGui.getSelectedStopsForAdd().size() == 1) {
            popupMenu.add(this.tourMapGui.getTourMapActions().getDuplicateStopsAction());
        }
        popupMenu.add(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = -4270272638257499498L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TourMapMouseListener.this.tourMapGui.clearSelectedStopsForRemove();
                TourMapMouseListener.this.tourMapGui.getNavigatorPanel().repaint(10L);
            }
        });
        popupMenu.show(this.tourMapGui.getNavigatorPanel(), e.getX(), e.getY());
    }
}

