/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.listener.map;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.gui.map.TourMapGui;
import de.datomino.peppergis.tourmanager.gui.map.legend.StopAttributeNode;
import de.datomino.peppergis.tourmanager.gui.map.legend.StopNode;
import de.datomino.peppergis.tourmanager.gui.stop.AddAndUpdateStopDialog;
import de.datomino.peppergis.tourmanager.handler.action.routing.TourRoutingActions;
import de.datomino.peppergis.type.UserRole;
import de.datomino.util.collection.CollectionUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.ktde.swing.navigator.DefaultMouseManipulator;
import org.ktde.swing.navigator.MouseButton;

public class TourLegendTreeListener
extends DefaultMouseManipulator {
    private TourMapGui tourMapGui;
    private StopModel draggedObject;

    public TourLegendTreeListener(TourMapGui tourMapGui) {
        this.tourMapGui = tourMapGui;
    }

    @Override
    public void mouseClickFinished(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
        TreePath treePath = this.tourMapGui.getTourLegendTree().getPathForLocation(x, y);
        this.tourMapGui.getTourLegendTree().setSelectionPath(treePath);
        if (clickCount == 2 && mouseButton == MouseButton.BUTTON1) {
            StopModel selectedStop = this.getSelectedStop();
            if (selectedStop != null) {
                AddAndUpdateStopDialog addAndUpdateStopDialog = new AddAndUpdateStopDialog(this.tourMapGui.getModelEnviroment(), true, null);
                addAndUpdateStopDialog.showDialog(selectedStop, true, (Component)this.tourMapGui);
            }
        } else if (mouseButton == MouseButton.BUTTON3) {
            this.showRoutingPopupMenu(x, y);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.draggedObject != null && this.dragged && ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.DELIVERER_ACTIVE, UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.DISPONENT_SUPER)) {
            this.tourMapGui.clearSelectedStopsForRemove();
            this.tourMapGui.clearSelectedStopsForAdd();
            this.tourMapGui.getSelectedStopsForRemove().add(this.draggedObject);
            this.tourMapGui.getSelectedStopsForAdd().add(this.draggedObject);
            this.tourMapGui.fireDragAndDrop(e.getLocationOnScreen(), true);
        }
        super.mouseReleased(e);
        this.tourMapGui.getTourLegendTree().setCursor(Cursor.getDefaultCursor());
        this.tourMapGui.getNavigatorPanel().setCursor(Cursor.getDefaultCursor());
        this.draggedObject = null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.draggedObject = this.getSelectedStop();
        if (this.draggedObject != null && this.draggedObject.getPoi() != null) {
            this.draggedObject = null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        if (this.draggedObject != null && this.dragged) {
            this.tourMapGui.updateAddStopsCursor(e.getLocationOnScreen());
        }
    }

    private void showRoutingPopupMenu(int x, int y) {
        final TourModel tour = this.tourMapGui.getSelectedModel();
        if (tour != null && ModelEnviroment.getUserInformation().hasUserRoleForTour(tour, UserRole.DELIVERER_ACTIVE, UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.DISPONENT_SUPER, UserRole.ADMIN)) {
            TourManagerCalendarGui tourManagerCalendarGui = this.tourMapGui.getTourManagerCalendarGui();
            TourRoutingActions actions2 = new TourRoutingActions(tourManagerCalendarGui, this.tourMapGui, null);
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add(actions2.getRoutingAction());
            popupMenu.addSeparator();
            popupMenu.add(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.removeTourOnMap", new Serializable[0])){
                private static final long serialVersionUID = 4283262807947206483L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    TourLegendTreeListener.this.tourMapGui.removeToursFromMap(CollectionUtil.buildHashSet(tour));
                }
            });
            popupMenu.show(this.tourMapGui.getTourLegendTree(), x, y);
        }
    }

    private StopModel getSelectedStop() {
        DefaultMutableTreeNode selObject = this.tourMapGui.getSelObjectFromLegendTree();
        if (selObject != null && (selObject instanceof StopNode || selObject instanceof StopAttributeNode)) {
            return (StopModel)selObject.getUserObject();
        }
        return null;
    }
}

