/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.listener.map;

import de.datomino.peppergis.tourmanager.gui.map.LocationEditorMapPanel;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.swing.navigator.MouseManipulator;
import org.ktde.swing.navigator.NavigatorPanningAction;

public class LocationEditorMapMouseManipulator
implements MouseManipulator {
    private LocationEditorMapPanel locationMapPanel;
    private boolean dragged;

    public LocationEditorMapMouseManipulator(LocationEditorMapPanel locationMapPanel) {
        this.locationMapPanel = locationMapPanel;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.dragged) {
            return;
        }
        this.setNewCoordinate(e);
    }

    private void setNewCoordinate(MouseEvent e) {
        Point2D.Double real = this.locationMapPanel.getNavigatorPanel().getReal(e.getX(), e.getY());
        CoordinateFactory coordinateFactory = this.locationMapPanel.getNavigatorPanel().getCoordinateFactory();
        this.locationMapPanel.setCoordinate(coordinateFactory.createCoordinate(real.x, real.y));
        this.locationMapPanel.repaintGui(false);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() == 2) {
            this.setNewCoordinate(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point2D.Double real = this.locationMapPanel.getNavigatorPanel().getReal(e.getX(), e.getY());
        Coordinate coordinate = this.locationMapPanel.getCoodinateEditorLayerRenderer().getSelectedCoordinate(real);
        if (coordinate != null) {
            this.locationMapPanel.getNavigatorPanel().setCursor(Cursor.getPredefinedCursor(13));
            this.dragged = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.locationMapPanel.getNavigatorPanel().setCursor(Cursor.getDefaultCursor());
        this.dragged = false;
        if (e.getButton() == 3) {
            this.locationMapPanel.updateParcelAndSubscription();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (NavigatorPanningAction.performWheelZoom(e, this.locationMapPanel.getNavigatorPanel())) {
            this.locationMapPanel.getNavigatorPanel().forceCalcTransform();
            this.locationMapPanel.updateParcelAndSubscription();
        }
    }
}

