/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.listener.filter;

import de.datomino.peppergis.client.communication.tour.StopFilterEntity;
import de.datomino.peppergis.client.gui.common.ScrollablePopupMenu;
import de.datomino.peppergis.client.gui.common.ScrollablePopupMenuButton;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.util.DelivererModelUtil;
import de.datomino.peppergis.tourmanager.listener.AbstractTextComponentListener;
import de.datomino.util.collection.CollectionUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FilterDelivererListener
extends AbstractTextComponentListener
implements DocumentListener {
    private List<DelivererModel> allDeliverers;
    private StopFilterEntity filterEntity;
    private boolean multiSelected;
    private ScrollablePopupMenu delivererMenu;

    public FilterDelivererListener(StopFilterEntity filterEntity, JTextField delivererField, List<DelivererModel> allDeliverers, boolean multiSelected) {
        super(delivererField);
        this.filterEntity = filterEntity;
        this.allDeliverers = allDeliverers;
        this.multiSelected = multiSelected;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.textComponent.getText().length() >= 1) {
            this.createDelivererPopupMenu(this.textComponent.getText());
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.textComponent.getText().length() > 0) {
            this.createDelivererPopupMenu(this.textComponent.getText());
        } else {
            this.delivererMenu.setVisible(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void validateAndStoreInput() {
        String inputString = this.textComponent.getText();
        this.setSelectedDeliverer(inputString);
    }

    @Override
    public void focusGainedAction() {
    }

    private void createDelivererPopupMenu(String inputString) {
        if (this.delivererMenu == null) {
            this.delivererMenu = new ScrollablePopupMenu(new Dimension(480, 100)){
                private static final long serialVersionUID = 3260787594515396375L;

                @Override
                protected void firePopupMenuCanceled() {
                    Collection<DelivererModel> deliverers = FilterDelivererListener.this.filterEntity.getDeliverers();
                    String text = deliverers.isEmpty() ? null : DelivererModelUtil.getDisplayString(deliverers.iterator().next());
                    FilterDelivererListener.this.textComponent.setText(text);
                    super.firePopupMenuCanceled();
                }
            };
        }
        this.delivererMenu.removeAll();
        for (DelivererModel deliverer : this.allDeliverers) {
            if (!DelivererModelUtil.getDisplayString(deliverer).toLowerCase().contains(inputString.toLowerCase())) continue;
            ScrollablePopupMenuButton delivererMenuItem = new ScrollablePopupMenuButton();
            delivererMenuItem.setAction(this.getSelectDelivererModelAction(DelivererModelUtil.getDisplayString(deliverer)));
            this.delivererMenu.add(delivererMenuItem);
        }
        this.delivererMenu.show(this.textComponent, new Point(0, 30));
        this.textComponent.requestFocus();
    }

    private Action getSelectDelivererModelAction(String name) {
        AbstractAction action = new AbstractAction(name){
            private static final long serialVersionUID = 5430348561567836179L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterDelivererListener.this.setSelectedDeliverer(e.getActionCommand());
            }
        };
        return action;
    }

    protected void setSelectedDeliverer(String delivererString) {
        DelivererModel selectedDeliverer = null;
        for (DelivererModel deliverer : this.allDeliverers) {
            if (!delivererString.toLowerCase().equals(DelivererModelUtil.getDisplayString(deliverer).toLowerCase())) continue;
            selectedDeliverer = deliverer;
            break;
        }
        if (selectedDeliverer != null) {
            if (!this.multiSelected) {
                this.filterEntity.setDeliverers(CollectionUtil.buildHashSet(selectedDeliverer));
            }
            this.textComponent.setText(delivererString);
        } else {
            this.filterEntity.getDeliverers().clear();
            this.textComponent.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.error.noSelectedDeliverer", new Serializable[0]));
        }
        if (this.delivererMenu != null) {
            this.delivererMenu.setVisible(false);
        }
    }
}

