/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.listener.deliverer;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.DelivererDialog;
import de.datomino.peppergis.client.manager.legend.BranchNode;
import de.datomino.peppergis.client.manager.model.DelivererTransferable;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.DelivererModelImpl;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.type.UserRole;
import de.datomino.util.swing.SwingUtils;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class DelivererTreeListener
extends MouseAdapter
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    TourManagerCalendarGui tourManagerCalendarGui;

    public DelivererTreeListener(TourManagerCalendarGui tourManagerCaldendarGui) {
        this.tourManagerCalendarGui = tourManagerCaldendarGui;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        int selRow = this.tourManagerCalendarGui.getPlanTableGui().getPlanTable().getSelectedRow();
        int selCol = this.tourManagerCalendarGui.getPlanTableGui().getPlanTable().getSelectedColumn();
        this.clearSelection();
        if (!dtde.isDataFlavorSupported(DelivererTransferable.getDataFlavor()) || selRow == -1 || selCol == -1) {
            dtde.rejectDrop();
            return;
        }
        dtde.acceptDrop(3);
        this.fireDelivererObjectChanged(selRow, selCol);
        dtde.dropComplete(true);
    }

    private void fireDelivererObjectChanged(int selRow, int selCol) {
        this.tourManagerCalendarGui.getPlanTableGui().getPlanTableModel().setObjectAt(new DelivererModelImpl(new Long(0L), null), selRow, selCol);
        this.tourManagerCalendarGui.getPlanTableGui().getPlanTableModel().fireTableDataChanged();
        this.tourManagerCalendarGui.getActions().getUndoManager().startTransaction();
        List<TourModel> toursInSelRow = this.tourManagerCalendarGui.getPlanTableGui().getToursInRow(selRow);
        String nameString = "";
        for (TourModel tour : toursInSelRow) {
            this.tourManagerCalendarGui.getPlanTableGui().fireTourObjectChanged(new DelivererModelImpl(new Long(0L), null), tour);
            nameString = nameString + tour.getName() + ", ";
        }
        if (toursInSelRow.size() != 0) {
            nameString.substring(0, nameString.length() - 2);
        }
        this.tourManagerCalendarGui.getActions().getUndoManager().finishTransaction("Der Fahrer wird von Tours " + nameString + " weggelassen.");
    }

    private void clearSelection() {
        this.tourManagerCalendarGui.getTourListGui().getTourJList().clearSelection();
        this.tourManagerCalendarGui.getDelivererGui().getDelivererJTree().clearSelection();
        this.tourManagerCalendarGui.getPlanTableGui().getPlanTable().clearSelection();
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
        DragSourceContext context = dsde.getDragSourceContext();
        if (this.tourManagerCalendarGui.getPlanTableGui().isInTable(dsde.getLocation())) {
            context.setCursor(DragSource.DefaultCopyDrop);
        } else {
            context.setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        this.tourManagerCalendarGui.getTourListGui().getTourJList().clearSelection();
        this.tourManagerCalendarGui.getPlanTableGui().getPlanTable().clearSelection();
        Object selTreeNode = this.tourManagerCalendarGui.getDelivererGui().getSelectedObject();
        if (selTreeNode != null && selTreeNode.getClass().equals(DelivererModelImpl.class)) {
            dge.startDrag(DragSource.DefaultCopyDrop, new DelivererTransferable<DelivererModel>((DelivererModel)selTreeNode), this);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(3);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void mouseClicked(MouseEvent e) {
        Window parent = SwingUtils.findWindowParent(this.tourManagerCalendarGui);
        ModelEnviroment modelEnviroment = this.tourManagerCalendarGui.getModelEnviroment();
        if (e.getButton() == 1 && e.getClickCount() == 2) {
            Object selTreeNode = this.tourManagerCalendarGui.getDelivererGui().getSelectedObject();
            if (selTreeNode != null && selTreeNode instanceof DelivererModel) {
                boolean editable = ModelEnviroment.getUserInformation().isAdmin() || ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.DISPONENT_SUPER);
                new DelivererDialog(parent, modelEnviroment, (DelivererModel)selTreeNode, editable);
            }
        } else if (e.getButton() == 3 && ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.DISPONENT_SUPER)) {
            TreePath treePath = this.tourManagerCalendarGui.getDelivererGui().getDelivererJTree().getPathForLocation(e.getPoint().x, e.getPoint().y);
            if (treePath == null) {
                return;
            }
            Object selTreeNode = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
            if (selTreeNode instanceof BranchNode) {
                BranchModel branch = ((BranchNode)selTreeNode).getBranch();
                if (branch == null) {
                    // empty if block
                }
            } else if (selTreeNode instanceof DelivererModel) {
                DelivererModel delivererModel = (DelivererModel)selTreeNode;
            }
            this.tourManagerCalendarGui.getPlanTableGui().getPlanTable().repaint(10L);
        }
        this.clearSelection();
    }
}

