/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.listener;

import de.datomino.logistic.LogisticException;
import de.datomino.logistic.dto.OptimizationAlgorithmType;
import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.communication.tour.SimpleTourRoutingContext;
import de.datomino.peppergis.client.gui.ErrorMessagesDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.DelivererDialog;
import de.datomino.peppergis.client.manager.DelivererTreeGui;
import de.datomino.peppergis.client.manager.model.DelivererTransferable;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.DelivererModelImpl;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourModelImpl;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.client.util.DelivererModelUtil;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.gui.map.TourMapGui;
import de.datomino.peppergis.tourmanager.gui.tour.TourListGui;
import de.datomino.peppergis.tourmanager.gui.tour.TourPlanTableGui;
import de.datomino.peppergis.tourmanager.gui.tour.TourSettingDialog;
import de.datomino.peppergis.tourmanager.handler.action.routing.ToursRoutingAction;
import de.datomino.peppergis.tourmanager.handler.action.tour.TourTransferable;
import de.datomino.peppergis.type.UserRole;
import de.datomino.util.message.error.ErrorMessage;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.swing.ErrorMessageDialog;
import de.datomino.util.swing.SwingUtils;
import de.datomino.util.time.TimeUtil;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.StringUtil;

public class TourPlanTableListener
extends MouseAdapter
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private TourPlanTableGui planTableGui;
    private TourListGui tourGui;
    private DelivererTreeGui delivererGui;
    private TourManagerCalendarGui tourManagerCalendarGui;
    private boolean sameDeliverers;

    public TourPlanTableListener(TourManagerCalendarGui mainGui) {
        this.planTableGui = mainGui.getPlanTableGui();
        this.tourGui = mainGui.getTourListGui();
        this.delivererGui = mainGui.getDelivererGui();
        this.tourManagerCalendarGui = mainGui;
        this.sameDeliverers = StringUtil.isTrue(mainGui.getProperties().getProperty("tourPlantable.deliverer.same"));
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Point dropLoc = dtde.getLocation();
        int dropRow = this.planTableGui.getPlanTable().rowAtPoint(dropLoc);
        int dropCol = this.planTableGui.getPlanTable().columnAtPoint(dropLoc);
        int selRow = this.planTableGui.getPlanTable().getSelectedRow();
        int selCol = this.planTableGui.getPlanTable().getSelectedColumn();
        int selListIndex = this.tourGui.getTourJList().getSelectedIndex();
        int selTreeIndex = this.delivererGui.getDelivererJTree().getLeadSelectionRow();
        this.clearSelection();
        this.planTableGui.clearSelectedTours();
        if (!this.isAllowedDrop(dtde, dropRow, dropCol, selRow, selCol, selListIndex, selTreeIndex)) {
            dtde.rejectDrop();
            return;
        }
        Object transferObject = null;
        try {
            transferObject = this.getTransferObject(dtde);
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.isSameDeliverer(transferObject, dropCol, selTreeIndex)) {
            dtde.rejectDrop();
            ErrorMessagesDialog.creatAndShow(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.message.hasDeliverer", new Serializable[0]) + "<br>", this.planTableGui.getPlanTable());
            return;
        }
        dtde.acceptDrop(3);
        this.updateTourList(selListIndex);
        this.updatPlanTable(transferObject, dropRow, dropCol, selRow, selCol, selTreeIndex);
        dtde.dropComplete(true);
    }

    private boolean isSameDeliverer(Object transferObject, int dropCol, int selTreeIndex) {
        if (!this.sameDeliverers && dropCol == 0 && selTreeIndex >= 0) {
            for (int rowIndex = 0; rowIndex < this.planTableGui.getPlanTableModel().getRowCount(); ++rowIndex) {
                DelivererModel delivererModel = (DelivererModel)this.planTableGui.getPlanTableModel().getObjectAt(rowIndex, 0);
                if (delivererModel == null || !delivererModel.getTempUUID().equals(((DelivererModel)transferObject).getTempUUID())) continue;
                return true;
            }
        }
        return false;
    }

    private void clearSelection() {
        this.tourGui.getTourJList().clearSelection();
        this.delivererGui.getDelivererJTree().clearSelection();
        this.planTableGui.getPlanTable().clearSelection();
    }

    private Object getTransferObject(DropTargetDropEvent dtde) throws UnsupportedFlavorException, IOException {
        Object transferObject = null;
        if (dtde.isDataFlavorSupported(DelivererTransferable.getDataFlavor())) {
            transferObject = dtde.getTransferable().getTransferData(DelivererTransferable.getDataFlavor());
        } else if (dtde.isDataFlavorSupported(TourTransferable.getDataFlavor())) {
            transferObject = dtde.getTransferable().getTransferData(TourTransferable.getDataFlavor());
        }
        return transferObject;
    }

    private void updateTourList(int selListIndex) {
        if (selListIndex > -1) {
            this.tourGui.getTourListModel().removeElementAt(selListIndex);
            this.tourGui.getTourJList().repaint();
        }
    }

    private void updatPlanTable(Object transferObject, int dropRow, int dropCol, int selRow, int selCol, int selTreeIndex) {
        if (selRow > -1 && selCol == 0) {
            this.planTableGui.getPlanTableModel().setObjectAt(new DelivererModelImpl(new Long(0L), null), selRow, selCol);
        } else if (selRow > -1 && selCol > 0) {
            this.planTableGui.getPlanTableModel().setObjectAt(new TourModelImpl(new Long(0L), null), selRow, selCol);
        }
        this.planTableGui.getPlanTableModel().setValueAt(this.updateObject(transferObject, dropRow, dropCol, selRow), dropRow, dropCol);
        this.planTableGui.getPlanTableModel().fireTableDataChanged();
    }

    private Object updateObject(Object transferObject, int dropRow, int dropCol, int selRow) {
        if (dropCol == 0) {
            return this.updateDeliverer((DelivererModel)transferObject, dropRow, selRow);
        }
        return this.updateTour((TourModel)transferObject, dropRow, dropCol);
    }

    private TourModel updateTour(TourModel tour, int dropRow, int dropCol) {
        DelivererModel deliverer = (DelivererModel)this.planTableGui.getObjectInTable(dropRow, 0);
        Date startTime = this.tourManagerCalendarGui.getDateFromCol(dropCol).getTime();
        this.tourManagerCalendarGui.getActions().getUndoManager().startTransaction();
        TourModelUtil.updatePlannedArrivalTime(TimeUtil.normalize(startTime), tour);
        this.tourManagerCalendarGui.getTourListGui().addNewTour(tour);
        this.planTableGui.fireTourObjectChanged(deliverer, tour);
        this.planTableGui.setTourPosition(tour, dropCol, dropRow);
        this.tourManagerCalendarGui.getActions().getUndoManager().finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.message.tourUpdate", new Serializable[]{tour.getName()}));
        return tour;
    }

    private DelivererModel updateDeliverer(DelivererModel deliverer, int dropRow, int selRow) {
        this.fireDelivererObjectChanged(deliverer, dropRow, selRow);
        this.planTableGui.setDelivererPosition(deliverer, dropRow);
        return deliverer;
    }

    private void fireDelivererObjectChanged(DelivererModel newDeliverer, int dropRow, int selRow) {
        this.tourManagerCalendarGui.getActions().getUndoManager().startTransaction();
        List<TourModel> toursInDropRow = this.planTableGui.getToursInRow(dropRow);
        for (DelivererModel deliverer : this.delivererGui.getAllDeliverers()) {
            if (!deliverer.getTempUUID().equals(newDeliverer.getTempUUID())) continue;
            this.fireTourObjectListChanged(deliverer, toursInDropRow);
        }
        if (selRow > -1) {
            List<TourModel> toursInSelRow = this.planTableGui.getToursInRow(selRow);
            this.fireTourObjectListChanged(new DelivererModelImpl(new Long(0L), null), toursInSelRow);
        }
        this.tourManagerCalendarGui.getActions().getUndoManager().finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.message.addDeliverer", new Serializable[]{newDeliverer.getDelivererNumber()}));
    }

    private void fireTourObjectListChanged(DelivererModel oldDeliverer, List<TourModel> toursInRow) {
        for (TourModel tour : toursInRow) {
            this.planTableGui.fireTourObjectChanged(oldDeliverer, tour);
        }
    }

    private boolean isAllowedDrop(DropTargetDropEvent dtde, int dropRow, int dropCol, int selRow, int selCol, int selListIndex, int selTreeIndex) {
        JDialog.setDefaultLookAndFeelDecorated(true);
        JRootPane parent = this.planTableGui.getPlanTable().getRootPane();
        if (dropCol != 0) {
            if (dtde.isDataFlavorSupported(DelivererTransferable.getDataFlavor())) {
                new ErrorMessagesDialog(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.message.dropErrorDeliverer", new Serializable[0]), parent);
                return false;
            }
            Object tourInTable = this.planTableGui.getObjectInTable(dropRow, dropCol);
            if (tourInTable instanceof TourModel && !new EqualsBuilder().append((Object)0L, ((TourModel)tourInTable).getTempUUID()).isEquals()) {
                return false;
            }
            Object objectInTable = this.planTableGui.getObjectInTable(dropRow, 0);
            DelivererModel assignedDeliverer = objectInTable == null ? null : (DelivererModel)objectInTable;
            Date tourDate = TimeUtil.add(this.planTableGui.getCurrentWeek().getElement1(), 5, dropCol - 1);
            try {
                return DelivererModelUtil.isDelivererTourMappingValid(assignedDeliverer, Collections.singleton(tourDate));
            }
            catch (NullPointerException e) {
                return true;
            }
        }
        if (dropCol == 0) {
            DelivererModel delivererTransferData;
            if (dtde.isDataFlavorSupported(TourTransferable.getDataFlavor())) {
                new ErrorMessagesDialog(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.message.dropErrorTour", new Serializable[0]), parent);
                return false;
            }
            try {
                delivererTransferData = (DelivererModel)dtde.getTransferable().getTransferData(DelivererTransferable.getDataFlavor());
            }
            catch (Exception e) {
                return false;
            }
            return DelivererModelUtil.isDelivererTourMappingValid(delivererTransferData, this.planTableGui.getTourDatesInRow(dropRow));
        }
        if (!this.planTableGui.getPlanTableModel().getValueAt(dropRow, dropCol).equals("")) {
            if (selRow == dropRow && selCol == dropCol) {
                return false;
            }
            if (dropCol != 0) {
                new ErrorMessagesDialog(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.message.dropHasTour", new Serializable[0]) + "<br>", parent);
            } else {
                new ErrorMessagesDialog(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.message.dropHasDeliverer", new Serializable[0]) + "<br>", parent);
            }
            return false;
        }
        return true;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        DelivererModel deliverer;
        this.tourGui.getTourJList().clearSelection();
        this.delivererGui.getDelivererJTree().clearSelection();
        Object selObject = this.planTableGui.getSelObject();
        if (selObject instanceof TourModel) {
            TourModel tour = (TourModel)selObject;
            if (tour.getTempUUID() != 0L) {
                dge.startDrag(DragSource.DefaultMoveDrop, new TourTransferable(tour), this);
            }
        } else if (selObject instanceof DelivererModel && (deliverer = (DelivererModel)selObject).getTempUUID() != 0L) {
            dge.startDrag(DragSource.DefaultMoveDrop, new DelivererTransferable<DelivererModel>(deliverer), this);
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
        DragSourceContext context = dsde.getDragSourceContext();
        if (this.planTableGui.isInTable(dsde.getLocation()) || this.tourGui.isInList(dsde.getLocation()) || this.delivererGui.isInTree(dsde.getLocation())) {
            context.setCursor(DragSource.DefaultMoveDrop);
        } else {
            context.setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(3);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Set<TourModel> selectedTours;
        if (e.getButton() == 1) {
            Object selObject = this.planTableGui.getSelObject();
            if (selObject != null) {
                if (e.getClickCount() == 2 && !e.isConsumed()) {
                    if (selObject instanceof TourModel && !((TourModel)selObject).getTempUUID().equals(new Long(0L))) {
                        e.consume();
                        TourSettingDialog.createAndShowGUI(this.tourManagerCalendarGui, (TourModel)selObject);
                    } else if (selObject instanceof DelivererModel && !((DelivererModel)selObject).getTempUUID().equals(new Long(0L))) {
                        e.consume();
                        new DelivererDialog(SwingUtils.findWindowParent(this.tourManagerCalendarGui), this.tourManagerCalendarGui.getModelEnviroment(), (DelivererModel)selObject, ModelEnviroment.getUserInformation().isAdmin() || ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.DISPONENT_SUPER));
                    }
                    this.planTableGui.getPlanTable().repaint(10L);
                } else if (e.getClickCount() == 1) {
                    if ((e.getModifiers() & 2) <= 0) {
                        this.planTableGui.clearSelectedTours();
                    }
                    if (selObject instanceof TourModelImpl) {
                        if (!((TourModel)selObject).getTempUUID().equals(new Long(0L))) {
                            this.planTableGui.updateSelectedTour((TourModel)selObject);
                        }
                    } else if (selObject instanceof DelivererModel) {
                        this.planTableGui.clearSelectedTours();
                        this.planTableGui.addToursInSelectedRow(this.planTableGui.getPlanTable().getSelectedRow());
                    }
                    this.planTableGui.getPlanTable().repaint(10L);
                }
            }
            this.clearSelection();
        } else if (e.getButton() == 3 && (selectedTours = this.planTableGui.getSelectedToursInTable().keySet()) != null && !selectedTours.isEmpty()) {
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add(new ToursRoutingAction(this.tourManagerCalendarGui, this.tourManagerCalendarGui, this.tourManagerCalendarGui.getBusyHandler()){
                private static final long serialVersionUID = -1577450926913501622L;

                @Override
                protected void repaintGui() {
                    TourMapGui tourMapGui = TourPlanTableListener.this.tourManagerCalendarGui.getTourMapGui();
                    if (tourMapGui != null) {
                        tourMapGui.repaintGui(false);
                    }
                    TourPlanTableListener.this.tourManagerCalendarGui.getTimeLineGui().refresh(this.getTours());
                }

                @Override
                protected Collection<TourModel> getTours() {
                    return selectedTours;
                }
            });
            final ModelEnviroment modelEnviroment = this.tourManagerCalendarGui.getModelEnviroment();
            final Window parent = SwingUtils.findWindowParent(this.tourManagerCalendarGui);
            popupMenu.add(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.calculate", new Serializable[]{" tats\u00e4chlich gefahrene KM"})){
                private static final long serialVersionUID = -6755810717609832196L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    modelEnviroment.getUndoManager().startTransaction();
                    TourCaller tourCaller = modelEnviroment.getAllCaller().getTourCaller();
                    for (TourModel tour : selectedTours) {
                        tourCaller.calculateActualTour(tour);
                    }
                    modelEnviroment.getUndoManager().finishTransaction("Berechnene tats\u00e4chlich KM - " + selectedTours.size());
                }
            });
            String motorcar = ModelEnviroment.getMessageResolver().resolveMessage("gui.route.calculate", new Serializable[]{" abgeschlossene Touren"}) + " (" + ModelEnviroment.getMessageResolver().resolveMessage("gui.route.motorcar", new Serializable[0]) + ")";
            popupMenu.add(new AbstractAction(motorcar){
                private static final long serialVersionUID = 1558578432787447336L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    modelEnviroment.getUndoManager().startTransaction();
                    ErrorMessages errors = new ErrorMessages();
                    TourCaller tourCaller = modelEnviroment.getAllCaller().getTourCaller();
                    TourPlanTableListener.prepareTours(selectedTours);
                    for (TourModel tour : selectedTours) {
                        try {
                            tourCaller.calculateTourOnlyServiceFinished(tour, RouteVehicleType.MOTORCAR, RouteType.FASTEST, modelEnviroment, OptimizationAlgorithmType.DEFAULT, SimpleTourRoutingContext.INSTANCE);
                        }
                        catch (LogisticException e1) {
                            errors.addErrorMessage(new ErrorMessage(e1.getMessage() + " - " + tour.getName()));
                        }
                    }
                    if (errors.hasErrors()) {
                        BufferedImage image;
                        try {
                            image = ImageIO.read(TourPlanTableListener.class.getResourceAsStream("/images/pepper.png"));
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                        ErrorMessageDialog errorMessageDialog = new ErrorMessageDialog(parent, ModelEnviroment.getMessageResolver(), errors, image);
                        errorMessageDialog.setVisible(true);
                    }
                    modelEnviroment.getUndoManager().finishTransaction("Berechnene tats\u00e4chlich KM - " + selectedTours.size());
                }
            });
            String foot = ModelEnviroment.getMessageResolver().resolveMessage("gui.route.calculate", new Serializable[]{" abgeschlossene Touren"}) + " (" + ModelEnviroment.getMessageResolver().resolveMessage("gui.route.foot", new Serializable[0]) + ")";
            popupMenu.add(new AbstractAction(foot){
                private static final long serialVersionUID = 3494853683630403015L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    modelEnviroment.getUndoManager().startTransaction();
                    ErrorMessages errors = new ErrorMessages();
                    TourCaller tourCaller = modelEnviroment.getAllCaller().getTourCaller();
                    TourPlanTableListener.prepareTours(selectedTours);
                    for (TourModel tour : selectedTours) {
                        try {
                            tourCaller.calculateTourOnlyServiceFinished(tour, RouteVehicleType.MOTORCAR, RouteType.FASTEST, modelEnviroment, OptimizationAlgorithmType.DEFAULT, SimpleTourRoutingContext.INSTANCE);
                        }
                        catch (LogisticException e1) {
                            errors.addErrorMessage(new ErrorMessage(e1.getMessage() + " - " + tour.getName()));
                        }
                    }
                    if (errors.hasErrors()) {
                        BufferedImage image;
                        try {
                            image = ImageIO.read(TourPlanTableListener.class.getResourceAsStream("/images/pepper.png"));
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                        ErrorMessageDialog errorMessageDialog = new ErrorMessageDialog(parent, ModelEnviroment.getMessageResolver(), errors, image);
                        errorMessageDialog.setVisible(true);
                    }
                    modelEnviroment.getUndoManager().finishTransaction("Berechnene tats\u00e4chlich KM - " + selectedTours.size());
                }
            });
            popupMenu.show(this.planTableGui.getPlanTable(), e.getX(), e.getY());
        }
    }

    public static void prepareTours(Collection<TourModel> tours) {
        if (!tours.isEmpty()) {
            SegmentModel segment;
            CommonCaller commonCaller = tours.iterator().next().getCommonCaller();
            HashSet<TourPartModel> tourParts = new HashSet<TourPartModel>();
            for (TourModel tourModel : tours) {
                for (TourPartModel tourPartModel : tourModel.iterableTourParts()) {
                    tourParts.add(tourPartModel);
                }
            }
            HashSet<StopModel> stops = new HashSet<StopModel>();
            for (TourPartModel tourPartModel : tourParts) {
                for (StopModel stopModel : tourPartModel.iterableStops()) {
                    stops.add(stopModel);
                }
            }
            HashSet<LocationModel> hashSet = new HashSet<LocationModel>();
            for (StopModel stopModel : stops) {
                hashSet.add(stopModel.getLocation());
            }
            HashSet<ParcelModel> hashSet2 = new HashSet<ParcelModel>();
            HashSet<SegmentModel> hashSet3 = new HashSet<SegmentModel>();
            for (LocationModel locationModel : hashSet) {
                ParcelModel parcelModel = locationModel.getParcel();
                if (parcelModel != null) {
                    hashSet2.add(parcelModel);
                }
                if ((segment = locationModel.getBikeSegment()) != null) {
                    hashSet3.add(segment);
                }
                if ((segment = locationModel.getFootSegment()) != null) {
                    hashSet3.add(segment);
                }
                if ((segment = locationModel.getMotorSegment()) == null) continue;
                hashSet3.add(segment);
            }
            HashSet<StreetModel> hashSet4 = new HashSet<StreetModel>();
            for (ParcelModel parcelModel : hashSet2) {
                hashSet4.add(parcelModel.getStreet());
                segment = parcelModel.getBikeSegment();
                if (segment != null) {
                    hashSet3.add(segment);
                }
                if ((segment = parcelModel.getFootSegment()) != null) {
                    hashSet3.add(segment);
                }
                if ((segment = parcelModel.getMotorSegment()) == null) continue;
                hashSet3.add(segment);
            }
            commonCaller.fetchModels(hashSet3, false);
            commonCaller.fetchModels(hashSet4, false);
            HashSet<PostcodeDistrictRelationModel> hashSet5 = new HashSet<PostcodeDistrictRelationModel>();
            for (StreetModel street : hashSet4) {
                hashSet5.add(street.getPostcodeDistrictRelation());
            }
            commonCaller.fetchModels(hashSet5, false);
            HashSet<PostcodeModel> hashSet6 = new HashSet<PostcodeModel>();
            HashSet<DistrictModel> districts = new HashSet<DistrictModel>();
            for (PostcodeDistrictRelationModel pdr : hashSet5) {
                hashSet6.add(pdr.getPostcode());
                districts.add(pdr.getDistrict());
            }
            commonCaller.fetchModels(hashSet6, false);
            commonCaller.fetchModels(districts, false);
            HashSet<CityModel> cities = new HashSet<CityModel>();
            for (DistrictModel district : districts) {
                cities.add(district.getCity());
            }
            commonCaller.fetchModels(cities, false);
        }
    }
}

