/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.listener;

import de.datomino.peppergis.client.util.ClientFormUtil;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Date;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractDateSpinnerListener
implements FocusListener,
ChangeListener {
    protected JFormattedTextField dateTextField;
    private String inputString;

    public AbstractDateSpinnerListener(JFormattedTextField dateTextField) {
        this.dateTextField = dateTextField;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.dateTextField.setEditable(true);
        if (this.dateTextField.getText() == null || this.dateTextField.getText().equals("")) {
            ((JSpinner.DefaultEditor)this.dateTextField.getParent()).getSpinner().setValue(new Date());
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        Date date;
        this.inputString = this.dateTextField.getText();
        this.dateTextField.setEditable(false);
        Container container = this.dateTextField.getParent().getParent();
        if (container instanceof JSpinner && (date = ClientFormUtil.stringToDate(this.dateTextField.getText())) != null) {
            this.fireChangedDate(date);
        }
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        if (this.inputString == null || this.inputString.equals("")) {
            this.fireChangedDate(null);
        } else {
            JSpinner spinner = (JSpinner)evt.getSource();
            this.fireChangedDate((Date)spinner.getValue());
        }
    }

    public abstract void fireChangedDate(Date var1);
}

