/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.tour;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.gui.map.TourMapGui;
import de.datomino.peppergis.tourmanager.gui.timeline.TourTimeLineGui;
import de.datomino.peppergis.tourmanager.gui.tour.TourPlanTableGui;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import org.ktde.util.datatypes.Tupel;

public class ShowSelectedToursAction
extends AbstractAction {
    private static final long serialVersionUID = 3300804306807965436L;
    private TourManagerCalendarGui tourManagerCalendarGui;

    public ShowSelectedToursAction(TourManagerCalendarGui tourManagerCalendarGui) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.selectedTours", new Serializable[0]));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(114, 0));
        this.tourManagerCalendarGui = tourManagerCalendarGui;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TourMapGui tourMapGui = this.tourManagerCalendarGui.getTourMapGui();
        tourMapGui.clearUnsortedStops();
        tourMapGui.setStopSymbolWithStock(true);
        Set<TourModel> tours = null;
        JTabbedPane tabbedPane = this.tourManagerCalendarGui.getTabbedPane();
        TourPlanTableGui planTable = this.tourManagerCalendarGui.getPlanTableGui();
        TourTimeLineGui timeLine = this.tourManagerCalendarGui.getTimeLineGui();
        if (tabbedPane.getSelectedIndex() == 0) {
            Map<TourModel, Tupel<Integer, Integer>> selectedToursInTable = planTable.getSelectedToursInTable();
            tours = selectedToursInTable.keySet();
        } else if (tabbedPane.getSelectedIndex() == 2) {
            tours = timeLine.getSelectedTours();
        }
        if (tours == null || tours.isEmpty()) {
            JOptionPane.showMessageDialog(this.tourManagerCalendarGui, ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.message.noTour", new Serializable[0]));
            return;
        }
        tabbedPane.setSelectedComponent(tourMapGui);
        tourMapGui.setSelectedTours(tours);
        tourMapGui.center();
        if (tourMapGui.getGeoTrackingRenderer().isActive()) {
            this.tourManagerCalendarGui.loadGeoTracks();
        }
    }
}

