/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.tour;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourPartModelImpl;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.tourmanager.gui.tour.AddTourDialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.datatypes.Tripel;

public class AddTourActions {
    private AddTourDialog addAndUpdateTourDialog;
    private Action saveTourModelAction;
    private Action canelTourModelAction;
    private Action addTourPartAction;
    private Action removeTourPartAction;

    public AddTourActions(AddTourDialog addAndUpdateTourDialog) {
        this.addAndUpdateTourDialog = addAndUpdateTourDialog;
        this.initialize();
    }

    private void initialize() {
        this.saveTourModelAction = new AbstractAction(){
            private static final long serialVersionUID = -4959802565073818890L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AddTourActions.this.storeTourModel();
            }
        };
        this.canelTourModelAction = new AbstractAction(){
            private static final long serialVersionUID = 6136972358959809321L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AddTourActions.this.canelTourModel();
            }
        };
        this.addTourPartAction = new AbstractAction(){
            private static final long serialVersionUID = 466100042301881871L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AddTourActions.this.addTourPart();
            }
        };
        this.removeTourPartAction = new AbstractAction(){
            private static final long serialVersionUID = 5569574484911835206L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AddTourActions.this.removeTourPart();
            }
        };
    }

    protected void canelTourModel() {
        this.addAndUpdateTourDialog.setVisible(false);
    }

    protected void storeTourModel() {
        String name = this.addAndUpdateTourDialog.getNameField().getText();
        if (name.equals("") || this.addAndUpdateTourDialog.getTourPartFields().get(0).getElement1().getText().equals("")) {
            JOptionPane.showMessageDialog(this.addAndUpdateTourDialog, ModelEnviroment.getMessageResolver().resolveMessage("messages.warn.fillInComplete", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.warning", new Serializable[0]), 2);
            return;
        }
        if (!this.checkDuplicateName(name)) {
            JOptionPane.showMessageDialog(this.addAndUpdateTourDialog, ModelEnviroment.getMessageResolver().resolveMessage("messages.error.tour.newTour.duplicateName", new Serializable[]{name}), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.warning", new Serializable[0]), 2);
            return;
        }
        this.addAndUpdateTourDialog.setSavePressend(true);
        this.addAndUpdateTourDialog.setVisible(false);
    }

    private boolean checkDuplicateName(String name) {
        ModelEnviroment modelEnviroment = this.addAndUpdateTourDialog.getModelEnviroment();
        Collection<? extends Model> tours = modelEnviroment.getModelCache().getAllDirtyModels().get(TourModel.class);
        if (tours != null) {
            for (TourModel tourModel : tours) {
                if (!new EqualsBuilder().append(name, tourModel.getName()).isEquals()) continue;
                return false;
            }
        }
        return !modelEnviroment.getAllCaller().getTourCaller().existsTourWithName(name);
    }

    protected void removeTourPart() {
        if (this.addAndUpdateTourDialog.getTourPartFields().size() <= 1) {
            return;
        }
        JLabel label = this.addAndUpdateTourDialog.getTourPartFields().get(this.addAndUpdateTourDialog.getTourPartFields().size() - 1).getElement1();
        JTextField field = this.addAndUpdateTourDialog.getTourPartFields().get(this.addAndUpdateTourDialog.getTourPartFields().size() - 1).getElement2();
        JTextArea area = this.addAndUpdateTourDialog.getTourPartFields().get(this.addAndUpdateTourDialog.getTourPartFields().size() - 1).getElement3();
        this.addAndUpdateTourDialog.getTourPartsPanel().remove(label);
        this.addAndUpdateTourDialog.getTourPartsPanel().remove(field);
        this.addAndUpdateTourDialog.getTourPartsPanel().remove(area.getParent().getParent());
        this.addAndUpdateTourDialog.getTourPartsPanel().setPreferredSize(new Dimension(460, this.addAndUpdateTourDialog.getTourPartsPanel().getPreferredSize().height - 85));
        this.addAndUpdateTourDialog.getTourPartsPanel().getParent().getParent().validate();
        this.addAndUpdateTourDialog.getTourPartFields().remove(this.addAndUpdateTourDialog.getTourPartFields().size() - 1);
        this.addAndUpdateTourDialog.repaint();
    }

    protected void addTourPart() {
        Rectangle label = this.addAndUpdateTourDialog.getTourPartFields().get(this.addAndUpdateTourDialog.getTourPartFields().size() - 1).getElement1().getBounds();
        Rectangle field = this.addAndUpdateTourDialog.getTourPartFields().get(this.addAndUpdateTourDialog.getTourPartFields().size() - 1).getElement2().getBounds();
        Rectangle area = this.addAndUpdateTourDialog.getTourPartFields().get(this.addAndUpdateTourDialog.getTourPartFields().size() - 1).getElement3().getBounds();
        JLabel newTourPartLabel = new JLabel("Teil " + (this.addAndUpdateTourDialog.getTourPartFields().size() + 1) + ": ");
        newTourPartLabel.setBounds(0, label.y + 90, 50, label.height);
        this.addAndUpdateTourDialog.getTourPartsPanel().add(newTourPartLabel);
        JTextField newTourPartField = new JTextField("");
        newTourPartField.setBounds(50, field.y + 90, 410, field.height);
        this.addAndUpdateTourDialog.getTourPartsPanel().add(newTourPartField);
        JTextArea newTourPartArea = new JTextArea(" ");
        newTourPartArea.setBounds(0, area.y + 90, area.width, area.height);
        this.addAndUpdateTourDialog.getTourPartsPanel().add(ClientSwingUtil.scrollTextArea(newTourPartArea, new Rectangle(label.x, label.y + 120, 460, area.height), true));
        this.addAndUpdateTourDialog.getTourPartsPanel().setPreferredSize(new Dimension(460, label.y + 120 + area.height));
        this.addAndUpdateTourDialog.getTourPartsPanel().getParent().getParent().validate();
        this.addAndUpdateTourDialog.getTourPartFields().add(new Tripel<JLabel, JTextField, JTextArea>(newTourPartLabel, newTourPartField, newTourPartArea));
        this.addAndUpdateTourDialog.repaint();
    }

    public void updateTourModel() {
        this.addAndUpdateTourDialog.getTourModel().setName(this.addAndUpdateTourDialog.getNameField().getText());
        this.addAndUpdateTourDialog.getTourModel().setInformation(this.addAndUpdateTourDialog.getInfoArea().getText());
        for (int i = 0; i < this.addAndUpdateTourDialog.getTourPartFields().size(); ++i) {
            TourPartModelImpl tourPart = new TourPartModelImpl();
            tourPart.setName(this.addAndUpdateTourDialog.getTourPartFields().get(i).getElement2().getText());
            tourPart.setInformation(this.addAndUpdateTourDialog.getTourPartFields().get(i).getElement3().getText());
            tourPart.setSortOrder(i);
            tourPart.setTour(this.addAndUpdateTourDialog.getTourModel());
            tourPart.getTempUUID();
            this.addAndUpdateTourDialog.getTourModel().addTourPart(tourPart);
        }
    }

    public Action getSaveTourModelAction() {
        return this.saveTourModelAction;
    }

    public Action getCanelTourModelAction() {
        return this.canelTourModelAction;
    }

    public Action getAddTourPartAction() {
        return this.addTourPartAction;
    }

    public Action getRemoveTourPartAction() {
        return this.removeTourPartAction;
    }
}

