/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.stop;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.StopModelImpl;
import de.datomino.peppergis.tourmanager.gui.stop.StopInformationPanel;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.common.PrimitiveUtil;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JSpinner;
import org.ktde.util.cache.ChangeSet;

public class StopInformationRollbackAction
extends AbstractAction {
    private static final long serialVersionUID = -7434671909278427073L;
    private StopInformationPanel stopInformationPanel;
    private StopModel stopModel;
    private UndoManager undoManager;

    public StopInformationRollbackAction(StopInformationPanel stopInformationPanel, StopModel stopModel, UndoManager undoManager) {
        this.stopInformationPanel = stopInformationPanel;
        this.stopModel = stopModel;
        this.undoManager = undoManager;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.rollbackStopInformation();
    }

    private void rollbackStopInformation() {
        Iterator<ChangeSet> changeIterator = ChangeSet.currentChangeTransaction.get().iterator();
        ArrayList<ChangeSet> unRollbackList = new ArrayList<ChangeSet>();
        while (changeIterator.hasNext()) {
            ChangeSet changeSet = changeIterator.next();
            Object changeObject = changeSet.getObject();
            if (changeObject instanceof StopModelImpl) continue;
            ChangeSet.currentChangeTransaction.removeContextObject(changeObject);
            unRollbackList.add(changeSet);
        }
        this.undoManager.rollbackTransaction();
        this.undoManager.startTransaction();
        ChangeSet.currentChangeTransaction.remove();
        ChangeSet.currentChangeTransaction.set(unRollbackList);
        this.repaintStopInformationPanel();
    }

    private void repaintStopInformationPanel() {
        if (this.stopModel.getEstimatedTimeOfArrival() == null) {
            ((JSpinner.DefaultEditor)this.stopInformationPanel.getEstimatedTimeSpinner().getEditor()).getTextField().setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.noA", new Serializable[0]));
        } else {
            this.stopInformationPanel.getEstimatedTimeSpinner().setValue(this.stopModel.getEstimatedTimeOfArrival());
        }
        this.stopInformationPanel.getEstimatedDurationField().setDurationInSeconds(PrimitiveUtil.nullToZero(this.stopModel.getEstimatedDurationSeconds()));
        this.stopInformationPanel.getInfomationArea().setText(FormUtil.getStringDisplay(this.stopModel.getInformation()));
        this.stopInformationPanel.getInfomationArea().setCaretPosition(0);
        this.stopInformationPanel.getParkingInformationArea().setText(FormUtil.getStringDisplay(this.stopModel.getParkingInformation()));
        this.stopInformationPanel.getParkingInformationArea().setCaretPosition(0);
        this.stopInformationPanel.getDelivererInformationArea().setText(FormUtil.getStringDisplay(this.stopModel.getDelivererInformation()));
        this.stopInformationPanel.getDelivererInformationArea().setCaretPosition(0);
    }
}

