/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.stop;

import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.communication.tour.StopFilterEntity;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.AbstractTableRenderer;
import de.datomino.peppergis.client.gui.renderer.MultiLineHeaderRenderer;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.client.util.DelivererModelUtil;
import de.datomino.peppergis.tourmanager.gui.filter.SearchFilterSettingPane;
import de.datomino.peppergis.tourmanager.gui.stop.AddAndUpdateStopDialog;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.comparator.NumericalStringComparator;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class SearchStopsAction
extends AbstractAction {
    private static final long serialVersionUID = 6751804767424600922L;
    private ModelEnviroment modelEnviroment;
    private Component parent;
    private StopTableModel stopTableModel;
    private JTable stopTable;
    private List<StopModel> stops;
    private Collection<StopModel> selectedStops = new HashSet<StopModel>();

    public SearchStopsAction(ModelEnviroment modelEnviroment, Component parent, String title) {
        super(title);
        this.modelEnviroment = modelEnviroment;
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.createAndShowDialog();
    }

    protected void fireSelection(Collection<StopModel> stops) {
    }

    private void createAndShowDialog() {
        JDialog dialog = new JDialog(SwingUtils.findWindowParent(this.parent), ModelEnviroment.getMessageResolver().resolveMessage("messages.search.stop", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        try {
            dialog.setIconImage(ImageIO.read(SearchStopsAction.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        dialog.getContentPane().setLayout(new BorderLayout());
        this.addSearchingPanel(dialog);
        this.addStopTablePanel(dialog);
        dialog.setDefaultCloseOperation(2);
        Dimension dialogPreferredSize = dialog.getPreferredSize();
        dialogPreferredSize.height = Math.min(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode().getHeight() - 55, dialogPreferredSize.height);
        dialog.setPreferredSize(dialogPreferredSize);
        dialog.pack();
        dialog.setResizable(false);
        dialog.setVisible(true);
        SwingUtils.centerDialog(dialog, SwingUtils.findWindowParent(this.parent));
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                SearchStopsAction.this.fireSelection(SearchStopsAction.this.selectedStops);
            }
        });
    }

    private void addStopTablePanel(JDialog dialog) {
        this.stopTableModel = new StopTableModel();
        this.stopTable = new JTable(this.stopTableModel);
        this.setTourTableStyle(this.stopTable);
        this.stopTable.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.stopTable.getSelectionModel().setSelectionMode(2);
        this.stopTable.setRowSorter((RowSorter<? extends TableModel>)new TableRowSorter<TableModel>((TableModel)this.stopTableModel){

            @Override
            public Comparator<?> getComparator(int column) {
                if (column == 0) {
                    return NumericalStringComparator.INSTANCE;
                }
                return super.getComparator(column);
            }
        });
        this.stopTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    StopModel selectedStop = SearchStopsAction.this.getSelectedStop();
                    if (selectedStop != null && e.getClickCount() == 1) {
                        if ((e.getModifiers() & 2) <= 0) {
                            SearchStopsAction.this.selectedStops.clear();
                        }
                        SearchStopsAction.this.selectedStops.add(selectedStop);
                        SearchStopsAction.this.stopTable.repaint(10L);
                    } else if (selectedStop != null && e.getClickCount() == 2) {
                        AddAndUpdateStopDialog dialog = new AddAndUpdateStopDialog(SearchStopsAction.this.modelEnviroment, true, null);
                        dialog.showDialog(selectedStop, false, SearchStopsAction.this.parent);
                    }
                }
                SearchStopsAction.this.stopTable.clearSelection();
            }
        });
        this.stopTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int viewColumn;
                JTableHeader h;
                TableColumnModel columnModel;
                int selectedColumn;
                if (e.getButton() == 1 && e.getClickCount() == 1 && (selectedColumn = (columnModel = (h = (JTableHeader)e.getSource()).getColumnModel()).getColumn(viewColumn = columnModel.getColumnIndexAtX(e.getX())).getModelIndex()) == 0 && SearchStopsAction.this.stops != null) {
                    if (SearchStopsAction.this.stops.size() == SearchStopsAction.this.selectedStops.size()) {
                        SearchStopsAction.this.selectedStops.clear();
                    } else {
                        SearchStopsAction.this.selectedStops = new HashSet(SearchStopsAction.this.stops);
                    }
                }
            }
        });
        dialog.getContentPane().add((Component)new JScrollPane(this.stopTable), "Center");
    }

    private StopModel getSelectedStop() {
        int index = Integer.parseInt((String)this.stopTable.getValueAt(this.stopTable.getSelectedRow(), 0)) - 1;
        if (index >= 0 && index < this.stops.size()) {
            return this.stops.get(index);
        }
        return null;
    }

    private void fillStopTable(List<StopModel> stops) {
        this.stops = stops;
        this.selectedStops.clear();
        if (stops != null) {
            this.stopTableModel.setData(stops);
            this.stopTableModel.fireTableDataChanged();
            this.setTourTableStyle(this.stopTable);
        }
    }

    private void setTourTableStyle(JTable stopTable) {
        stopTable.setCellSelectionEnabled(false);
        stopTable.setRowHeight(40);
        stopTable.setRowMargin(5);
        stopTable.getColumnModel().getColumn(0).setPreferredWidth(20);
        stopTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        stopTable.getColumnModel().getColumn(2).setPreferredWidth(100);
        stopTable.getColumnModel().getColumn(3).setPreferredWidth(100);
        stopTable.getColumnModel().getColumn(4).setPreferredWidth(100);
        MultiLineHeaderRenderer headerRenderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = stopTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setHeaderRenderer(headerRenderer);
            tableColumn.setCellRenderer(new AbstractTableRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JList list = this.createJList(value, 2, table.getFont());
                    list.setFont(table.getFont());
                    list.setBorder(BorderFactory.createEmptyBorder());
                    int index = Integer.parseInt((String)SearchStopsAction.this.stopTable.getValueAt(row, 0)) - 1;
                    if (index >= 0 && index < SearchStopsAction.this.stops.size()) {
                        StopModel stop = (StopModel)SearchStopsAction.this.stops.get(index);
                        if (SearchStopsAction.this.selectedStops.contains(stop)) {
                            list.setBackground(Color.YELLOW);
                        }
                    }
                    return list;
                }
            });
        }
    }

    private String getFormatedString(String string) {
        return " \n" + string + "\n \n";
    }

    private void addSearchingPanel(final JDialog dialog) {
        final TourCaller tourCaller = this.modelEnviroment.getAllCaller().getTourCaller();
        final SearchFilterSettingPane settingPanel = new SearchFilterSettingPane(tourCaller);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel1 = new JPanel(new GridLayout(5, 1));
        JButton searchButton = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.search", new Serializable[0])){
            private static final long serialVersionUID = -3646514689013680253L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int b;
                StopFilterEntity entity = settingPanel.getFilterEntity();
                if (entity.isNull() && (b = JOptionPane.showConfirmDialog(settingPanel, ModelEnviroment.getMessageResolver().resolveMessage("messages.filter.confirm.noLimitation", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.confirmation", new Serializable[0]), 2)) != 0) {
                    return;
                }
                entity.setAllowWildcard(true);
                List<StopModel> stops = tourCaller.fetchStopsWithFilter(entity);
                SearchStopsAction.this.fillStopTable(stops);
            }
        });
        buttonPanel1.add(searchButton);
        buttonPanel1.add(new JLabel());
        JButton clearButton = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.reset", new Serializable[0])){
            private static final long serialVersionUID = 7007738129693715425L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                settingPanel.clear();
            }
        });
        buttonPanel1.add(clearButton);
        buttonPanel1.add(new JLabel());
        JButton cancelButton = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("buttons.cancel", new Serializable[0])){
            private static final long serialVersionUID = 7007738129693715425L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchStopsAction.this.selectedStops.clear();
                dialog.dispose();
            }
        });
        buttonPanel1.add(cancelButton);
        buttonPanel.add((Component)buttonPanel1, "North");
        buttonPanel.add((Component)new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.removefromroute", new Serializable[0])){
            private static final long serialVersionUID = -3923084798882075885L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchStopsAction.this.clearTourOfSelectedStops();
            }
        }), "South");
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(20, 5, 5, 5));
        JPanel searchingPanel = new JPanel(new BorderLayout());
        searchingPanel.add((Component)settingPanel, "Center");
        searchingPanel.add((Component)buttonPanel, "East");
        searchingPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        dialog.getContentPane().add((Component)searchingPanel, "North");
    }

    protected void clearTourOfSelectedStops() {
        UndoManager undoManager = this.modelEnviroment.getUndoManager();
        undoManager.startTransaction();
        for (StopModel stop : this.selectedStops) {
            stop.setTourPart(null);
            stop.setEstimatedTimeOfArrival(null);
            stop.setStreetMileageMetersFromTourStart(null);
            stop.setStopStatus(null);
        }
        undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.removefromroute", new Serializable[0]));
        this.fillStopTable(this.stops);
    }

    private class StopTableModel
    implements TableModel {
        private List<StopModel> data;
        private List<TableModelListener> listeners = new LinkedList<TableModelListener>();

        private StopTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.data == null ? 0 : this.data.size();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int columnIndex) {
            String header = "";
            switch (columnIndex) {
                case 0: {
                    header = " \n#\n \n";
                    break;
                }
                case 1: {
                    header = SearchStopsAction.this.getFormatedString(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.stop", new Serializable[0]));
                    break;
                }
                case 2: {
                    header = SearchStopsAction.this.getFormatedString(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.tour", new Serializable[0]));
                    break;
                }
                case 3: {
                    header = SearchStopsAction.this.getFormatedString(ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.deliverer", new Serializable[0]));
                    break;
                }
                case 4: {
                    header = SearchStopsAction.this.getFormatedString(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.plannedStartTime", new Serializable[0]));
                }
            }
            return header;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            StopModel stop = this.data.get(rowIndex);
            TourPartModel tourPart = stop.getTourPart();
            TourModel tour = tourPart == null ? null : tourPart.getTour();
            String value = "";
            switch (columnIndex) {
                case 0: {
                    value = Integer.toString(rowIndex + 1);
                    break;
                }
                case 1: {
                    value = stop.getName();
                    break;
                }
                case 2: {
                    if (tour == null) break;
                    value = FormUtil.getStringDisplay(tour.getName());
                    break;
                }
                case 3: {
                    if (tour == null) break;
                    value = DelivererModelUtil.getDisplayString(tour.getDeliverer());
                    break;
                }
                case 4: {
                    Date plannedStartTime;
                    if (tour == null || (plannedStartTime = tour.getPlannedStartTime()) == null) break;
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FormUtil.DATEFORMAT);
                    value = simpleDateFormat.format(plannedStartTime);
                }
            }
            return value;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }

        protected void fireTableDataChanged() {
            TableModelEvent event = new TableModelEvent(this);
            for (TableModelListener listener : this.listeners) {
                listener.tableChanged(event);
            }
        }

        public void setData(List<StopModel> data) {
            this.data = data;
        }
    }
}

