/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.stop;

import de.datomino.peppergis.client.data.DataManagerAccess;
import de.datomino.peppergis.client.gui.Pausable;
import de.datomino.peppergis.client.gui.PausableInternalFrame;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.tour.ServiceTicketStopRelationModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.StopModelImpl;
import de.datomino.peppergis.client.model.tour.TimeWindowModelImpl;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.tourmanager.gui.stop.AddAndUpdateStopDialog;
import de.datomino.peppergis.tourmanager.gui.stop.StopInformationPanel;
import de.datomino.peppergis.tourmanager.gui.stop.StopTablePanel;
import de.datomino.peppergis.tourmanager.handler.action.service.ServiceValueRollbackAction;
import de.datomino.peppergis.tourmanager.handler.action.stop.AddTimeWindowAction;
import de.datomino.peppergis.tourmanager.handler.action.stop.RemoveTimeWindowAction;
import de.datomino.peppergis.tourmanager.handler.action.stop.StopInformationRollbackAction;
import de.datomino.peppergis.tourmanager.handler.action.stop.StopLocationActions;
import de.datomino.peppergis.tourmanager.handler.action.stop.StopTimeWindowsActions;
import de.datomino.peppergis.type.UserRole;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import org.ktde.swing.DesktopClientApplication;
import org.ktde.swing.InternalFrame;
import org.ktde.util.datatypes.Quad;

public class AddAndUpdateStopActions {
    private AddAndUpdateStopDialog addAndUpdateStopDialog;
    private Action saveStopModelAction;
    private Action cancelStopModelAction;
    private Action selectLocaitonModelAction;
    private AddTimeWindowAction addTimeWindowAction;
    private RemoveTimeWindowAction removeTimeWindowAction;
    private StopLocationActions stopLocationActions;
    private StopTimeWindowsActions stopTimeWindowsActions;
    private Action editCoordinateAction;

    public AddAndUpdateStopActions(AddAndUpdateStopDialog addAndUpdateStopDialog) {
        this.addAndUpdateStopDialog = addAndUpdateStopDialog;
        this.initialize();
    }

    private void initialize() {
        this.saveStopModelAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = 452487950861176437L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AddAndUpdateStopActions.this.saveStopModel();
            }
        };
        this.cancelStopModelAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = -2503313782916634921L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AddAndUpdateStopActions.this.setAndUpdateStopDialogVisible(false);
            }
        };
        this.selectLocaitonModelAction = new AbstractAction(){
            private static final long serialVersionUID = -3665387622703575195L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AddAndUpdateStopActions.this.stopLocationActions.selectLocationModel(e.getActionCommand());
            }
        };
        this.editCoordinateAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.edit", new Serializable[0])){
            private static final long serialVersionUID = -2010214180909409376L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopClientApplication<? extends InternalFrame> desktopClientApplication = ModelEnviroment.getDesktopClientApplication();
                PausableInternalFrame frame = (PausableInternalFrame)desktopClientApplication.getWindow("tourmanager");
                StopTablePanel stopTablePanel = AddAndUpdateStopActions.this.addAndUpdateStopDialog.getStopTablePanel();
                if (stopTablePanel != null) {
                    Pausable pausableDialog = stopTablePanel.getPausableDialog();
                    frame.pause(pausableDialog);
                }
                frame.pause(AddAndUpdateStopActions.this.addAndUpdateStopDialog);
                DataManagerAccess.showModel(desktopClientApplication, AddAndUpdateStopActions.this.addAndUpdateStopDialog.getStopModel());
                frame.unlockResume();
            }
        };
        this.addTimeWindowAction = new AddTimeWindowAction(this.addAndUpdateStopDialog);
        this.removeTimeWindowAction = new RemoveTimeWindowAction(this.addAndUpdateStopDialog);
        this.stopLocationActions = new StopLocationActions(this.addAndUpdateStopDialog);
        this.stopTimeWindowsActions = new StopTimeWindowsActions(this.addAndUpdateStopDialog);
    }

    public void setStopDialogEditable(boolean editable) {
        if (editable) {
            return;
        }
        this.addAndUpdateStopDialog.getNameField().setEditable(editable);
        this.disableOfTimeWindowFields(this.addAndUpdateStopDialog.getTimeWindowFields().iterator());
        if (!ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.DELIVERER_ACTIVE, UserRole.ADMIN, UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.DISPONENT_SUPER)) {
            this.addAndUpdateStopDialog.getAddTimeWindowButton().setEnabled(editable);
            this.addAndUpdateStopDialog.getRemoveTimeWindowButton().setEnabled(editable);
            this.addAndUpdateStopDialog.getAddAndUpdateStopActions().getSaveStopModelAction().setEnabled(editable);
        }
    }

    private void disableOfTimeWindowFields(Iterator<Quad<JLabel, JSpinner, JLabel, JSpinner>> timeWindowFieldsIter) {
        while (timeWindowFieldsIter.hasNext()) {
            Quad<JLabel, JSpinner, JLabel, JSpinner> timeWindowFieldsQuad = timeWindowFieldsIter.next();
            ClientSwingUtil.setSpinnerEnable(timeWindowFieldsQuad.getElement2(), false);
            ClientSwingUtil.setSpinnerEnable(timeWindowFieldsQuad.getElement4(), false);
        }
    }

    private void setAndUpdateStopDialogVisible(boolean b) {
        this.addAndUpdateStopDialog.setVisible(b);
    }

    public void loadStopModel() {
        this.addAndUpdateStopDialog.getNameField().setText(this.addAndUpdateStopDialog.getStopModel().getName());
        this.addAndUpdateStopDialog.getBranchComboBox().setSelectedItem(this.addAndUpdateStopDialog.getStopModel().getBranch());
        this.stopTimeWindowsActions.loadTimeWindowsModels(this.addAndUpdateStopDialog.getStopModel().iterateTimeWindows());
        this.stopLocationActions.loadLocationModel(this.addAndUpdateStopDialog.getStopModel().getLocation());
    }

    public void updateStopModel() {
        StopModel stop = this.addAndUpdateStopDialog.getStopModel();
        if (stop == null) {
            this.addAndUpdateStopDialog.setStopModel(new StopModelImpl());
        }
        stop.getTempUUID();
        stop.setName(this.addAndUpdateStopDialog.getNameField().getText());
        BranchModel branch = (BranchModel)this.addAndUpdateStopDialog.getBranchComboBox().getSelectedItem();
        stop.setBranch(branch);
        List<Quad<JLabel, JSpinner, JLabel, JSpinner>> timeWindowFields = this.addAndUpdateStopDialog.getTimeWindowFields();
        stop.clearTimeWindows();
        for (Quad<JLabel, JSpinner, JLabel, JSpinner> quad : timeWindowFields) {
            TimeWindowModelImpl timeWindow = new TimeWindowModelImpl();
            timeWindow.setStartTime((Date)quad.getElement2().getValue());
            timeWindow.setEndTime((Date)quad.getElement4().getValue());
            stop.addTimeWindow(timeWindow);
        }
        this.stopLocationActions.loadLocationModel(this.addAndUpdateStopDialog.getStopModel().getLocation());
        this.addAndUpdateStopDialog.createServiceValueHistories();
    }

    private void saveStopModel() {
        if (this.addAndUpdateStopDialog.getNameField().getText().equals("") || this.addAndUpdateStopDialog.getNameField().getText() == null) {
            this.addAndUpdateStopDialog.getMessageField().setText("Bitte vollst\u00e4ndig ausf\u00fcllen.");
            return;
        }
        this.addAndUpdateStopDialog.getUndoManager().joinTransaction();
        this.addAndUpdateStopDialog.getUndoManager().startTransaction();
        this.updateStopModel();
        this.addAndUpdateStopDialog.dispose();
        if (this.addAndUpdateStopDialog.isEditable()) {
            return;
        }
        this.addAndUpdateStopDialog.getUndoManager().finishTransaction("Ein Stopp " + this.addAndUpdateStopDialog.getStopModel().getName() + " wird ge\u00e4ndert.");
        if (this.addAndUpdateStopDialog.isParentUndoManagerStarted()) {
            this.addAndUpdateStopDialog.getUndoManager().startTransaction();
        }
    }

    public Action getSaveStopModelAction() {
        return this.saveStopModelAction;
    }

    public Action getCancelStopModelAction() {
        return this.cancelStopModelAction;
    }

    public Action getSelectLocaitonModelAction() {
        return this.selectLocaitonModelAction;
    }

    public AddTimeWindowAction getAddTimeWindowAction() {
        return this.addTimeWindowAction;
    }

    public Action getRemoveTimeWindowAction() {
        return this.removeTimeWindowAction;
    }

    public StopLocationActions getStopLocationActions() {
        return this.stopLocationActions;
    }

    public StopTimeWindowsActions getStopTimeWindowsActions() {
        return this.stopTimeWindowsActions;
    }

    public Action getServiceValueRollbackAction(JPanel serviceTicketPanel, ServiceTicketStopRelationModel relationModel, UndoManager undoManager) {
        return new ServiceValueRollbackAction(serviceTicketPanel, relationModel, undoManager);
    }

    public Action getStopInformationRollbackAction(StopInformationPanel stopInformationPanel, StopModel stopModel, UndoManager undoManager) {
        return new StopInformationRollbackAction(stopInformationPanel, stopModel, undoManager);
    }

    public Action getEditCoordinateAction() {
        return this.editCoordinateAction;
    }
}

