/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.service;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.util.swing.blocking.AbstractBusyHandlingAction;
import de.datomino.util.time.TimeUtil;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Date;
import javax.swing.JOptionPane;

public class SumServicesAction
extends AbstractBusyHandlingAction {
    private static final long serialVersionUID = -164583201899556670L;
    private TourManagerCalendarGui tourManagerCalendarGui;
    private ModelEnviroment modelEnviroment;

    public SumServicesAction(TourManagerCalendarGui tourManagerCalendarGui, ModelEnviroment modelEnviroment) {
        super(modelEnviroment.getMessageResolver().resolveMessage("messages.default.services", new Serializable[0]), tourManagerCalendarGui.getBusyHandler());
        this.tourManagerCalendarGui = tourManagerCalendarGui;
        this.modelEnviroment = modelEnviroment;
    }

    @Override
    public void actionPerformedInternal(ActionEvent e) {
        Date currentDate = this.tourManagerCalendarGui.getCalendarGui().getCurrentDate();
        int sumOfServices = 0;
        int sumOfTours = 0;
        boolean toursSelected = false;
        for (TourModel tour : this.tourManagerCalendarGui.getPlanTableGui().getSelectedToursInTable().keySet()) {
            toursSelected = true;
            ++sumOfTours;
            sumOfServices += TourModelUtil.countServicesOfTour(tour);
        }
        if (!toursSelected) {
            for (TourModel tour : this.tourManagerCalendarGui.getTourListGui().getPlannedToursInWeek(currentDate)) {
                if (!TimeUtil.isSamedWeek(currentDate, tour.getPlannedStartTime())) continue;
                ++sumOfTours;
                sumOfServices += TourModelUtil.countServicesOfTour(tour);
            }
        }
        super.getBusyHandler().stop();
        this.createDialog(sumOfTours, sumOfServices, toursSelected);
    }

    private void createDialog(int sumOfTours, int sumOfServices, boolean toursSelected) {
        String message;
        if (toursSelected) {
            SumServicesAction sumServicesAction = this;
            message = sumServicesAction.modelEnviroment.getMessageResolver().resolveMessage("gui.tour.sumOverSelection", new Serializable[0]) + "\n\n";
        } else {
            SumServicesAction sumServicesAction = this;
            message = sumServicesAction.modelEnviroment.getMessageResolver().resolveMessage("gui.tour.sumOverWeeK", new Serializable[0]) + "\n\n";
        }
        SumServicesAction sumServicesAction = this;
        message = message + sumServicesAction.modelEnviroment.getMessageResolver().resolveMessage("gui.tour.numberOfTours", Integer.valueOf(sumOfTours)) + "\n";
        SumServicesAction sumServicesAction2 = this;
        message = message + sumServicesAction2.modelEnviroment.getMessageResolver().resolveMessage("gui.tour.numberOfServices", Integer.valueOf(sumOfServices));
        JOptionPane.showMessageDialog(this.tourManagerCalendarGui, message);
    }
}

