/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.service;

import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.base.ServiceValueDescriptorModel;
import de.datomino.peppergis.client.model.base.StaticChoiceValueModel;
import de.datomino.peppergis.client.model.tour.ServiceTicketStopRelationModel;
import de.datomino.peppergis.client.model.tour.ServiceValueModel;
import de.datomino.peppergis.client.model.tour.ServiceValueModelImpl;
import de.datomino.peppergis.client.util.ServiceModelUtil;
import de.datomino.peppergis.type.AttributeValueType;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.ktde.util.cache.ChangeSet;

public class ServiceValueRollbackAction
extends AbstractAction {
    private static final long serialVersionUID = -8087496586903562904L;
    private JPanel serviceTicketPanel;
    private ServiceTicketStopRelationModel relationModel;
    private UndoManager undoManager;

    public ServiceValueRollbackAction(JPanel serviceTicketPanel, ServiceTicketStopRelationModel relationModel, UndoManager undoManager) {
        this.serviceTicketPanel = serviceTicketPanel;
        this.relationModel = relationModel;
        this.undoManager = undoManager;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.rollbackServiceValue();
    }

    private void rollbackServiceValue() {
        Iterator<ChangeSet> changeIterator = ChangeSet.currentChangeTransaction.get().iterator();
        ArrayList<ChangeSet> unRollbackList = new ArrayList<ChangeSet>();
        while (changeIterator.hasNext()) {
            ChangeSet changeSet = changeIterator.next();
            Object changeObject = changeSet.getObject();
            if (changeObject instanceof ServiceValueModelImpl) {
                ServiceTicketStopRelationModel serviceTicketStopRelation = ((ServiceValueModelImpl)changeObject).getServiceStopRelation();
                if (serviceTicketStopRelation == null || serviceTicketStopRelation.getTempUUID().equals(this.relationModel.getTempUUID())) continue;
                ChangeSet.currentChangeTransaction.removeContextObject(changeObject);
                unRollbackList.add(changeSet);
                continue;
            }
            ChangeSet.currentChangeTransaction.removeContextObject(changeObject);
            unRollbackList.add(changeSet);
        }
        this.undoManager.rollbackTransaction();
        this.undoManager.startTransaction();
        ChangeSet.currentChangeTransaction.remove();
        ChangeSet.currentChangeTransaction.set(unRollbackList);
        this.repaintServiceTicketPanel();
    }

    private void repaintServiceTicketPanel() {
        Iterator<ServiceValueDescriptorModel> serviceValueDescriptorIterator;
        try {
            serviceValueDescriptorIterator = this.relationModel.getServiceTicket().getService().iterateServiceValueDescriptors();
        }
        catch (NullPointerException e) {
            return;
        }
        int index = 1;
        while (serviceValueDescriptorIterator.hasNext()) {
            this.loadServiceValue(serviceValueDescriptorIterator.next(), index);
            ++index;
        }
    }

    private void loadServiceValue(ServiceValueDescriptorModel serviceValueDescriptorModel, int index) {
        int leftY = (index - 1) * 35 + 5;
        ServiceValueModel serviceValueModel = ServiceModelUtil.getServiceValueModel(this.relationModel, serviceValueDescriptorModel);
        if (serviceValueDescriptorModel.getServiceValueType() == AttributeValueType.BOOLEAN && serviceValueDescriptorModel.getEditable().booleanValue()) {
            this.updateServiceValueCheckBox(leftY, serviceValueModel);
        } else if (serviceValueDescriptorModel.getServiceValueType() == AttributeValueType.STATIC_CHOICE && serviceValueDescriptorModel.getEditable().booleanValue()) {
            this.updateServiceValueJomboBox(leftY, serviceValueModel);
        } else {
            this.updateServiceValueTextField(leftY, serviceValueModel);
        }
    }

    private void updateServiceValueJomboBox(int leftY, ServiceValueModel serviceValueModel) {
        JComboBox comboBox = (JComboBox)this.serviceTicketPanel.getComponentAt(205, leftY);
        if (serviceValueModel == null) {
            comboBox.setSelectedItem(null);
            return;
        }
        int sizeOfModel = comboBox.getItemCount();
        for (int i = 1; i < sizeOfModel; ++i) {
            StaticChoiceValueModel staticChoiceValue = (StaticChoiceValueModel)comboBox.getItemAt(i);
            if (!staticChoiceValue.getName().equals(serviceValueModel.getStaticChoiceValue().getName())) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
    }

    private void updateServiceValueCheckBox(int leftY, ServiceValueModel serviceValueModel) {
        boolean isSelected = false;
        if (serviceValueModel != null) {
            if (serviceValueModel.getBooleanValue().booleanValue()) {
                isSelected = true;
            }
        } else {
            return;
        }
        ((JRadioButton)this.serviceTicketPanel.getComponentAt(210, leftY)).setSelected(isSelected);
        ((JRadioButton)this.serviceTicketPanel.getComponentAt(270, leftY)).setSelected(!isSelected);
    }

    private void updateServiceValueTextField(int leftY, ServiceValueModel serviceValueModel) {
        String value = ServiceModelUtil.getServiceValue(serviceValueModel);
        ((JTextField)this.serviceTicketPanel.getComponentAt(205, leftY)).setText(value);
    }
}

