/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.routing.specialactions;

import de.datomino.logistic.type.CalculateType;
import de.datomino.logistic.type.OptimizationType;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.ServiceModel;
import de.datomino.peppergis.client.model.base.ServiceTicketModel;
import de.datomino.peppergis.client.model.base.ServiceValueDescriptorModel;
import de.datomino.peppergis.client.model.tour.ServiceTicketStopRelationModel;
import de.datomino.peppergis.client.model.tour.ServiceValueModel;
import de.datomino.peppergis.client.model.tour.ServiceValueModelImpl;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.tourmanager.handler.action.routing.specialactions.BeforeTourCalculationSpecialAction;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.io.CsvReader;

public class AnsbachBeforeTourCalculationSpecialAction
implements BeforeTourCalculationSpecialAction {
    private static final String UNLOADING_POINT_SERVICE_NUMBER = "STANDORT-01";
    private static final String DEFAULT_SERVICE_NUMBER = "AUSLIEFERUNG-01";
    private static final String UNLOADING_POINT_SERVICE_TOTAL_WEIGHT_KEY = "TOTAL_WEIGHT";
    private static final String UNLOADING_POINT_SERVICE_WEEKLY_PAPER_WEIGHT_KEY = "WEEKLY_PAPER_WEIGHT";
    private static final String UNLOADING_POINT_SERVICE_INFORMATION_KEY = "INFORMATION";
    private static final String DEFAULT_SERVICE_WEIGHT_KEY = "WEIGHT";
    private static final String DEFAULT_SERVICE_WEEKLY_PAPER_WEIGHT_KEY = "WEEKLY_PAPER_WEIGHT";

    @Override
    public void doSpecialAction(TourModel tour, ModelEnviroment modelEnviroment) {
        double totalWeight = 0.0;
        double weeklyPaperWeight = 0.0;
        LinkedList<String> informationParts = new LinkedList<String>();
        HashSet<ServiceTicketStopRelationModel> unloadingRels = new HashSet<ServiceTicketStopRelationModel>();
        for (TourPartModel tp : tour.iterableTourParts()) {
            for (StopModel stop : tp.iterableStops()) {
                for (ServiceTicketStopRelationModel rel : stop.iterableServiceStopRelations()) {
                    ServiceModel service;
                    ServiceTicketModel serviceTicket = rel.getServiceTicket();
                    if (serviceTicket == null || (service = serviceTicket.getService()) == null) continue;
                    switch (service.getServiceNumber()) {
                        case "STANDORT-01": {
                            unloadingRels.add(rel);
                            break;
                        }
                        case "AUSLIEFERUNG-01": {
                            Tripel<Double, Double, String> tripel = this.getValueTripel(rel);
                            totalWeight += tripel.getElement1().doubleValue();
                            weeklyPaperWeight += tripel.getElement2().doubleValue();
                            String information = tripel.getElement3();
                            if (StringUtil.isBlank(information)) break;
                            informationParts.add(information);
                        }
                    }
                }
            }
        }
        String newInformation = StringUtil.implode(informationParts, "\n");
        boolean transactionOpen = modelEnviroment.getUndoManager().isTransactionOpen();
        if (!transactionOpen) {
            modelEnviroment.getUndoManager().startTransaction();
        }
        for (ServiceTicketStopRelationModel rel : unloadingRels) {
            this.setValues(rel, totalWeight, weeklyPaperWeight, newInformation);
        }
        if (!transactionOpen) {
            modelEnviroment.getUndoManager().finishTransaction("");
        }
    }

    private void setValues(ServiceTicketStopRelationModel rel, double totalWeight, double weeklyPaperWeight, String newInformation) {
        ServiceValueDescriptorModel totalWeightDescriptor = null;
        ServiceValueDescriptorModel weeklyPaperWeightDescriptor = null;
        ServiceValueDescriptorModel informationDescriptor = null;
        for (ServiceValueDescriptorModel desc : rel.getServiceTicket().getService().iterableServiceValueDescriptors()) {
            switch (desc.getKey()) {
                case "TOTAL_WEIGHT": {
                    totalWeightDescriptor = desc;
                    break;
                }
                case "WEEKLY_PAPER_WEIGHT": {
                    weeklyPaperWeightDescriptor = desc;
                    break;
                }
                case "INFORMATION": {
                    informationDescriptor = desc;
                }
            }
        }
        if (totalWeightDescriptor == null || weeklyPaperWeightDescriptor == null || informationDescriptor == null) {
            throw new RuntimeException();
        }
        ServiceValueModel totalWeightValue = null;
        ServiceValueModel weeklyPaperWeightValue = null;
        ServiceValueModel informationValue = null;
        for (ServiceValueModel value : rel.iterableServiceValues()) {
            ServiceValueDescriptorModel serviceValueDescriptor = value.getServiceValueDescriptor();
            if (serviceValueDescriptor.equals(totalWeightDescriptor)) {
                totalWeightValue = value;
                continue;
            }
            if (serviceValueDescriptor.equals(weeklyPaperWeightDescriptor)) {
                weeklyPaperWeightValue = value;
                continue;
            }
            if (!serviceValueDescriptor.equals(informationDescriptor)) continue;
            informationValue = value;
        }
        if (totalWeightValue == null) {
            totalWeightValue = new ServiceValueModelImpl();
            totalWeightValue.setServiceStopRelation(rel);
            totalWeightValue.setServiceValueDescriptor(totalWeightDescriptor);
        }
        totalWeightValue.setFloatValue(totalWeight);
        if (weeklyPaperWeightValue == null) {
            weeklyPaperWeightValue = new ServiceValueModelImpl();
            weeklyPaperWeightValue.setServiceStopRelation(rel);
            weeklyPaperWeightValue.setServiceValueDescriptor(weeklyPaperWeightDescriptor);
        }
        weeklyPaperWeightValue.setFloatValue(weeklyPaperWeight);
        if (informationValue == null) {
            informationValue = new ServiceValueModelImpl();
            informationValue.setServiceStopRelation(rel);
            informationValue.setServiceValueDescriptor(informationDescriptor);
        }
        informationValue.setStringValue(newInformation);
        informationValue.setTextValue(newInformation);
    }

    private Tripel<Double, Double, String> getValueTripel(ServiceTicketStopRelationModel rel) {
        ServiceValueDescriptorModel weightDescriptor = null;
        ServiceValueDescriptorModel weeklyPaperWeightDescriptor = null;
        for (ServiceValueDescriptorModel desc : rel.getServiceTicket().getService().iterableServiceValueDescriptors()) {
            switch (desc.getKey()) {
                case "WEIGHT": {
                    weightDescriptor = desc;
                    break;
                }
                case "WEEKLY_PAPER_WEIGHT": {
                    weeklyPaperWeightDescriptor = desc;
                }
            }
        }
        if (weightDescriptor == null || weeklyPaperWeightDescriptor == null) {
            throw new RuntimeException();
        }
        double weight = 0.0;
        double weeklyPaperWeight = 0.0;
        for (ServiceValueModel serviceValueModel : rel.iterableServiceValues()) {
            Double value;
            ServiceValueDescriptorModel desc = serviceValueModel.getServiceValueDescriptor();
            if (weightDescriptor.equals(desc)) {
                value = serviceValueModel.getFloatValue();
                if (value == null) continue;
                weight += value.doubleValue();
                continue;
            }
            if (!weeklyPaperWeightDescriptor.equals(desc) || (value = serviceValueModel.getFloatValue()) == null) continue;
            weeklyPaperWeight += value.doubleValue();
        }
        return new Tripel<Double, Double, String>(weight, weeklyPaperWeight, rel.getStop().getDelivererInformation());
    }

    public static void main(String[] args) throws IOException {
        CsvReader csvReader = new CsvReader("/tmp/ansbach/import/ablade/tmp/10493_Tourenliste_02-11-2020.csv");
        csvReader.setDelim(Character.valueOf(';'));
        csvReader.readLine();
        List<String> csvLine = csvReader.readLine();
        int sum = 0;
        boolean count = false;
        while (csvLine != null) {
            String key = csvLine.get(1);
            if ("250".equals(key)) {
                String object = csvLine.get(22);
                int fullPackageCount = Integer.parseInt(csvLine.get(27));
                switch (object) {
                    case "FRZ": 
                    case "HB": {
                        sum += fullPackageCount;
                    }
                }
            }
            csvLine = csvReader.readLine();
        }
        System.out.println(sum);
        csvReader.close();
    }

    @Override
    public CalculateType modifyCalculateType(CalculateType calculateType) {
        switch (calculateType) {
            case BOTHWITHPOI: {
                return CalculateType.ENDWITHPOI;
            }
            case ENDWITHPOI: 
            case NONFIX: {
                return calculateType;
            }
            case STARTWITHPOI: {
                return CalculateType.NONFIX;
            }
        }
        return calculateType;
    }

    @Override
    public OptimizationType modifyOptimizationType(OptimizationType type) {
        switch (type) {
            case BOTHPOINTFIX: 
            case ENDPOINTFIX: 
            case ENDWITHPOI: 
            case NONFIX: 
            case STARTFIXENDWITHPOI: 
            case STARTPOINTFIX: {
                return type;
            }
            case BOTHWITHPOI: {
                return OptimizationType.ENDWITHPOI;
            }
            case STARTWITHPOI: {
                return OptimizationType.NONFIX;
            }
            case STARTWITHPOIENDFIX: {
                return OptimizationType.ENDPOINTFIX;
            }
            case ALLFIX: {
                return OptimizationType.STARTFIXENDWITHPOI;
            }
        }
        return type;
    }
}

