/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.routing;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.tourmanager.gui.ToursRoutingDialog;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.util.swing.blocking.BusyHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.AbstractAction;

public abstract class ToursRoutingAction
extends AbstractAction {
    private static final long serialVersionUID = 8555022333906678452L;
    private TourManagerCalendarGui tourManagerCalendarGui;
    private Component parent;
    private BusyHandler busyHandler;

    public ToursRoutingAction(TourManagerCalendarGui tourManagerCalendarGui, Component parent, BusyHandler busyHandler) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.update.allRoute", new Serializable[0]));
        this.tourManagerCalendarGui = tourManagerCalendarGui;
        this.parent = parent;
        this.busyHandler = busyHandler;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Collection<TourModel> tours = this.getTours();
        if (tours == null || tours.isEmpty()) {
            return;
        }
        UndoManager undoManager = this.tourManagerCalendarGui.getActions().getUndoManager();
        undoManager.joinTransaction();
        undoManager.startTransaction();
        ToursRoutingDialog dialog = new ToursRoutingDialog(this.tourManagerCalendarGui){
            private static final long serialVersionUID = -8540948701733519774L;

            @Override
            protected void repaintGui() {
                ToursRoutingAction.this.repaintGui();
            }

            @Override
            protected Collection<TourModel> getTours() {
                return ToursRoutingAction.this.getTours();
            }
        };
        dialog.setVisible(true);
        undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.message.afterRouting", Integer.valueOf(tours.size())));
        undoManager.startTransaction();
    }

    protected abstract Collection<TourModel> getTours();

    protected abstract void repaintGui();
}

