/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.routing;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.AbstractRoutingGui;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.tourmanager.gui.ToursRoutingDialog;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.gui.map.TourMapGui;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.swing.blocking.BusyHandler;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class TourRoutingActions {
    public AbstractRoutingGui<TourModel> tourRoutingGui;
    private BusyHandler busyHandler;
    private TourManagerCalendarGui tourManagerCalendarGui;
    private Action updateUnsortedLocationsAction;
    private Action routingAction;

    public TourRoutingActions(TourManagerCalendarGui tourManagerCalendarGui, AbstractRoutingGui<TourModel> abstractTourRoutingGui, BusyHandler busyHandler) {
        this.tourManagerCalendarGui = tourManagerCalendarGui;
        this.tourRoutingGui = abstractTourRoutingGui;
        this.busyHandler = busyHandler;
        this.initailize();
    }

    private void initailize() {
        this.updateUnsortedLocationsAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.update", new Serializable[0])){
            private static final long serialVersionUID = -236957804769537302L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TourRoutingActions.this.updateUnsortedStops();
            }
        };
        this.routingAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.process", new Serializable[0])){
            private static final long serialVersionUID = 1963122512380604143L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ToursRoutingDialog dialog = new ToursRoutingDialog(TourRoutingActions.this.tourManagerCalendarGui){
                    private static final long serialVersionUID = -6292170052992084774L;
                    private Collection<TourModel> selectedTours;
                    {
                        this.selectedTours = Collections.emptySet();
                    }

                    @Override
                    protected void repaintGui() {
                        TourRoutingActions.this.tourRoutingGui.repaintGui(true);
                        if (TourRoutingActions.this.tourRoutingGui instanceof TourMapGui) {
                            ((TourMapGui)TourRoutingActions.this.tourRoutingGui).getTourManagerCalendarGui().getTimeLineGui().refresh(this.selectedTours);
                        }
                    }

                    @Override
                    protected Collection<TourModel> getTours() {
                        this.selectedTours = CollectionUtil.buildHashSet(TourRoutingActions.this.tourRoutingGui.getSelectedModel());
                        return this.selectedTours;
                    }
                };
                dialog.setVisible(true);
            }
        };
    }

    public void updateUnsortedStops() {
        this.tourManagerCalendarGui.getNewUnsortedStops();
        this.tourRoutingGui.repaintGui(false);
    }

    public Action getUpdateUnsortedLocationsAction() {
        return this.updateUnsortedLocationsAction;
    }

    public Action getRoutingAction() {
        return this.routingAction;
    }

    @Deprecated
    public AreaAttributeValueDescriptorModel getPickPointStartDescriptor() {
        return null;
    }

    @Deprecated
    public AreaAttributeValueDescriptorModel getPickPointEndDescriptor() {
        return null;
    }
}

