/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.routing;

import de.datomino.logistic.dto.OptimizationAlgorithmType;
import de.datomino.logistic.type.OptimizationType;
import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.communication.tour.SimpleTourRoutingContext;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.tourmanager.handler.TourManagerActions;
import de.datomino.util.swing.list.ListDialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import org.apache.commons.io.FileUtils;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.io.CsvWriter;

public class TourOrigToOptimizedAction
extends AbstractAction {
    private static final long serialVersionUID = -1160230919344795694L;
    private ModelEnviroment modelEnviroment;
    private Window parent;

    public TourOrigToOptimizedAction(Window parent, ModelEnviroment modelEnviroment) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.origianlToOptimised", new Serializable[0]));
        this.modelEnviroment = modelEnviroment;
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ListDialog<TourModel> listDialog = new ListDialog<TourModel>(this.parent, ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.selectTour", new Serializable[0]), this.modelEnviroment.getAllCaller().getTourCaller().fetchAllTours()){
            private static final long serialVersionUID = -4155463368634128741L;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            protected void performOkAction() {
                TourOrigToOptimizedAction.this.modelEnviroment.getUndoManager().startTransaction();
                Object[] wrappers = this.getList().getSelectedValues();
                StringWriter sw = new StringWriter();
                CsvWriter csvWriter = new CsvWriter(sw);
                try {
                    for (Object o : wrappers) {
                        TourModel tourModel = (TourModel)((ListDialog.Wrapper)o).getT();
                        boolean failed = false;
                        try {
                            TourOrigToOptimizedAction.this.modelEnviroment.getAllCaller().getTourCaller().calculateTour(tourModel, RouteVehicleType.MOTORCAR, RouteType.FASTEST, true, TourOrigToOptimizedAction.this.modelEnviroment, OptimizationAlgorithmType.DEFAULT, true, SimpleTourRoutingContext.INSTANCE);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            failed = true;
                        }
                        ArrayList<String> row = new ArrayList<String>(5);
                        row.add(tourModel.getName());
                        row.add(failed ? "failed" : TourModelUtil.getDurationOfTourString(tourModel));
                        row.add(failed ? "failed" : TourModelUtil.getStreetMileageMetersString(tourModel));
                        try {
                            TourOrigToOptimizedAction.this.modelEnviroment.getAllCaller().getTourCaller().optimizeTour(tourModel, new Tripel<OptimizationType, Integer, Integer>(OptimizationType.BOTHPOINTFIX, 0, 0), RouteVehicleType.MOTORCAR, RouteType.FASTEST, true, true, TourOrigToOptimizedAction.this.modelEnviroment, TourManagerActions.tourOptimizer, TourOrigToOptimizedAction.this.parent, SimpleTourRoutingContext.INSTANCE);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            failed = true;
                        }
                        row.add(failed ? "failed" : TourModelUtil.getDurationOfTourString(tourModel));
                        row.add(failed ? "failed" : TourModelUtil.getStreetMileageMetersString(tourModel));
                        csvWriter.writeLine(row);
                    }
                    csvWriter.flush();
                    csvWriter.close();
                    this.dispose();
                    JFileChooser fileChooser = new JFileChooser();
                    int d = fileChooser.showSaveDialog(TourOrigToOptimizedAction.this.parent);
                    switch (d) {
                        case 0: {
                            File file = fileChooser.getSelectedFile();
                            FileUtils.writeStringToFile(file, sw.toString());
                            return;
                        }
                    }
                    return;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    TourOrigToOptimizedAction.this.modelEnviroment.getUndoManager().rollbackTransaction();
                }
            }

            @Override
            protected String getStringRepresentation(TourModel t) {
                return t.getName();
            }
        };
        listDialog.setVisible(true);
    }
}

