/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.routing;

import de.datomino.logistic.LogisticException;
import de.datomino.logistic.dto.OptimizationAlgorithmType;
import de.datomino.logistic.type.CalculateType;
import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.communication.tour.TourRoutingContext;
import de.datomino.peppergis.client.gui.ErrorMessagesDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.tour.TourDifficultyLevelModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.tour.BeforeClientTourCalculationSpecialActionType;
import de.datomino.peppergis.tourmanager.gui.AbstractRoutingWithComboBoxDialog;
import de.datomino.peppergis.tourmanager.handler.action.routing.OptimiseTourWithComboBoxAction;
import de.datomino.peppergis.tourmanager.handler.action.routing.specialactions.AnsbachBeforeTourCalculationSpecialAction;
import de.datomino.peppergis.tourmanager.handler.action.routing.specialactions.BeforeTourCalculationSpecialAction;
import de.datomino.peppergis.tourmanager.listener.TourPlanTableListener;
import de.datomino.util.swing.SwingUtils;
import de.datomino.util.swing.blocking.AbstractSwingWorkAction;
import de.datomino.util.time.TimeUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRoutingWithComboBoxAction<T>
extends AbstractSwingWorkAction<T, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OptimiseTourWithComboBoxAction.class);
    private static final long serialVersionUID = -6007482896321167979L;
    protected AbstractRoutingWithComboBoxDialog dialog;
    private String message;
    protected Component parent;
    protected boolean canceled = false;
    private Map<BeforeClientTourCalculationSpecialActionType, BeforeTourCalculationSpecialAction> specialActionMap;

    public AbstractRoutingWithComboBoxAction(String name, String message, AbstractRoutingWithComboBoxDialog dialog, Component parent) {
        super(name, SwingUtils.findWindowParent(parent));
        this.dialog = dialog;
        this.message = StringUtil.getNotNull(message);
        this.parent = parent;
        this.specialActionMap = new EnumMap<BeforeClientTourCalculationSpecialActionType, BeforeTourCalculationSpecialAction>(BeforeClientTourCalculationSpecialActionType.class);
        this.specialActionMap.put(BeforeClientTourCalculationSpecialActionType.ANSBACH, new AnsbachBeforeTourCalculationSpecialAction());
    }

    @Override
    protected String actionPerformedInternal(ActionEvent e, T t) {
        Container parentComponent = SwingUtils.findInternalFrameParent(this.dialog);
        if (parentComponent == null) {
            parentComponent = SwingUtils.findWindowParent(this.dialog.getParent());
        }
        this.dialog.dispose();
        if (this.dialog.getStartTime() != null) {
            Calendar clock = Calendar.getInstance();
            clock.setTime(this.dialog.getStartTime());
            for (TourModel tour : this.dialog.getTours()) {
                Date plannedStartTime = tour.getPlannedStartTime();
                plannedStartTime = TimeUtil.setTime(plannedStartTime, clock.get(11), clock.get(12), clock.get(13));
                tour.setPlannedStartTime(plannedStartTime);
                for (TourPartModel tp : tour.iterableTourParts()) {
                    tp.setDifficultyLevel(null);
                }
            }
        }
        String errorMsgs = this.executeRouting(this.dialog.getTours(), t);
        if (parentComponent != null) {
            parentComponent.repaint(10L);
        }
        if (this.canceled) {
            return null;
        }
        return errorMsgs;
    }

    @Override
    protected void doAfter(String v) {
        if (this.canceled) {
            return;
        }
        UndoManager undoManager = this.dialog.getModelEnviroment().getUndoManager();
        undoManager.startTransaction();
        v = this.adaptDifficultyLevel(v);
        if (v != null) {
            ErrorMessagesDialog.creatAndShow(v, this.parent);
        } else if (StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("tour.routing.optimisation.confirmAfter"))) {
            int size = this.dialog.getTours().size();
            StringBuilder sb = new StringBuilder(this.message + size);
            for (TourModel tour : this.dialog.getTours()) {
                sb.append("\n" + tour.getName());
            }
            int rows = size > 10 ? 10 : size + 1;
            JTextArea textArea = new JTextArea(sb.toString(), rows, 1);
            JOptionPane.showMessageDialog(this.parent, ClientSwingUtil.scrollTextArea(textArea, null, false));
        }
        undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.message.tourUpdate", new Serializable[]{""}));
    }

    protected String adaptDifficultyLevel(String errorMsgs) {
        TourCaller tourCaller = this.dialog.getModelEnviroment().getAllCaller().getTourCaller();
        Collection<TourDifficultyLevelModel> allDifficultyLevels = tourCaller.fetchAllTourDifficultyLevels();
        Collection<TourModel> tours = this.dialog.getTours();
        for (TourModel tour : tours) {
            boolean needCalculation = false;
            UndoManager undoManager = this.dialog.getModelEnviroment().getUndoManager();
            undoManager.startTransaction();
            int countStops = TourModelUtil.countStopsOfTour(tour);
            Integer distance = TourModelUtil.getStreetMileageMeters(tour);
            Double averageDistance = countStops == 0 || distance == null ? null : Double.valueOf(distance.doubleValue() / (double)countStops);
            TourDifficultyLevelModel difficultyLevel = this.findDifficultyLevel(averageDistance, allDifficultyLevels);
            Iterator<TourPartModel> iterator = tour.iterableTourParts().iterator();
            while (iterator.hasNext()) {
                TourPartModel tourPart;
                double oldValue;
                double newValue = difficultyLevel == null || difficultyLevel.getValue() == null ? Double.MIN_VALUE : difficultyLevel.getValue();
                if (newValue == (oldValue = (tourPart = iterator.next()).getDifficultyLevel() == null || tourPart.getDifficultyLevel().getValue() == null ? Double.MIN_VALUE : tourPart.getDifficultyLevel().getValue())) continue;
                tourPart.setDifficultyLevel(difficultyLevel);
                needCalculation = true;
            }
            if (!needCalculation) continue;
            try {
                ActionTourRoutingContext tourRoutingContext = new ActionTourRoutingContext(tours.size());
                tourCaller.calculateTour(tour, this.dialog.getRouteVehicleType(), this.dialog.getRouteType(), this.dialog.isSaved(), this.dialog.getModelEnviroment(), OptimizationAlgorithmType.DEFAULT, false, tourRoutingContext);
            }
            catch (LogisticException e) {
                String errorMsg = tour.getName() + " " + e.getLocalizedMessage();
                LOGGER.error(errorMsg);
                errorMsgs = errorMsgs == null ? errorMsg : errorMsgs + "/n" + errorMsg;
            }
        }
        return errorMsgs;
    }

    private TourDifficultyLevelModel findDifficultyLevel(Double averageDistance, Collection<TourDifficultyLevelModel> difficultyLevels) {
        TourDifficultyLevelModel defaultDifficultyLevel = null;
        TourDifficultyLevelModel difficultyLevel = null;
        if (averageDistance != null) {
            for (TourDifficultyLevelModel dl : difficultyLevels) {
                if (dl.getType() == null) continue;
                switch (dl.getType()) {
                    case AVERAGE_DISTANCE: {
                        double upperLimit;
                        double lowerLimit = dl.getLowerLimit() == null ? Double.MIN_VALUE : dl.getLowerLimit();
                        double d = upperLimit = dl.getUpperLimit() == null ? Double.MAX_VALUE : dl.getUpperLimit();
                        if (!(lowerLimit <= averageDistance) || !(upperLimit > averageDistance)) break;
                        difficultyLevel = dl;
                        break;
                    }
                    case DEFAULT: {
                        defaultDifficultyLevel = dl;
                    }
                }
            }
        }
        if (!this.dialog.withDifficultyLevel() || difficultyLevel == null) {
            difficultyLevel = defaultDifficultyLevel;
        }
        return difficultyLevel;
    }

    @Override
    protected JButton getCancelButton() {
        final JButton button = new JButton();
        button.setAction(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = 217827745319241642L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String title;
                String string = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.confirmCancel", new Serializable[0]);
                int d = JOptionPane.showConfirmDialog(AbstractRoutingWithComboBoxAction.this.parent, string, title = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0, 3);
                if (d == 0) {
                    AbstractRoutingWithComboBoxAction.this.canceled = true;
                    button.setEnabled(false);
                }
            }
        });
        return button;
    }

    public Component getParent() {
        return this.parent;
    }

    protected String executeRouting(Collection<TourModel> tours, T t) {
        String error;
        StringBuilder errorMessages = new StringBuilder();
        int i = 0;
        ActionTourRoutingContext tourRoutingContext = new ActionTourRoutingContext(tours.size());
        ArrayList<TourModel> tourList = new ArrayList<TourModel>(tours);
        TourPlanTableListener.prepareTours(tourList);
        for (TourModel tourModel : tourList) {
            this.doBeforeSpecialActions(tourModel);
            Tupel<String, Boolean> result = this.executeRouting(tourModel, tourRoutingContext, t, i);
            String msg = result.getElement1();
            if (!StringUtil.isBlank(msg)) {
                errorMessages.append(msg).append("\n");
            }
            if (!result.getElement2().booleanValue()) continue;
            break;
        }
        return StringUtil.isBlank(error = errorMessages.toString()) ? null : error;
    }

    protected void doBeforeSpecialActions(TourModel tourModel) {
        TourCaller tourCaller = this.dialog.getModelEnviroment().getAllCaller().getTourCaller();
        List<BeforeClientTourCalculationSpecialActionType> types = tourCaller.getBeforeTourCalculationSpecialActions();
        types.forEach(t -> {
            BeforeTourCalculationSpecialAction action = this.specialActionMap.get(t);
            action.doSpecialAction(tourModel, this.dialog.getModelEnviroment());
        });
    }

    protected abstract Tupel<String, Boolean> executeRouting(TourModel var1, TourRoutingContext var2, T var3, int var4);

    protected CalculateType getCalculateType() {
        TourCaller tourCaller = this.dialog.getModelEnviroment().getAllCaller().getTourCaller();
        List<BeforeClientTourCalculationSpecialActionType> types = tourCaller.getBeforeTourCalculationSpecialActions();
        CalculateType calculateType = this.dialog.getCalculateType();
        for (BeforeClientTourCalculationSpecialActionType type : types) {
            BeforeTourCalculationSpecialAction action = this.specialActionMap.get((Object)type);
            calculateType = action.modifyCalculateType(calculateType);
        }
        return calculateType;
    }

    protected List<BeforeTourCalculationSpecialAction> getBeforeTourCalculationSpecialActions() {
        TourCaller tourCaller = this.dialog.getModelEnviroment().getAllCaller().getTourCaller();
        List<BeforeClientTourCalculationSpecialActionType> types = tourCaller.getBeforeTourCalculationSpecialActions();
        ArrayList<BeforeTourCalculationSpecialAction> actions2 = new ArrayList<BeforeTourCalculationSpecialAction>(types.size());
        for (BeforeClientTourCalculationSpecialActionType type : types) {
            BeforeTourCalculationSpecialAction action = this.specialActionMap.get((Object)type);
            actions2.add(action);
        }
        return actions2;
    }

    private class ActionTourRoutingContext
    implements TourRoutingContext {
        private int totalCount;
        private AtomicBoolean lock = new AtomicBoolean(false);

        public ActionTourRoutingContext(int totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public synchronized void requestAdaption() {
            this.gainLock();
            ModelEnviroment modelEnviroment = AbstractRoutingWithComboBoxAction.this.dialog.getModelEnviroment();
            UndoManager undoManager = modelEnviroment.getUndoManager();
            undoManager.startTransaction();
        }

        @Override
        public synchronized void rollbackAdaption() {
            ModelEnviroment modelEnviroment = AbstractRoutingWithComboBoxAction.this.dialog.getModelEnviroment();
            UndoManager undoManager = modelEnviroment.getUndoManager();
            undoManager.rollbackTransaction();
            this.unlock();
        }

        @Override
        public synchronized void finishAdaption() {
            ModelEnviroment modelEnviroment = AbstractRoutingWithComboBoxAction.this.dialog.getModelEnviroment();
            UndoManager undoManager = modelEnviroment.getUndoManager();
            undoManager.finishTransaction("");
            undoManager.startTransaction();
            this.unlock();
        }

        @Override
        public boolean isCanceled() {
            return AbstractRoutingWithComboBoxAction.this.canceled;
        }

        private void gainLock() {
            while (this.lock.get()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.lock.set(true);
        }

        private void unlock() {
            this.lock.set(false);
        }

        @Override
        public int getTotalCount() {
            return this.totalCount;
        }
    }
}

