/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.printer;

import de.datomino.pdf.printer.InfoPrintPosition;
import de.datomino.pdf.printer.PrinterInformation;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.filter.AllObjectFilterLayerRenderer;
import de.datomino.peppergis.client.manager.printer.AbstractManagerPrintAction;
import de.datomino.peppergis.client.manager.printer.ManagerPrintOptionPane;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.print.LegendNamePrintType;
import de.datomino.peppergis.print.PrintProperties;
import de.datomino.peppergis.print.PrintPropertyKey;
import de.datomino.peppergis.tourmanager.gui.map.TourMapGui;
import de.datomino.peppergis.tourmanager.print.TourManagerPrinter;
import de.datomino.peppergis.tourmanager.print.TourManagerPrinterImpl;
import de.datomino.peppergis.type.PrintParameterKey;
import de.datomino.util.message.error.ErrorMessage;
import de.datomino.util.message.error.ErrorMessages;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.util.datatypes.Tupel;

public class PrintLegendAction
extends AbstractManagerPrintAction<TourModel> {
    private static final long serialVersionUID = -1073067664729255816L;
    private boolean withPoi;
    private ManagerPrintOptionPane printOptionPane;

    public PrintLegendAction(TourMapGui tourMapGui, String title, boolean withPoi) {
        super(title, AbstractManagerPrintAction.PrintActionName.LEGEND, new TourManagerPrinterImpl(tourMapGui), tourMapGui);
        this.withPoi = withPoi;
        if (withPoi) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(114, 128));
        } else {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(115, 128));
        }
    }

    @Override
    protected Tupel<Collection<Tupel<String, InputStream>>, ErrorMessages> print() throws Exception {
        TourManagerPrinter tourPrinter = (TourManagerPrinter)this.managerPrinter;
        ErrorMessage errorMessage = null;
        InputStream inputStream = null;
        boolean isExist = false;
        for (NavigatorRenderer renderer : this.mapGui.getNavigatorPanel().getRenderers()) {
            AllObjectFilterLayerRenderer allObjectFilterLayerRenderer;
            if (!(renderer instanceof AllObjectFilterLayerRenderer) || !renderer.isActive() || (allObjectFilterLayerRenderer = (AllObjectFilterLayerRenderer)renderer).getOrderedObjects().isEmpty()) continue;
            isExist = true;
            break;
        }
        if (isExist) {
            ListModel listModel = ((TourMapGui)this.mapGui).getFilterLegendList().getModel();
            LinkedList list = new LinkedList();
            for (int i = 0; i < listModel.getSize(); ++i) {
                list.add(listModel.getElementAt(i));
            }
            if (this.printOptionPane == null) {
                this.printOptionPane = super.createPrintOptionPane(true, true, false);
            }
            PrinterInformation printerInformation = super.getPrintingInformation(this.printOptionPane);
            printerInformation.setWithPoi(this.withPoi);
            if (printerInformation != null && printerInformation.getPrintType() != null && (inputStream = tourPrinter.printLegend(this.mapGui.getNavigatorPanel(), Collections.singletonList(list), this.mapGui.getCurrentFilter().getType(), printerInformation, null)) == null) {
                errorMessage = new ErrorMessage(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.error.createpdf", new Serializable[0]));
            }
        } else {
            errorMessage = new ErrorMessage(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.message.nodeliveryroute", new Serializable[0]));
        }
        return new Tupel<Collection<Tupel<String, InputStream>>, ErrorMessages>(Collections.singletonList(new Tupel<String, Object>("", inputStream)), errorMessage == null ? new ErrorMessages() : new ErrorMessages(errorMessage));
    }

    @Override
    protected Tupel<InfoPrintPosition, String> getTypeTupel() {
        PrintProperties printProperties = this.mapGui.getModelEnviroment().getPrintProperties();
        Map<PrintPropertyKey, Serializable> properties = printProperties.getAreaTourProperties();
        LegendNamePrintType legendNamePrintType = (LegendNamePrintType)((Object)properties.get(PrintParameterKey.INFO_POSITION));
        String legendNameRenderingType = (String)((Object)properties.get(PrintParameterKey.INFO_PATTERN));
        return new Tupel<InfoPrintPosition, String>(legendNamePrintType, legendNameRenderingType);
    }

    @Override
    protected String[] getButtonItems() {
        return new String[]{ModelEnviroment.getMessageResolver().resolveMessage("buttons.ok", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("buttons.cancel", new Serializable[0])};
    }

    @Override
    protected PrinterInformation.PrintType getPrintType(int select) {
        switch (select) {
            case 0: {
                return PrinterInformation.PrintType.LEGEND;
            }
        }
        return null;
    }

    @Override
    protected String getPropertyPrefix() {
        return "tour";
    }
}

