/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler.action.filter;

import de.datomino.peppergis.client.communication.tour.StopFilterEntity;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.util.FilterEntity;
import de.datomino.peppergis.tourmanager.gui.filter.UnsortedStopFilterSettingDialog;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.gui.map.TourMapGui;
import de.datomino.util.time.TimeUtil;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class UnsortedStopFilterSettingActions {
    private UnsortedStopFilterSettingDialog filterSettingDialog;
    private StopFilterEntity stopFilterEntity;
    private Action applyFilterActions;
    private Action storeFilterAction;
    private Action deleteFilterAction;

    public UnsortedStopFilterSettingActions(UnsortedStopFilterSettingDialog filterSettingDialog, StopFilterEntity filterEntity) {
        this.filterSettingDialog = filterSettingDialog;
        this.stopFilterEntity = filterEntity;
        this.initialized();
    }

    private void initialized() {
        this.applyFilterActions = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.common.apply", new Serializable[0])){
            private static final long serialVersionUID = 713388733378610012L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UnsortedStopFilterSettingActions.this.applyFilter();
            }
        };
        this.storeFilterAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.save", new Serializable[0])){
            private static final long serialVersionUID = 3815933491692414618L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UnsortedStopFilterSettingActions.this.storeFilter();
            }
        };
        this.deleteFilterAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.common.cancel", new Serializable[0])){
            private static final long serialVersionUID = -1424261999874349580L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UnsortedStopFilterSettingActions.this.deleteFilter();
            }
        };
    }

    public void applyFilter() {
        boolean result = this.storeFilter();
        if (result) {
            TourManagerCalendarGui tourManagerCalendarGui = this.filterSettingDialog.getTourManagerCalendarGui();
            TourMapGui tourMapGui = tourManagerCalendarGui.getTourMapGui();
            tourManagerCalendarGui.getTabbedPane().setSelectedComponent(tourMapGui);
            tourMapGui.applyStopFilterOnMap(this.stopFilterEntity);
        }
    }

    public boolean storeFilter() {
        if (!this.isFilterExists()) {
            this.stopFilterEntity.setKey(this.filterSettingDialog.getNameField().getText());
            Date endTime = this.stopFilterEntity.getEndTime();
            this.stopFilterEntity.setEndTime(endTime == null ? null : TimeUtil.setTime(endTime, 23, 59, 59));
            this.filterSettingDialog.getTourManagerCalendarGui().getFilters().add(this.stopFilterEntity);
        }
        this.updateFilterMenu();
        return true;
    }

    public void deleteFilter() {
        if (this.isFilterExists()) {
            this.filterSettingDialog.getTourManagerCalendarGui().getFilters().remove(this.stopFilterEntity);
        }
        this.updateFilterMenu();
    }

    private boolean isFilterExists() {
        boolean isExists = false;
        for (FilterEntity filter : this.filterSettingDialog.getTourManagerCalendarGui().getFilters()) {
            if (!filter.getKey().equals(this.stopFilterEntity.getKey())) continue;
            isExists = true;
        }
        return isExists;
    }

    private void updateFilterMenu() {
        this.filterSettingDialog.dispose();
        this.filterSettingDialog.getTourManagerCalendarGui().getControlGui().loadFilterSubMenu();
    }

    public Action getApplyFilterActions() {
        return this.applyFilterActions;
    }

    public Action getStoreFilterAction() {
        return this.storeFilterAction;
    }

    public Action getDeleteFilterAction() {
        return this.deleteFilterAction;
    }
}

