/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler;

import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import java.text.ParseException;
import java.util.List;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TourManagerJobManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TourManagerJobManager.class);
    private static SchedulerFactory FACTORY = new StdSchedulerFactory();
    private static String JOB_GROUP_NAME = "TOURMANAGER_JOBS";
    private static String TRIGGER_GROUP_NAME = "TOURMANAGER _TRIGGERS";

    public static void addJob(String jobName, String clazz, String cron, TourManagerCalendarGui parent) {
        TourManagerJobManager.addJob(jobName, JOB_GROUP_NAME, TRIGGER_GROUP_NAME, clazz, cron, parent);
    }

    public static void addJob(String jobName, String jobGroup, String triggerGroup, String clazz, String cron, TourManagerCalendarGui parent) {
        try {
            JobDetail jobDetail = new JobDetail(jobName, jobGroup, Class.forName(clazz));
            jobDetail.getJobDataMap().put((Object)"parent", parent);
            CronTrigger trigger = new CronTrigger(jobName, triggerGroup);
            trigger.setCronExpression(cron);
            FACTORY.getScheduler().scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            LOGGER.error("invalid cron expression");
        }
    }

    public static void modifyJobTime(String jobName, String cron) {
        TourManagerJobManager.modifyJobTime(jobName, TRIGGER_GROUP_NAME, cron);
    }

    public static void modifyJobTime(String jobName, String triggerGroup, String cron) {
        try {
            Scheduler scheduler = FACTORY.getScheduler();
            CronTrigger trigger = (CronTrigger)scheduler.getTrigger(jobName, triggerGroup);
            if (trigger != null && !trigger.getCronExpression().equalsIgnoreCase(cron)) {
                trigger.setCronExpression(cron);
                scheduler.rescheduleJob(trigger.getName(), trigger.getGroup(), trigger);
            }
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static void removeJob(String jobName) {
        TourManagerJobManager.removeJob(jobName, JOB_GROUP_NAME, TRIGGER_GROUP_NAME);
    }

    public static void removeJob(String jobName, String jobGroup, String triggerGroup) {
        try {
            Scheduler scheduler = FACTORY.getScheduler();
            scheduler.pauseTrigger(jobName, triggerGroup);
            scheduler.unscheduleJob(jobName, triggerGroup);
            scheduler.deleteJob(jobName, jobGroup);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    public static void start() {
        try {
            FACTORY.getScheduler().start();
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    public static void pauseAll() {
        try {
            FACTORY.getScheduler().pauseAll();
            LOGGER.info("all jobs are paused.");
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    public static void pause(String jobName) {
        try {
            FACTORY.getScheduler().pauseJob(jobName, JOB_GROUP_NAME);
            LOGGER.info("job " + jobName + " is paused.");
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    public static void resumeAll() {
        try {
            FACTORY.getScheduler().resumeJobGroup(JOB_GROUP_NAME);
            LOGGER.info(JOB_GROUP_NAME + " are resumed.");
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    public static void resumeJob(String jobName) {
        try {
            FACTORY.getScheduler().resumeJob(jobName, JOB_GROUP_NAME);
            LOGGER.info("job " + jobName + " is resumed.");
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    public static void shutdown() {
        try {
            FACTORY.getScheduler().shutdown(true);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    public static boolean isJobRunning(String jobName) {
        try {
            List currentJobs = FACTORY.getScheduler().getCurrentlyExecutingJobs();
            for (JobExecutionContext jobCtx : currentJobs) {
                String thisJobName = jobCtx.getJobDetail().getKey().getName();
                String thisGroupName = jobCtx.getJobDetail().getKey().getGroup();
                if (!jobName.equalsIgnoreCase(thisJobName) || !JOB_GROUP_NAME.equalsIgnoreCase(thisGroupName)) continue;
                return true;
            }
        }
        catch (SchedulerException e) {
            LOGGER.error("", e);
            return false;
        }
        return false;
    }
}

