/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.handler;

import de.datomino.logistic.dto.OptimizationAlgorithmType;
import de.datomino.peppergis.client.communication.AreaCaller;
import de.datomino.peppergis.client.communication.StreetNetCaller;
import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.location.SearchLocationAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.DelivererDialog;
import de.datomino.peppergis.client.manager.DelivererTreeGui;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.UndoManagerEvent;
import de.datomino.peppergis.client.model.UndoManagerListener;
import de.datomino.peppergis.client.model.tour.StopModelImpl;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.dto.exporter.TourExportType;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.gui.stop.AddAndUpdateStopDialog;
import de.datomino.peppergis.tourmanager.gui.tour.AddTourDialog;
import de.datomino.peppergis.tourmanager.gui.tour.TourDifficultyLevelConfigurationDialog;
import de.datomino.peppergis.tourmanager.gui.tour.TourListGui;
import de.datomino.peppergis.tourmanager.gui.tour.TourPlanTableGui;
import de.datomino.peppergis.tourmanager.gui.tour.event.TourSelectionEvent;
import de.datomino.peppergis.tourmanager.gui.tour.event.TourSelectionListener;
import de.datomino.peppergis.tourmanager.handler.action.exporter.ExportAreaTourAction;
import de.datomino.peppergis.tourmanager.handler.action.exporter.ExportSelectedToursInMapToServerAction;
import de.datomino.peppergis.tourmanager.handler.action.exporter.ExportTourAction;
import de.datomino.peppergis.tourmanager.handler.action.exporter.ExportTourToServerAction;
import de.datomino.peppergis.tourmanager.handler.action.service.SumServicesAction;
import de.datomino.peppergis.tourmanager.handler.action.stop.SearchStopsAction;
import de.datomino.peppergis.type.UserRole;
import de.datomino.util.swing.SwingUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.ktde.util.NameGenerator;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class TourManagerActions {
    private TourManagerCalendarGui tourManagerCalendarGui;
    private TourCaller tourCaller;
    private AreaCaller areaCaller;
    private StreetNetCaller streetNetCaller;
    private UndoManager undoManager;
    private Action newTourAction;
    private Action newStopAction;
    private Action newDelivererAction;
    private Action exportDefaultTourAction;
    private Action exportOverviewTourAction;
    private Action exportTourToServerAction;
    private Action exportSelectedToursInMapToServerAction;
    private Action sumServicesAction;
    private Action exportAreaTourAction;
    private Action deleteToursInTabAction;
    public static OptimizationAlgorithmType tourOptimizer;
    public static OptimizationAlgorithmType sideTourOptimizer;

    public TourManagerActions(TourManagerCalendarGui tourManagerCalendarGui, ModelEnviroment modelEnviroment) {
        this.tourManagerCalendarGui = tourManagerCalendarGui;
        this.initialize(modelEnviroment);
    }

    private void initialize(ModelEnviroment modelEnviroment) {
        this.undoManager = modelEnviroment.getUndoManager();
        this.undoManager.addUndoManagerListener(new UndoManagerListener(){

            @Override
            public void undone(UndoManagerEvent event) {
                TourManagerActions.this.repaint();
            }

            @Override
            public void redone(UndoManagerEvent event) {
                TourManagerActions.this.repaint();
            }
        });
        this.tourCaller = modelEnviroment.getAllCaller().getTourCaller();
        this.areaCaller = modelEnviroment.getAllCaller().getAreaCaller();
        this.streetNetCaller = modelEnviroment.getAllCaller().getStreetNetCaller();
        this.newTourAction = new AbstractAction("Tour hinzuf\u00fcgen"){
            private static final long serialVersionUID = -4513443914901868448L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TourManagerActions.this.createNewTourDialog();
            }
        };
        this.newTourAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, 512));
        this.newStopAction = new AbstractAction("Stopp hinzuf\u00fcgen"){
            private static final long serialVersionUID = -6819369203783657586L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TourManagerActions.this.createNewStopDialog();
            }
        };
        this.newStopAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 512));
        this.newDelivererAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.add", new Serializable[0])){
            private static final long serialVersionUID = 7599594958844539563L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TourManagerActions.this.addNewDeliverer();
            }
        };
        this.newDelivererAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(68, 512));
        this.deleteToursInTabAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.tour.delete", new Serializable[0])){
            private static final long serialVersionUID = -3030236480263496334L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TourManagerCalendarGui gui = TourManagerActions.this.tourManagerCalendarGui;
                Set<TourModel> selectedTours = gui.getPlanTableGui().getSelectedToursInTable().keySet();
                Collection<Tupel<Integer, Integer>> selectedPositions = gui.getPlanTableGui().getSelectedToursInTable().values();
                if (TourManagerActions.this.removeTours(selectedTours) != 2) {
                    for (Tupel<Integer, Integer> position : selectedPositions) {
                        gui.getPlanTableGui().getPlanTableModel().setValueAt(null, position.getElement1(), position.getElement2());
                    }
                    gui.getPlanTableGui().clearSelectedTours();
                }
            }
        };
        this.exportDefaultTourAction = new ExportTourAction(this.tourManagerCalendarGui, modelEnviroment, ModelEnviroment.getMessageResolver().resolveMessage("messages.exporter.exportLocal", new Serializable[0]), TourExportType.DEFAULT);
        this.exportOverviewTourAction = new ExportTourAction(this.tourManagerCalendarGui, modelEnviroment, ModelEnviroment.getMessageResolver().resolveMessage("messages.tour.export.overview", new Serializable[0]), TourExportType.OVERVIEW);
        this.exportTourToServerAction = new ExportTourToServerAction(this.tourManagerCalendarGui, modelEnviroment);
        this.exportSelectedToursInMapToServerAction = new ExportSelectedToursInMapToServerAction(this.tourManagerCalendarGui, modelEnviroment);
        this.exportAreaTourAction = new ExportAreaTourAction(SwingUtils.findWindowParent(this.tourManagerCalendarGui), modelEnviroment);
        this.sumServicesAction = new SumServicesAction(this.tourManagerCalendarGui, modelEnviroment);
        String optimizer = ModelEnviroment.getProperties().getProperty("tour.optimizer");
        tourOptimizer = StringUtil.isBlank(optimizer) ? OptimizationAlgorithmType.DEFAULT : OptimizationAlgorithmType.valueOf(optimizer);
        String sideOptimizer = ModelEnviroment.getProperties().getProperty("tour.optimizer.side");
        OptimizationAlgorithmType optimizationAlgorithmType = sideTourOptimizer = StringUtil.isBlank(sideOptimizer) ? OptimizationAlgorithmType.DEFAULT_STREET_SIDE : OptimizationAlgorithmType.valueOf(sideOptimizer);
        if (sideTourOptimizer == null) {
            sideTourOptimizer = OptimizationAlgorithmType.DEFAULT_STREET_SIDE;
        }
    }

    protected void addNewDeliverer() {
        this.undoManager.startTransaction();
        new DelivererDialog(SwingUtils.findWindowParent(this.tourManagerCalendarGui), this.tourManagerCalendarGui.getModelEnviroment(), ModelEnviroment.getUserInformation().isAdmin() || ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.DISPONENT_SUPER)){
            private static final long serialVersionUID = -8980304385705457995L;

            @Override
            protected void doAfterOk() {
                super.doAfterOk();
                TourManagerActions.this.tourManagerCalendarGui.getDelivererGui().addNewDeliverer(this.getDelivererModel());
                TourManagerActions.this.tourManagerCalendarGui.getPlanTableGui().addNullRow();
            }
        };
    }

    protected void createNewStopDialog() {
        this.undoManager.startTransaction();
        AddAndUpdateStopDialog addStopDialog = new AddAndUpdateStopDialog(this.tourManagerCalendarGui.getModelEnviroment(), true, null);
        StopModelImpl newStop = new StopModelImpl();
        addStopDialog.showDialog(newStop, true, (Component)this.tourManagerCalendarGui);
        if (newStop.getName() == null) {
            this.undoManager.rollbackTransaction();
            return;
        }
        this.tourManagerCalendarGui.getUnsortedStops().add(newStop);
        this.undoManager.finishTransaction("Ein neuer Stopp " + newStop.getName() + " wird hinzugef\u00fcgt.");
    }

    protected void createNewTourDialog() {
        this.undoManager.startTransaction();
        AddTourDialog addTourDialog = new AddTourDialog(this.tourManagerCalendarGui);
        TourModel newTour = addTourDialog.showDialog();
        if (newTour == null) {
            this.undoManager.rollbackTransaction();
            return;
        }
        this.tourManagerCalendarGui.getTourListGui().addNewTour(newTour);
        this.undoManager.finishTransaction("Ein neue Tour " + newTour.getName() + " wird hinzugef\u00fcgt.");
    }

    public int removeTours(Collection<TourModel> tours) {
        String implodeTours = StringUtil.implode(tours, ", ", new NameGenerator<TourModel>(){

            @Override
            public String getName(TourModel arg0) {
                return arg0.getName();
            }
        });
        int choice = JOptionPane.showConfirmDialog(this.tourManagerCalendarGui, ModelEnviroment.getMessageResolver().resolveMessage("messages.tour.removeTourAndStops", new Serializable[]{implodeTours}), ModelEnviroment.getMessageResolver().resolveMessage("messages.tour.removeTour", new Serializable[0]), 1);
        if (choice != 2) {
            boolean complete = choice == 0;
            this.undoManager.startTransaction();
            for (TourModel tour : tours) {
                this.tourManagerCalendarGui.getTourListGui().remove(tour);
                this.tourManagerCalendarGui.getTourListGui().getTourListModel().removeElementWithId(tour.getTempUUID());
                TourModelUtil.deleteTourComplete(tour, complete);
            }
            this.undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("messages.tour.deleted", new Serializable[]{implodeTours}));
            this.tourManagerCalendarGui.getTourListGui().getTourJList().repaint(10L);
        }
        return choice;
    }

    private TourListGui getTourGui() {
        return this.tourManagerCalendarGui.getTourListGui();
    }

    private TourPlanTableGui getPlanTableGui() {
        return this.tourManagerCalendarGui.getPlanTableGui();
    }

    private DelivererTreeGui getDelivererGui() {
        return this.tourManagerCalendarGui.getDelivererGui();
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public Action getUndoAction() {
        return this.getUndoManager().getUndoAction();
    }

    public Action getRedoAction() {
        return this.getUndoManager().getRedoAction();
    }

    public Action getSaveAction() {
        return this.getUndoManager().getSaveAction();
    }

    public Action getRevertAction() {
        return this.getUndoManager().getRevertAction();
    }

    public TourCaller getTourCaller() {
        return this.tourCaller;
    }

    public Action getNewTourAction() {
        return this.newTourAction;
    }

    public Action getNewStopAction() {
        return this.newStopAction;
    }

    public Action getNewDelivererAction() {
        return this.newDelivererAction;
    }

    public void repaint() {
        this.getTourGui().createTourList();
        this.getPlanTableGui().createPlanTable();
        this.getDelivererGui().createDelivererTree(this.tourManagerCalendarGui.getCalendarGui().getCurrentDate());
        this.tourManagerCalendarGui.getTourMapGui().repaintGui(false);
        this.tourManagerCalendarGui.getTimeLineGui().repaintGui(false, null);
    }

    public AreaCaller getAreaCaller() {
        return this.areaCaller;
    }

    public Action[] getExportTourActions() {
        return new Action[]{this.exportDefaultTourAction, this.exportOverviewTourAction};
    }

    public Action getExportTourToServerAction() {
        return this.exportTourToServerAction;
    }

    public Action getExportSelectedToursInMapToServerAction() {
        return this.exportSelectedToursInMapToServerAction;
    }

    public Action getExportAreaTourAction() {
        return this.exportAreaTourAction;
    }

    public Action getDeleteToursInTabAction() {
        return this.deleteToursInTabAction;
    }

    public void initializeListeners() {
        this.tourManagerCalendarGui.getPlanTableGui().addTourSelectionListener(new TourSelectionListener(){

            @Override
            public void selectionChanged(TourSelectionEvent e) {
                boolean selected = !e.getNewSelection().isEmpty();
                TourManagerActions.this.exportDefaultTourAction.setEnabled(selected);
                TourManagerActions.this.exportOverviewTourAction.setEnabled(selected);
                TourManagerActions.this.exportTourToServerAction.setEnabled(selected);
                TourManagerActions.this.deleteToursInTabAction.setEnabled(selected);
            }
        });
        boolean selected = !this.tourManagerCalendarGui.getPlanTableGui().getSelectedToursInTable().isEmpty();
        this.exportDefaultTourAction.setEnabled(selected);
        this.exportOverviewTourAction.setEnabled(selected);
        this.exportTourToServerAction.setEnabled(selected);
        this.deleteToursInTabAction.setEnabled(selected);
    }

    public StreetNetCaller getStreetNetCaller() {
        return this.streetNetCaller;
    }

    public Action getSumServicesAction() {
        return this.sumServicesAction;
    }

    public Action getSearchStopsAction(SearchLocationAction searchLocationAction) {
        return new SearchStopsAction(this.tourManagerCalendarGui.getModelEnviroment(), this.tourManagerCalendarGui, ModelEnviroment.getMessageResolver().resolveMessage("messages.search.stop", new Serializable[0]));
    }

    public Action getEditDifficultyLevelAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.difficultyLevel.config", new Serializable[0])){
            private static final long serialVersionUID = -740024345358717419L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TourManagerCalendarGui gui = TourManagerActions.this.tourManagerCalendarGui;
                ModelEnviroment modelEnviroment = gui.getModelEnviroment();
                modelEnviroment.getUndoManager().startTransaction();
                new TourDifficultyLevelConfigurationDialog(gui, modelEnviroment);
            }
        };
    }
}

