/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.tracking;

import de.datomino.peppergis.client.gui.AbstractListCellRenderer;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.tourmanager.gui.map.TourMapGui;
import de.datomino.peppergis.tourmanager.gui.tracking.GeoTrackingLegendPane;
import de.datomino.peppergis.tourmanager.gui.tracking.GeoTrackingRenderer;
import de.datomino.peppergis.type.GeoTrackingType;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import org.ktde.swing.ToggleAction;

public class GeoTrackSettingPane
extends JPanel {
    private static final long serialVersionUID = -2216056730029236531L;
    private GeoTrackingRenderer geoTrackingRenderer;
    private JCheckBox gps;
    private JCheckBox network;
    private JComboBox trackInterval;
    private JComboBox updateInterval;
    private TourMapGui tourMapGui;

    public GeoTrackSettingPane(GeoTrackingRenderer geoTrackingRenderer, TourMapGui tourMapGui) {
        super(new SpringLayout());
        this.tourMapGui = tourMapGui;
        this.geoTrackingRenderer = geoTrackingRenderer;
        this.buildLayout();
    }

    private void buildLayout() {
        this.add(this.createParameterPanel());
        this.add(this.createButtonPanel());
        SpringUtilities.makeCompactGrid(this, 2, 1, 5, 5, 2, 2);
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton startButton = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("buttons.show", new Serializable[0])){
            private static final long serialVersionUID = 3870120811418464773L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GeoTrackSettingPane.this.loadTracks();
                GeoTrackSettingPane.this.doClosing();
            }
        });
        buttonPanel.add(startButton);
        JButton cancelButton = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = -1771428183804160567L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GeoTrackSettingPane.this.doClosing();
            }
        });
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }

    private JPanel createParameterPanel() {
        JPanel parameterPanel = new JPanel(new SpringLayout());
        parameterPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.type", new Serializable[0])));
        JPanel subPanel = new JPanel(new SpringLayout());
        this.gps = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.gps", new Serializable[0]));
        this.gps.setSelected(true);
        subPanel.add(this.gps);
        this.network = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.mobilenetwork", new Serializable[0]));
        this.gps.setSelected(true);
        subPanel.add(this.network);
        SpringUtilities.makeCompactGrid(subPanel, 2, 1, 2, 2, 2, 2);
        parameterPanel.add(subPanel);
        parameterPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.tour.geotracking.interval", new Serializable[0])));
        this.trackInterval = new JComboBox<Double>(new Double[]{0.5, 1.0, 2.5, 5.0, 7.5, 10.0, 15.0});
        this.trackInterval.setSelectedItem(5.0);
        this.trackInterval.setRenderer(new AbstractListCellRenderer<Double>(){

            @Override
            protected String getStringFromValue(Double object) {
                return ClientFormUtil.getNumberString(object);
            }
        });
        parameterPanel.add(this.trackInterval);
        parameterPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.tour.geotracking.update", new Serializable[0])));
        this.updateInterval = new JComboBox<Integer>(new Integer[]{1, 5, 10, 15});
        this.updateInterval.setSelectedItem(15);
        parameterPanel.add(this.updateInterval);
        SpringUtilities.makeCompactGrid(parameterPanel, 3, 2, 5, 5, 5, 5);
        return parameterPanel;
    }

    private void loadTracks() {
        boolean gpsSelected = this.gps.isSelected();
        boolean networkSelected = this.network.isSelected();
        HashSet<GeoTrackingType> geoTrackingTypes = new HashSet<GeoTrackingType>();
        if (gpsSelected) {
            geoTrackingTypes.add(GeoTrackingType.GPS);
        }
        if (networkSelected) {
            geoTrackingTypes.add(GeoTrackingType.NETWORK);
        }
        Double interval = (Double)this.trackInterval.getSelectedItem();
        long milliInterval = (long)(interval * 60.0 * 1000.0);
        GeoTrackingLegendPane tourTrackingLegendPane = this.tourMapGui.getGeoTrackingLegendPane();
        tourTrackingLegendPane.setValues(geoTrackingTypes, milliInterval, (Integer)this.updateInterval.getSelectedItem());
        this.geoTrackingRenderer.setValues(tourTrackingLegendPane.getTrackingMap());
        JCheckBoxMenuItem trackingDisplayItem = this.tourMapGui.getTourManagerCalendarGui().getControlGui().getTrackingDisplayItem();
        trackingDisplayItem.setSelected(true);
        if (trackingDisplayItem.getAction() instanceof ToggleAction) {
            ((ToggleAction)trackingDisplayItem.getAction()).setSelected(true);
        }
    }

    private void doClosing() {
        Window window = SwingUtils.findWindowParent(this);
        if (window != null) {
            window.setVisible(false);
        }
    }
}

