/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.tour;

import de.datomino.logistic.dto.TourPartType;
import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.AbstractListCellRenderer;
import de.datomino.peppergis.client.gui.CompletableJTextField;
import de.datomino.peppergis.client.gui.common.AbstractCommonDialog;
import de.datomino.peppergis.client.gui.common.TimeDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourModelImpl;
import de.datomino.peppergis.client.model.tour.TourPartModelImpl;
import de.datomino.peppergis.client.util.DelivererModelUtil;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.NumericUtil;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.ktde.util.datatypes.Tupel;

public class TourSplitDialog
extends AbstractCommonDialog {
    private static final long serialVersionUID = -8760080051428325765L;
    private TourModel tour;
    private List<StopModel> forSplit;
    private String newTourName;
    private JRadioButton tillEnd;
    private JRadioButton onlySelection;
    private JCheckBox duplicateCheckBox;
    private JFormattedTextField tourTimeField;
    private CompletableJTextField<DelivererModel> delivererField;
    private TourManagerCalendarGui managerGui;

    public TourSplitDialog(TourModel tour, Collection<StopModel> stops, TourManagerCalendarGui managerGui) {
        super(managerGui.getModelEnviroment(), managerGui, ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.split", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.managerGui = managerGui;
        this.tour = tour;
        this.forSplit = new ArrayList<StopModel>(stops);
        Collections.sort(this.forSplit, new Comparator<StopModel>(){

            @Override
            public int compare(StopModel o1, StopModel o2) {
                return Integer.compare(NumericUtil.getIntegerValue(o1.getSortOrder()), NumericUtil.getIntegerValue(o2.getSortOrder()));
            }
        });
        TourCaller tourCaller = super.getModelEnviroment().getAllCaller().getTourCaller();
        this.newTourName = tourCaller.generateTourName(tour.getName().length() + 3, tour.getName(), 0);
    }

    @Override
    protected Component getMainComponent() {
        Box north = Box.createVerticalBox();
        this.tillEnd = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.split.tillEnd", new Serializable[0]));
        north.add(this.tillEnd);
        this.onlySelection = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.split.slection", new Serializable[0]));
        north.add(this.onlySelection);
        ButtonGroup bg = new ButtonGroup();
        this.onlySelection.setSelected(true);
        bg.add(this.tillEnd);
        bg.add(this.onlySelection);
        final JPanel center = new JPanel(new SpringLayout());
        center.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.name", new Serializable[0])));
        JTextField name = new JTextField(this.newTourName);
        name.setEnabled(false);
        center.add(name);
        center.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.deliverer", new Serializable[0])));
        this.delivererField = new CompletableJTextField<DelivererModel>(new AbstractListCellRenderer<DelivererModel>(){

            @Override
            protected String getStringFromValue(DelivererModel object) {
                return DelivererModelUtil.getDisplayString(object);
            }
        }, this);
        TourCaller tourCaller = super.getModelEnviroment().getAllCaller().getTourCaller();
        this.delivererField.getDataList().addAll(tourCaller.fetchAllDeliverers());
        center.add(this.delivererField);
        center.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.date", new Serializable[0])));
        this.tourTimeField = new JFormattedTextField(new SimpleDateFormat(FormUtil.TIMEFORMAT));
        this.tourTimeField.setEnabled(false);
        this.tourTimeField.setValue(this.tour.getPlannedStartTime());
        center.add(this.tourTimeField);
        center.add(new JLabel(""));
        JPanel inputTimePane = new JPanel(new FlowLayout());
        final JButton inputTimeButton = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.specifyDate", new Serializable[0])){
            private static final long serialVersionUID = -3629099373641449095L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Tupel<Date, Boolean> newTimeTupel = TimeDialog.createAndShow((Date)TourSplitDialog.this.tourTimeField.getValue(), center);
                if (newTimeTupel.getElement2().booleanValue()) {
                    TourSplitDialog.this.tourTimeField.setValue(newTimeTupel.getElement1());
                    TourSplitDialog.this.tourTimeField.repaint(10L);
                }
            }
        });
        inputTimePane.add(inputTimeButton);
        center.add(inputTimePane);
        center.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.splitting.stopZeit", new Serializable[0])));
        final JCheckBox splittingZeitCheckBox = new JCheckBox();
        splittingZeitCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (splittingZeitCheckBox.isSelected()) {
                    inputTimeButton.setEnabled(false);
                    StopModel first = (StopModel)TourSplitDialog.this.forSplit.get(0);
                    if (first.getEstimatedTimeOfArrival() != null) {
                        TourSplitDialog.this.tourTimeField.setValue(first.getEstimatedTimeOfArrival());
                    }
                } else {
                    inputTimeButton.setEnabled(true);
                }
            }
        });
        center.add(splittingZeitCheckBox);
        center.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.splitting.duplicate", new Serializable[0])));
        this.duplicateCheckBox = new JCheckBox();
        center.add(this.duplicateCheckBox);
        SpringUtilities.makeCompactGrid(center, 6, 2, 5, 5, 5, 5);
        JPanel main = new JPanel(new BorderLayout());
        main.add((Component)north, "North");
        main.add((Component)center, "Center");
        return main;
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(this.getOkActionName()){
            private static final long serialVersionUID = 4753099193275092139L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TourSplitDialog.this.close()) {
                    TourSplitDialog.this.dispose();
                }
            }
        };
    }

    @Override
    protected boolean close() {
        if (this.tillEnd.isSelected()) {
            boolean b = false;
            for (StopModel stop : TourModelUtil.getAllStops(this.tour, true)) {
                if (this.forSplit.get(this.forSplit.size() - 1).equals(stop)) {
                    b = true;
                    continue;
                }
                if (!b || this.forSplit.contains(stop)) continue;
                this.forSplit.add(stop);
            }
        }
        Collections.sort(this.forSplit, new Comparator<StopModel>(){

            @Override
            public int compare(StopModel o1, StopModel o2) {
                return Integer.compare(NumericUtil.getIntegerValue(o1.getSortOrder()), NumericUtil.getIntegerValue(o2.getSortOrder()));
            }
        });
        TourModelImpl newTour = new TourModelImpl();
        newTour.setName(this.newTourName);
        newTour.setPlannedStartTime((Date)this.tourTimeField.getValue());
        newTour.setDeliverer(this.delivererField.getSelectedObject());
        int partIndex = 1;
        if (this.duplicateCheckBox.isSelected()) {
            StopModel first = StopModelUtil.cloneStop(this.forSplit.remove(0));
            TourPartModelImpl firstPart = new TourPartModelImpl();
            firstPart.setName(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.part", new Serializable[0]) + " " + partIndex++);
            firstPart.setTour(newTour);
            firstPart.setTourPartType(TourPartType.NO_LINK);
            firstPart.addStop(first);
        }
        TourPartModelImpl mainPart = new TourPartModelImpl();
        mainPart.setName(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.part", new Serializable[0]) + " " + partIndex++);
        mainPart.setTour(newTour);
        mainPart.setTourPartType(TourPartType.LINK_PRED);
        for (StopModel stop : this.forSplit) {
            mainPart.addStop(stop);
        }
        UndoManager undoManager = super.getModelEnviroment().getUndoManager();
        undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.newTour", new Serializable[0]) + " - " + this.newTourName);
        undoManager.startTransaction();
        this.managerGui.getTourListGui().addNewTour(newTour);
        this.managerGui.getPlanTableGui().createPlanTable();
        return true;
    }
}

