/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.tour;

import de.datomino.peppergis.client.gui.ErrorMessagesDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.branch.BranchModelUtil;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TourDifficultyLevelModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.DelivererModelUtil;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.tourmanager.gui.tour.TourSettingDialog;
import de.datomino.peppergis.tourmanager.handler.action.tour.TourSettingActions;
import de.datomino.peppergis.tourmanager.listener.tour.PointComboBoxListener;
import de.datomino.peppergis.tourmanager.listener.tour.TourDateSpinnerListener;
import de.datomino.peppergis.type.UserRole;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.WidthUnifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SpringLayout;
import javax.swing.UIManager;

public class TourSettingPanel
extends JPanel {
    private static final long serialVersionUID = 4610920791747943871L;
    private TourSettingDialog tourSettingDialog;
    private final TourModel tour;
    private TourSettingActions tourSettingActions;
    private Box lastValuesBox;
    private Box currentValuesBox;
    private JSpinner plannedStartTimeSpinner;
    private JSpinner plannedEndTimeSpinner;
    private JFormattedTextField kilometerStart;
    private JFormattedTextField kilometerEnd;
    private JComboBox startPointComboBox;
    private JComboBox endPointComboBox;

    public TourSettingPanel(TourSettingDialog tourSettingDialog, TourModel tour) {
        super(new GridLayout(1, 3));
        this.tourSettingDialog = tourSettingDialog;
        this.tour = tour;
        this.initialize();
    }

    private void initialize() {
        this.tourSettingActions = new TourSettingActions(this.tourSettingDialog);
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.createSettingPanel(), "North");
        this.add(leftPanel);
        JPanel middleTopPanel = new JPanel(new BorderLayout());
        middleTopPanel.add((Component)this.createDelivererPanel(), "North");
        JPanel middleBottomPanel = new JPanel(new BorderLayout());
        middleBottomPanel.add((Component)this.createKilometerPanel(), "North");
        JPanel middlePanel = new JPanel(new GridLayout(2, 1));
        middlePanel.add(ClientSwingUtil.createPanelForComponent(middleTopPanel, ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.informationDeli", new Serializable[0])));
        middlePanel.add(ClientSwingUtil.createPanelForComponent(middleBottomPanel, ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.informationWagon", new Serializable[0])));
        this.add(middlePanel);
        JPanel rightTopPanel = this.createLastMessagePanel();
        JPanel rightBottomPaenl = this.createCurrentMessagePanel();
        JPanel rightPanel = new JPanel(new GridLayout(2, 1));
        rightPanel.add(ClientSwingUtil.createPanelForComponent(rightTopPanel, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.lastValues", new Serializable[0])));
        rightPanel.add(ClientSwingUtil.createPanelForComponent(rightBottomPaenl, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.currentValues", new Serializable[0])));
        this.add(rightPanel);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setAutoscrolls(true);
    }

    private JPanel createKilometerPanel() {
        JPanel kilometerPanel = new JPanel(new BorderLayout());
        JPanel sKilometerPanel = new JPanel(new GridLayout(3, 1));
        JPanel statusPanel = new JPanel(new GridLayout(2, 2));
        JLabel startLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.tour.kilometerStart", new Serializable[0]));
        statusPanel.add(startLabel);
        JLabel endLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.tour.kilometerEnd", new Serializable[0]));
        statusPanel.add(endLabel);
        this.kilometerStart = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.kilometerStart.setEditable(false);
        this.kilometerStart.setValue(this.tour.getKilometerStart());
        statusPanel.add(this.kilometerStart);
        this.kilometerEnd = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.kilometerEnd.setEditable(false);
        this.kilometerEnd.setValue(this.tour.getKilometerEnd());
        statusPanel.add(this.kilometerEnd);
        sKilometerPanel.add(statusPanel);
        JPanel kmPanel = new JPanel(new GridLayout(2, 1));
        kmPanel.add(new JLabel("Tats\u00e4chlich gefahrene KM"));
        JFormattedTextField km = new JFormattedTextField(NumberFormat.getIntegerInstance());
        km.setEditable(false);
        km.setValue(this.getActualKm());
        kmPanel.add(km);
        sKilometerPanel.add(kmPanel);
        kilometerPanel.add((Component)sKilometerPanel, "Center");
        return kilometerPanel;
    }

    private int getActualKm() {
        int start = this.tour.getKilometerStart() == null ? 0 : this.tour.getKilometerStart();
        int end = this.tour.getKilometerStart() == null ? 0 : this.tour.getKilometerEnd();
        return end - start;
    }

    private JPanel createCurrentMessagePanel() {
        JPanel currentMessagePanel = new JPanel(new BorderLayout());
        this.currentValuesBox = Box.createVerticalBox();
        TourModelUtil.loadInfoBox(this.currentValuesBox, this.tour);
        currentMessagePanel.add((Component)this.currentValuesBox, "Center");
        return currentMessagePanel;
    }

    private JPanel createLastMessagePanel() {
        JPanel lastMessagePanel = new JPanel(new BorderLayout());
        this.lastValuesBox = Box.createVerticalBox();
        TourModelUtil.loadInfoBox(this.lastValuesBox, this.tour);
        lastMessagePanel.add((Component)this.lastValuesBox, "Center");
        return lastMessagePanel;
    }

    private JPanel createVehiclePanel() {
        JPanel vehiclePanel = new JPanel(new GridLayout(6, 1));
        JLabel vehicleLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0]) + ": ");
        vehiclePanel.add(vehicleLabel);
        JTextField vehicleField = new JTextField("");
        vehicleField.setEditable(false);
        vehiclePanel.add(vehicleField);
        JLabel licensePlateLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.mark", new Serializable[0]) + ": ");
        vehiclePanel.add(licensePlateLabel);
        JTextField licensePlateField = new JTextField("");
        licensePlateField.setEditable(false);
        vehiclePanel.add(licensePlateField);
        JLabel mileageLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.mileage", new Serializable[0]) + ": ");
        vehiclePanel.add(mileageLabel);
        JTextField mileageField = new JTextField("");
        mileageField.setEditable(false);
        vehiclePanel.add(mileageField);
        if (this.tour.getVehicle() != null) {
            vehicleField.setText(FormUtil.getStringDisplay(this.tour.getVehicle().getName()));
            licensePlateField.setText(FormUtil.getStringDisplay(this.tour.getVehicle().getLicensePlate()));
            mileageField.setText(ClientFormUtil.getDistanceDisplay(this.tour.getVehicle().getMileageKilometers(), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.km", new Serializable[0])));
        }
        return vehiclePanel;
    }

    private JPanel createDelivererPanel() {
        JPanel delivererPanel = new JPanel(new SpringLayout());
        WidthUnifier widthUnifier = new WidthUnifier();
        JLabel delivererLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.number", new Serializable[0]) + ": ");
        widthUnifier.add(delivererLabel);
        delivererPanel.add(delivererLabel);
        JLabel delivererNameLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0]) + ": ");
        widthUnifier.add(delivererNameLabel);
        delivererPanel.add(delivererNameLabel);
        JTextField delivererField = new JTextField("");
        widthUnifier.add(delivererField);
        delivererField.setEditable(false);
        delivererPanel.add(delivererField);
        JTextField delivererNameField = new JTextField("");
        widthUnifier.add(delivererNameField);
        delivererNameField.setEditable(false);
        delivererPanel.add(delivererNameField);
        JLabel delivererBranchLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.group", new Serializable[0]) + ": ");
        widthUnifier.add(delivererBranchLabel);
        delivererPanel.add(delivererBranchLabel);
        JLabel delivererDifficultLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.humanFactor", new Serializable[0]) + ": ");
        widthUnifier.add(delivererDifficultLabel);
        delivererPanel.add(delivererDifficultLabel);
        JTextField delivererBranchField = new JTextField("");
        widthUnifier.add(delivererBranchField);
        delivererBranchField.setEditable(false);
        delivererPanel.add(delivererBranchField);
        JTextField factorField = new JTextField("");
        widthUnifier.add(factorField);
        factorField.setEditable(false);
        delivererPanel.add(factorField);
        widthUnifier.unifyWidth();
        if (this.tour.getDeliverer() != null) {
            delivererField.setText(FormUtil.getStringDisplay(this.tour.getDeliverer().getDelivererNumber()));
            delivererNameField.setText(FormUtil.getStringDisplay(this.tour.getDeliverer().getName()));
            delivererBranchField.setText(BranchModelUtil.getString(this.tour.getDeliverer().getBranch()));
            Double currentFactor = DelivererModelUtil.getCurrentFactor(this.tour.getDeliverer());
            String factorText = currentFactor == null ? "" : currentFactor.toString();
            factorField.setText(factorText);
        }
        SpringUtilities.makeCompactGrid(delivererPanel, 4, 2, 5, 5, 2, 2);
        return delivererPanel;
    }

    private JPanel createSettingPanel() {
        JPanel settingPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        JLabel nameLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.name", new Serializable[0]) + ": ");
        nameLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        settingPanel.add((Component)nameLabel, c);
        JTextField nameField = new JTextField("");
        nameField.setEditable(false);
        nameField.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        c.gridy = 1;
        settingPanel.add((Component)nameField, c);
        JLabel infoLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]) + ": ");
        infoLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        c.gridy = 2;
        settingPanel.add((Component)infoLabel, c);
        JTextArea infoArea = new JTextArea("");
        infoArea.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        c.gridy = 3;
        settingPanel.add((Component)ClientSwingUtil.scrollTextArea(infoArea, null, false), c);
        JPanel mobilPanel = new JPanel(new GridLayout(2, 3));
        JLabel mobileActiveLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.mobile.active", new Serializable[0]) + ": ");
        mobileActiveLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 5, 5));
        mobilPanel.add(mobileActiveLabel);
        ButtonGroup mobileActiveButtonGroup = new ButtonGroup();
        final JRadioButton mobileActiveTrueButton = new JRadioButton(this.tourSettingActions.getMobileActiveTrueAction());
        mobileActiveTrueButton.setFont(UIManager.getDefaults().getFont("TextField.font"));
        mobilPanel.add(mobileActiveTrueButton);
        mobileActiveButtonGroup.add(mobileActiveTrueButton);
        JRadioButton mobileActiveFalseButton = new JRadioButton(this.tourSettingActions.getMobileActiveFalseAction());
        mobileActiveFalseButton.setFont(UIManager.getDefaults().getFont("TextField.font"));
        mobileActiveFalseButton.setSelected(true);
        mobilPanel.add(mobileActiveFalseButton);
        mobileActiveButtonGroup.add(mobileActiveFalseButton);
        JLabel mobileAlreadySyncedLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.mobile.sync", new Serializable[0]) + ": ");
        mobilPanel.add(mobileAlreadySyncedLabel);
        ButtonGroup mobileAlreadySyncedButtonGroup = new ButtonGroup();
        final JRadioButton mobileAlreadySyncedTrueButton = new JRadioButton(this.tourSettingActions.getMobileAlreadySyncedTrueAction());
        mobileAlreadySyncedTrueButton.setFont(UIManager.getDefaults().getFont("TextField.font"));
        mobileAlreadySyncedTrueButton.setEnabled(false);
        mobilPanel.add(mobileAlreadySyncedTrueButton);
        mobileAlreadySyncedButtonGroup.add(mobileAlreadySyncedTrueButton);
        JRadioButton mobileAlreadySyncedFalseButton = new JRadioButton(this.tourSettingActions.getMobileAlreadySyncedFalseAction());
        mobileAlreadySyncedFalseButton.setFont(UIManager.getDefaults().getFont("TextField.font"));
        mobileAlreadySyncedFalseButton.setEnabled(false);
        mobileAlreadySyncedFalseButton.setSelected(true);
        mobilPanel.add(mobileAlreadySyncedFalseButton);
        mobileAlreadySyncedButtonGroup.add(mobileAlreadySyncedFalseButton);
        c.gridy = 5;
        c.gridheight = 2;
        settingPanel.add((Component)mobilPanel, c);
        JPanel timePanel = new JPanel(new GridLayout(4, 2));
        JLabel plannedStartTimeLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.plannedStartTime", new Serializable[0]) + ": ");
        plannedStartTimeLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        timePanel.add(plannedStartTimeLabel);
        JLabel plannedEndTimeLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.plannedEndTime", new Serializable[0]) + ": ");
        timePanel.add(plannedEndTimeLabel);
        this.plannedStartTimeSpinner = new JSpinner(new SpinnerDateModel());
        JSpinner.DateEditor timeEditor1 = new JSpinner.DateEditor(this.plannedStartTimeSpinner, FormUtil.TIMEFORMAT);
        this.plannedStartTimeSpinner.setEditor(timeEditor1);
        this.plannedStartTimeSpinner.setFocusable(false);
        timePanel.add(this.plannedStartTimeSpinner);
        JFormattedTextField plannedStartTimeField = ((JSpinner.DefaultEditor)this.plannedStartTimeSpinner.getEditor()).getTextField();
        plannedStartTimeField.setHorizontalAlignment(2);
        plannedStartTimeField.setEditable(false);
        this.plannedEndTimeSpinner = new JSpinner(new SpinnerDateModel());
        JSpinner.DateEditor timeEditorPlannedEnd = new JSpinner.DateEditor(this.plannedEndTimeSpinner, FormUtil.TIMEFORMAT);
        this.plannedEndTimeSpinner.setEditor(timeEditorPlannedEnd);
        this.plannedEndTimeSpinner.setFocusable(false);
        timePanel.add(this.plannedEndTimeSpinner);
        JFormattedTextField plannedEndTimeField = ((JSpinner.DefaultEditor)this.plannedEndTimeSpinner.getEditor()).getTextField();
        plannedEndTimeField.setHorizontalAlignment(2);
        plannedEndTimeField.setEditable(false);
        JLabel actualStartTimeLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.actualStartTime", new Serializable[0]) + ": ");
        timePanel.add(actualStartTimeLabel);
        JLabel actualEndTimeLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.actualEndTime", new Serializable[0]) + ": ");
        timePanel.add(actualEndTimeLabel);
        JSpinner actualStartTimeSpinner = new JSpinner(new SpinnerDateModel());
        JSpinner.DateEditor timeEditor2 = new JSpinner.DateEditor(actualStartTimeSpinner, FormUtil.TIMEFORMAT);
        actualStartTimeSpinner.setEditor(timeEditor2);
        actualStartTimeSpinner.setFocusable(false);
        timePanel.add(actualStartTimeSpinner);
        JFormattedTextField actualStartTimeField = ((JSpinner.DefaultEditor)actualStartTimeSpinner.getEditor()).getTextField();
        actualStartTimeField.setHorizontalAlignment(2);
        actualStartTimeField.setEditable(false);
        JSpinner actualEndTimeSpinner = new JSpinner(new SpinnerDateModel());
        JSpinner.DateEditor timeEditorActualEnd = new JSpinner.DateEditor(actualEndTimeSpinner, FormUtil.TIMEFORMAT);
        actualEndTimeSpinner.setEditor(timeEditorActualEnd);
        actualEndTimeSpinner.setFocusable(false);
        timePanel.add(actualEndTimeSpinner);
        JFormattedTextField actualEndTimeField = ((JSpinner.DefaultEditor)actualEndTimeSpinner.getEditor()).getTextField();
        actualEndTimeField.setHorizontalAlignment(2);
        actualEndTimeField.setEditable(false);
        c.gridy = 7;
        c.gridheight = 4;
        settingPanel.add((Component)timePanel, c);
        JLabel startPointLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.start", new Serializable[0]) + ": ");
        startPointLabel.setBorder(BorderFactory.createEmptyBorder(15, 0, 5, 5));
        c.gridy = 11;
        c.gridheight = 1;
        settingPanel.add((Component)startPointLabel, c);
        this.startPointComboBox = new JComboBox<String>(TourModelUtil.OPTIMISESTARTITEMS);
        this.startPointComboBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
        this.startPointComboBox.setActionCommand("startpoint");
        this.startPointComboBox.setFont(UIManager.getDefaults().getFont("TextField.font"));
        this.startPointComboBox.setSelectedIndex(-1);
        c.gridy = 12;
        settingPanel.add((Component)this.startPointComboBox, c);
        JLabel endPointLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.end", new Serializable[0]) + ": ");
        endPointLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        c.gridy = 13;
        settingPanel.add((Component)endPointLabel, c);
        this.endPointComboBox = new JComboBox<String>(TourModelUtil.OPTIMISEENDITEMS);
        this.endPointComboBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
        this.endPointComboBox.setActionCommand("endpoint");
        this.endPointComboBox.setFont(UIManager.getDefaults().getFont("TextField.font"));
        this.endPointComboBox.setSelectedIndex(-1);
        c.gridy = 14;
        settingPanel.add((Component)this.endPointComboBox, c);
        TourDifficultyLevelModel dl = null;
        if (this.tour.countTourParts() > 0) {
            TourPartModel firstPart = this.tour.iterateTourParts().next();
            dl = firstPart.getDifficultyLevel();
        }
        String dlText = ModelEnviroment.getMessageResolver().resolveMessage("area.attribute.descriptor.difficultyLevel", new Serializable[0]) + ": ";
        dlText = dlText + (dl == null ? "" : ModelEnviroment.getMessageResolver().resolveMessageForEnum(dl.getType()));
        JLabel dlLabel = new JLabel(dlText);
        dlLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        c.gridy = 15;
        settingPanel.add((Component)dlLabel, c);
        JPanel dlPanel = new JPanel(new GridLayout(1, 3));
        JTextField lowerLimitField = new JTextField(dl == null ? "" : ClientFormUtil.getNumberString(dl.getLowerLimit()));
        lowerLimitField.setPreferredSize(new Dimension(20, 25));
        lowerLimitField.setEditable(false);
        dlPanel.add(lowerLimitField);
        JTextField upperLimitField = new JTextField(dl == null ? "" : ClientFormUtil.getNumberString(dl.getUpperLimit()));
        upperLimitField.setEditable(false);
        dlPanel.add(upperLimitField);
        JTextField dlField = new JTextField(dl == null ? "" : ClientFormUtil.getNumberString(dl.getValue()));
        dlField.setEditable(false);
        dlPanel.add(dlField);
        c.gridy = 16;
        settingPanel.add((Component)dlPanel, c);
        nameField.setText(this.tour.getName());
        infoArea.setText(FormUtil.getStringDisplay(this.tour.getInformation()));
        if (this.tour.getMobileActive() != null && this.tour.getMobileActive().booleanValue()) {
            mobileActiveTrueButton.setSelected(true);
        }
        if (this.tour.getMobileAlreadySynced() != null && this.tour.getMobileAlreadySynced().booleanValue()) {
            mobileAlreadySyncedTrueButton.setSelected(true);
        }
        if (this.tour.getPlannedStartTime() != null) {
            this.plannedStartTimeSpinner.setValue(this.tour.getPlannedStartTime());
        } else {
            plannedStartTimeField.setText("");
        }
        Date plannedEndTime = TourModelUtil.getPlannedEndTime(this.tour);
        if (plannedEndTime != null) {
            this.plannedEndTimeSpinner.setValue(plannedEndTime);
        } else {
            plannedEndTimeField.setText("");
        }
        if (this.tour.getActualStartTime() != null) {
            actualStartTimeSpinner.setValue(this.tour.getActualStartTime());
        } else {
            actualStartTimeField.setText("");
        }
        Date actualEndTime = this.tour.getActualEndTime();
        if (actualEndTime != null) {
            actualEndTimeSpinner.setValue(actualEndTime);
        } else {
            actualEndTimeField.setText("");
        }
        if (ModelEnviroment.getUserInformation().hasUserRoleForTour(this.tour, UserRole.DELIVERER_ACTIVE, UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.DISPONENT_SUPER, UserRole.ADMIN)) {
            TourDateSpinnerListener tourDateSpinnerListener = new TourDateSpinnerListener(this.tourSettingDialog, plannedStartTimeField, this.tour, 2);
            PointComboBoxListener pointComboBoxListener = new PointComboBoxListener(this.tour, this.tourSettingDialog);
            mobileActiveTrueButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TourSettingPanel.this.tour.setMobileActive(true);
                }
            });
            mobileActiveFalseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (mobileAlreadySyncedTrueButton.isSelected()) {
                        mobileActiveTrueButton.setSelected(true);
                    } else {
                        TourSettingPanel.this.tour.setMobileActive(false);
                    }
                }
            });
        } else {
            infoArea.setEditable(false);
            ClientSwingUtil.setSpinnerEnable(this.plannedStartTimeSpinner, false);
            this.startPointComboBox.setEnabled(false);
            this.endPointComboBox.setEnabled(false);
            mobileActiveTrueButton.setEnabled(false);
            mobileActiveFalseButton.setEnabled(false);
        }
        ClientSwingUtil.setSpinnerEnable(this.plannedEndTimeSpinner, false);
        ClientSwingUtil.setSpinnerEnable(actualStartTimeSpinner, false);
        ClientSwingUtil.setSpinnerEnable(actualEndTimeSpinner, false);
        return settingPanel;
    }

    public TourModel getTour() {
        return this.tour;
    }

    public void updateTourSettingPanel() {
        Date plannedEndTime;
        Component[] currentComponents = this.currentValuesBox.getComponents();
        int index = 0;
        for (Component currentComponent : currentComponents) {
            JLabel currentLabel = (JLabel)currentComponent;
            JLabel lastLabel = (JLabel)this.lastValuesBox.getComponent(index);
            lastLabel.setText(currentLabel.getText());
            ++index;
        }
        this.updateCurrentInfoBox(currentComponents, this.tour);
        Date plannedStartTime = this.tour.getPlannedStartTime();
        if (plannedStartTime != null) {
            this.plannedStartTimeSpinner.setValue(plannedStartTime);
        }
        if ((plannedEndTime = TourModelUtil.getPlannedEndTime(this.tour)) != null) {
            this.plannedEndTimeSpinner.setValue(plannedEndTime);
        }
    }

    private void updateCurrentInfoBox(Component[] components, TourModel tour) {
        if (components.length < 5) {
            new ErrorMessagesDialog("error at the info box", this);
            return;
        }
        ((JLabel)components[0]).setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.numberOfTourparts", Integer.valueOf(tour.countTourParts())));
        ((JLabel)components[1]).setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.numberOfStops", Integer.valueOf(TourModelUtil.countStopsOfTour(tour))));
        ((JLabel)components[2]).setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.length", new Serializable[]{TourModelUtil.getStreetMileageMetersString(tour)}));
        ((JLabel)components[3]).setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.duration", new Serializable[]{TourModelUtil.getDurationOfTourString(tour)}));
        ((JLabel)components[4]).setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.numberOfServices", Integer.valueOf(TourModelUtil.countServicesOfTour(tour))));
    }

    public boolean needCalculation() {
        int selected;
        boolean b;
        Date newTime = (Date)this.plannedStartTimeSpinner.getValue();
        boolean bl = b = newTime != null && (this.tour.getPlannedStartTime() == null || !newTime.equals(this.tour.getPlannedStartTime()));
        if (!b) {
            StopModel firstStop = TourModelUtil.getFirstStop(this.tour, Collections.emptySet(), false);
            selected = this.startPointComboBox.getSelectedIndex();
            if (firstStop != null && selected != -1) {
                switch (selected) {
                    case 0: 
                    case 1: {
                        if (firstStop.getPoi() == null) break;
                        b = true;
                        break;
                    }
                    case 2: {
                        if (firstStop.getPoi() != null) break;
                        b = true;
                        break;
                    }
                }
            }
        }
        if (!b) {
            StopModel lastStop = TourModelUtil.getLastStop(this.tour, false);
            selected = this.endPointComboBox.getSelectedIndex();
            if (lastStop != null && selected != -1) {
                switch (selected) {
                    case 0: 
                    case 1: {
                        if (lastStop.getPoi() == null) break;
                        b = true;
                        break;
                    }
                    case 2: {
                        if (lastStop.getPoi() != null) break;
                        b = true;
                        break;
                    }
                }
            }
        }
        if (b) {
            this.tour.setPlannedStartTime(newTime);
        }
        return b;
    }
}

