/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.tour;

import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.Pausable;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.gui.stop.StopTablePanel;
import de.datomino.peppergis.tourmanager.gui.tour.TourSettingPanel;
import de.datomino.peppergis.tourmanager.handler.action.stop.StopTableRowHandler;
import de.datomino.peppergis.tourmanager.listener.stop.StopTableListener;
import de.datomino.peppergis.tourmanager.listener.tour.TourSettingListener;
import de.datomino.peppergis.type.UserRole;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.Serializable;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class TourSettingDialog
extends JPanel
implements Pausable {
    private static final long serialVersionUID = 4236445125277111346L;
    private TourManagerCalendarGui tourManagerCalendarGui;
    private StopTablePanel stopTablePanel;
    private TourSettingPanel tourSettingPanel;
    private JDialog dialog;

    public TourSettingDialog(TourManagerCalendarGui tourManagerCalendarGui, TourModel tourModel) {
        super(new BorderLayout());
        this.tourManagerCalendarGui = tourManagerCalendarGui;
        this.tourSettingPanel = new TourSettingPanel(this, tourModel);
        this.stopTablePanel = new StopTablePanel(tourModel, true, tourManagerCalendarGui.getModelEnviroment());
        this.stopTablePanel.setPausableDialog(this);
        StopTableListener stopTableListener = new StopTableListener(this.tourManagerCalendarGui, this.stopTablePanel, null, true);
        this.stopTablePanel.getStopTable().addMouseListener(stopTableListener);
        if (ModelEnviroment.getUserInformation().hasUserRoleForTour(tourModel, UserRole.DELIVERER_ACTIVE, UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.DISPONENT_SUPER, UserRole.ADMIN)) {
            this.stopTablePanel.getStopTable().addMouseMotionListener(stopTableListener);
            this.stopTablePanel.getStopTable().setDragEnabled(true);
            this.stopTablePanel.getStopTable().setDropMode(DropMode.INSERT_ROWS);
            this.stopTablePanel.getStopTable().setTransferHandler(new StopTableRowHandler(this.stopTablePanel.getStopTable()));
        }
        this.add((Component)new JSplitPane(0, this.tourSettingPanel, this.stopTablePanel.createScrollPane()), "Center");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public static void createAndShowGUI(TourManagerCalendarGui tourManangerCalendarGui, TourModel tour) {
        tourManangerCalendarGui.getActions().getUndoManager().startTransaction();
        TourSettingDialog tourSettingDialog = new TourSettingDialog(tourManangerCalendarGui, tour);
        tourSettingDialog.setOpaque(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        JDialog dialog = new JDialog((Frame)SwingUtilities.getRoot(tourManangerCalendarGui), ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.tour", new Serializable[0]) + " " + tour.getName() + "", true);
        try {
            dialog.setIconImage(ImageIO.read(TourSettingDialog.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        Point parentLoaction = tourManangerCalendarGui.getLocationOnScreen();
        dialog.setLocation(parentLoaction.x + 30, parentLoaction.y + 20);
        if (ModelEnviroment.getUserInformation().hasUserRoleForTour(tour, UserRole.DELIVERER_ACTIVE, UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.DISPONENT_SUPER, UserRole.ADMIN)) {
            TourSettingListener tourSettingListener = new TourSettingListener(tourManangerCalendarGui, tourSettingDialog);
            dialog.addWindowListener(tourSettingListener);
            dialog.setDefaultCloseOperation(0);
        } else {
            dialog.setDefaultCloseOperation(2);
        }
        dialog.add(tourSettingDialog);
        tourSettingDialog.setDialog(dialog);
        Dimension sizeOfScreen = Toolkit.getDefaultToolkit().getScreenSize();
        if (sizeOfScreen.width < 1510 || sizeOfScreen.height < 900) {
            dialog.setPreferredSize(new Dimension(Toolkit.getDefaultToolkit().getScreenSize().width, sizeOfScreen.height));
        } else {
            dialog.setPreferredSize(new Dimension(1510, 900));
        }
        dialog.pack();
        dialog.setVisible(true);
    }

    public void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    @Override
    public void pause() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
    }

    @Override
    public void resume() {
        if (this.dialog != null) {
            this.dialog.setVisible(true);
        }
    }

    public void repaintStopTablePanel() {
        this.getTourSettingPanel().updateTourSettingPanel();
        this.stopTablePanel.updateStopTable();
    }

    public TourSettingPanel getTourSettingPanel() {
        return this.tourSettingPanel;
    }

    public TourCaller getTourCaller() {
        return this.tourManagerCalendarGui.getActions().getTourCaller();
    }

    public ModelEnviroment getModelEnviroment() {
        return this.tourManagerCalendarGui.getModelEnviroment();
    }
}

