/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.tour;

import de.datomino.peppergis.PeppergisConstants;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.MultiLineHeaderRenderer;
import de.datomino.peppergis.client.model.base.ServiceModel;
import de.datomino.peppergis.client.model.offer.OfferModel;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.dto.lucene.SearchType;
import de.datomino.peppergis.dto.tour.TourSearchDto;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.gui.tour.TourSettingDialog;
import de.datomino.peppergis.util.StringComparator;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.time.TimeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Holder;

public class TourSearchPane
extends JPanel {
    private static final long serialVersionUID = -3472050374444944196L;
    private static final int COL_TOUR = 0;
    private static final int COL_DELIVERER_NUMBER = 1;
    private static final int COL_DELIVERER_NAME = 2;
    private static final int COL_DATE = 3;
    private static final int COL_SERVICE_NUMBERS = 4;
    private static final int COL_OFFER_NUMBERS = 5;
    private TourManagerCalendarGui tourManager;
    private JTable tourTable;

    public TourSearchPane(TourManagerCalendarGui tourManager) {
        super(new BorderLayout());
        this.tourManager = tourManager;
        this.add(this.createSearchPane(), "North");
        this.add(this.createResultPane(), "Center");
    }

    private Component createSearchPane() {
        final TourSearchDto searchDto = new TourSearchDto();
        Holder<TourSearchDto> holder = new Holder<TourSearchDto>(searchDto);
        JPanel parameterPane = new JPanel(new SpringLayout());
        parameterPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.tour", new Serializable[0])));
        final JTextField tourName = ClientSwingUtil.createParameterTextField(50, null, true, "TourName", holder, this);
        parameterPane.add(tourName);
        parameterPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.delivererNumber", new Serializable[0])));
        final JTextField delivererNumber = ClientSwingUtil.createParameterTextField(50, null, true, "DelivererNumber", holder, this);
        parameterPane.add(delivererNumber);
        parameterPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.delivererName", new Serializable[0])));
        final JTextField delivererName = ClientSwingUtil.createParameterTextField(50, null, true, "DelivererName", holder, this);
        parameterPane.add(delivererName);
        parameterPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.date", new Serializable[0])));
        final JTextField date = ClientSwingUtil.createParameterTextField(50, null, true, "Date", holder, this, ClientFormUtil.DATEFORMAT);
        parameterPane.add(date);
        parameterPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.default.services", "messages.webportalcontrol.orderNumber"), "/")));
        final JTextField offerNumber = ClientSwingUtil.createParameterTextField(50, null, true, "OfferNumber", holder, this);
        parameterPane.add(offerNumber);
        SpringUtilities.makeCompactGrid(parameterPane, 5, 2, 5, 5, 5, 5);
        JPanel buttonPane = new JPanel(new FlowLayout(2));
        buttonPane.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.search", new Serializable[0])){
            private static final long serialVersionUID = -5035514028981919515L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TourSearchPane.this.loadTours(searchDto);
            }
        }));
        buttonPane.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("buttons.clear", new Serializable[0])){
            private static final long serialVersionUID = 4610066720155450075L;

            @Override
            public void actionPerformed(ActionEvent e) {
                tourName.setText(null);
                delivererNumber.setText(null);
                delivererName.setText(null);
                date.setText(null);
                offerNumber.setText(null);
            }
        }));
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)parameterPane, "Center");
        pane.add((Component)buttonPane, "South");
        return pane;
    }

    private Component createResultPane() {
        this.tourTable = new JTable(new TourTableModel());
        this.tourTable.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tourTable.getSelectionModel().setSelectionMode(0);
        this.tourTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int selectedRow = TourSearchPane.this.tourTable.getSelectedRow();
                    if (selectedRow < 0) {
                        return;
                    }
                    Object value = TourSearchPane.this.tourTable.getValueAt(selectedRow, 0);
                    if (value != null && value instanceof TourModel) {
                        TourSettingDialog.createAndShowGUI(TourSearchPane.this.tourManager, (TourModel)value);
                    }
                }
            }
        });
        this.setTourTableStyle();
        return new JScrollPane(this.tourTable);
    }

    private void loadTours(TourSearchDto searchDto) {
        Set<TourModel> tours = this.tourManager.getTourListGui().getAllTours();
        tours.addAll(this.tourManager.getActions().getTourCaller().searchTours(searchDto));
        ArrayList<TourModel> list = new ArrayList<TourModel>();
        for (TourModel tour : tours) {
            DelivererModel deliverer;
            if (!ClientFormUtil.matchs(tour.getName(), searchDto.getTourName(), SearchType.WILD_CARD) || searchDto.getDate() != null && (tour.getPlannedStartTime() == null || TimeUtil.isSameDay(searchDto.getDate(), tour.getPlannedStartTime())) || !ClientFormUtil.matchs((deliverer = tour.getDeliverer()) == null ? null : deliverer.getDelivererNumber(), searchDto.getDelivererNumber(), SearchType.WILD_CARD) || !ClientFormUtil.matchs(deliverer == null ? null : deliverer.getName(), searchDto.getDelivererName(), SearchType.WILD_CARD) || !ClientFormUtil.matchs(this.getServiceString(tour), searchDto.getOfferNumber(), SearchType.WILD_CARD) && !ClientFormUtil.matchs(this.getOfferString(tour), searchDto.getOfferNumber(), SearchType.WILD_CARD)) continue;
            list.add(tour);
        }
        Collections.sort(list, new StringComparator<TourModel>(true){

            @Override
            protected String getString(TourModel o) {
                return o.getName();
            }
        });
        TourTableModel dm = (TourTableModel)this.tourTable.getModel();
        dm.tours = list;
        dm.fireTableDataChanged();
    }

    private void setTourTableStyle() {
        this.tourTable.setRowHeight(40);
        this.tourTable.setRowMargin(5);
        this.tourTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.tourTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.tourTable.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.tourTable.getColumnModel().getColumn(3).setPreferredWidth(100);
        this.tourTable.getColumnModel().getColumn(4).setPreferredWidth(100);
        this.tourTable.getColumnModel().getColumn(5).setPreferredWidth(100);
        MultiLineHeaderRenderer headerHenderer = new MultiLineHeaderRenderer(){

            @Override
            protected int getCellHeight() {
                return 40;
            }
        };
        Enumeration<TableColumn> enumeration = this.tourTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setHeaderRenderer(headerHenderer);
            tableColumn.setCellRenderer(new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    String s;
                    String string = s = value == null ? "" : value.toString();
                    if (value instanceof TourModel) {
                        s = ((TourModel)value).getName();
                    }
                    JLabel label = new JLabel(s);
                    label.setOpaque(true);
                    label.setFont(table.getFont());
                    label.setBackground(isSelected ? PeppergisConstants.SELECTION_COLOR : Color.WHITE);
                    label.setBorder(BorderFactory.createEmptyBorder());
                    return label;
                }
            });
        }
    }

    private String getServiceString(TourModel tour) {
        String s = "";
        List<ServiceModel> services = TourModelUtil.getServices(tour);
        for (ServiceModel service : services) {
            if (!StringUtil.isEmpty(s)) {
                s = s + "/";
            }
            s = s + service.getServiceNumber();
        }
        return s;
    }

    private String getOfferString(TourModel tour) {
        String s = "";
        List<OfferModel> offers = TourModelUtil.getOffers(tour);
        for (OfferModel offer : offers) {
            if (!StringUtil.isEmpty(s)) {
                s = s + "/";
            }
            s = s + offer.getOfferNumber();
        }
        return s;
    }

    public TourModel getSelectedTour() {
        TourTableModel dm = (TourTableModel)this.tourTable.getModel();
        int selectedRow = this.tourTable.getSelectedRow();
        return selectedRow < 0 ? null : (TourModel)dm.tours.get(selectedRow);
    }

    private class TourTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = -1402586986645181404L;
        private List<TourModel> tours = new ArrayList<TourModel>();

        private TourTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.tours == null ? 0 : this.tours.size();
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public String getColumnName(int columnIndex) {
            String header = "";
            switch (columnIndex) {
                case 0: {
                    header = ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.tour", new Serializable[0]);
                    break;
                }
                case 1: {
                    header = ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.delivererNumber", new Serializable[0]);
                    break;
                }
                case 2: {
                    header = ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.delivererName", new Serializable[0]);
                    break;
                }
                case 3: {
                    header = ModelEnviroment.getMessageResolver().resolveMessage("gui.date.date", new Serializable[0]);
                    break;
                }
                case 4: {
                    header = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.service", new Serializable[0]);
                    break;
                }
                case 5: {
                    header = ModelEnviroment.getMessageResolver().resolveMessage("messages.webportalcontrol.orderNumber", new Serializable[0]);
                }
            }
            return header;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            TourModel tour = this.tours.get(rowIndex);
            DelivererModel deliverer = tour.getDeliverer();
            Object value = null;
            switch (columnIndex) {
                case 0: {
                    value = tour;
                    break;
                }
                case 1: {
                    value = deliverer == null ? "" : ClientFormUtil.getStringDisplay(deliverer.getDelivererNumber());
                    break;
                }
                case 2: {
                    value = deliverer == null ? "" : ClientFormUtil.getStringDisplay(deliverer.getName());
                    break;
                }
                case 3: {
                    value = ClientFormUtil.dateToString(tour.getPlannedStartTime());
                    break;
                }
                case 4: {
                    value = TourSearchPane.this.getServiceString(tour);
                    break;
                }
                case 5: {
                    value = TourSearchPane.this.getOfferString(tour);
                }
            }
            return value;
        }
    }
}

