/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.tour;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.MultiLineHeaderRenderer;
import de.datomino.peppergis.client.manager.util.WeekdayName;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.DelivererModelImpl;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourModelImpl;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.gui.tour.PlanTableCellRenderer;
import de.datomino.peppergis.tourmanager.gui.tour.PlanTableModel;
import de.datomino.peppergis.tourmanager.gui.tour.event.TourSelectionEvent;
import de.datomino.peppergis.tourmanager.gui.tour.event.TourSelectionListener;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.time.TimeUtil;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class TourPlanTableGui {
    private EventListenerList tourSelectionListenerList = new EventListenerList();
    private TourManagerCalendarGui tourManagerCalendarGui;
    private JTable planTable;
    private PlanTableModel planTableModel;
    private Object[][] delisAndToursInTable;
    private Map<TourModel, Tupel<Integer, Integer>> selectedToursInTable = new HashMap<TourModel, Tupel<Integer, Integer>>();
    private String[] columnHeader;
    private GregorianCalendar calendar;
    private int delivererCount;
    private Map<TourModel, Tupel<Integer, Integer>> tourPositionInTable = new HashMap<TourModel, Tupel<Integer, Integer>>();
    private Map<DelivererModel, Tupel<Integer, Integer>> delivererPositionInTable = new HashMap<DelivererModel, Tupel<Integer, Integer>>();

    public JScrollPane createPlanGui(TourManagerCalendarGui tourManagerCalendarGui, int delivererCount) {
        this.tourManagerCalendarGui = tourManagerCalendarGui;
        this.delivererCount = delivererCount;
        this.columnHeader = this.createColumnHeader();
        this.planTableModel = new PlanTableModel();
        this.planTable = new JTable(this.planTableModel);
        this.planTable.setPreferredScrollableViewportSize(FormUtil.SIZEOFPLANTABLE);
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel(){
            private static final long serialVersionUID = -5796592163675977810L;

            @Override
            public void moveColumn(int columnIndex, int newIndex) {
            }
        };
        this.planTable.setColumnModel(columnModel);
        this.planTable.setCellSelectionEnabled(true);
        this.planTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int viewColumn;
                JTableHeader h;
                TableColumnModel columnModel;
                int selectedColumn;
                if ((e.getModifiers() & 2) <= 0) {
                    TourPlanTableGui.this.clearSelectedTours();
                }
                if (e.getButton() == 1 && e.getClickCount() == 1 && (selectedColumn = (columnModel = (h = (JTableHeader)e.getSource()).getColumnModel()).getColumn(viewColumn = columnModel.getColumnIndexAtX(e.getX())).getModelIndex()) > -1) {
                    TourPlanTableGui.this.clearSelectedTours();
                    if (selectedColumn == 0) {
                        for (int i = 1; i < columnModel.getColumnCount(); ++i) {
                            TourPlanTableGui.this.addToursInSelectedColumn(i);
                        }
                    } else {
                        TourPlanTableGui.this.addToursInSelectedColumn(selectedColumn);
                    }
                }
            }
        });
        final String[] split = StringUtil.nullToEmpty(TourModelUtil.tour_tablecell_pattern).replaceAll(",", "\n").split("\n");
        if (!NavigatorPanel.HEADLESS) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RuntimeException exception = null;
                    for (int i = 0; i < 3; ++i) {
                        try {
                            Graphics2D g = (Graphics2D)TourPlanTableGui.this.planTable.getGraphics();
                            Font font = TourPlanTableGui.this.planTable.getFont();
                            Rectangle2D maxCharBounds = font.getMaxCharBounds(g.getFontRenderContext());
                            int height = (int)Math.round(maxCharBounds.getHeight());
                            TourPlanTableGui.this.planTable.setRowHeight((height + 10) * split.length);
                            return;
                        }
                        catch (RuntimeException ex) {
                            exception = ex;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    throw exception;
                }
            });
        }
        this.planTable.setRowMargin(5);
        this.createPlanTable();
        return new JScrollPane(this.planTable);
    }

    public void createPlanTable() {
        this.clearSelectedTours();
        this.createNullPlanTable();
        this.addContentToTable();
        this.createMultiHeader();
    }

    private void createMultiHeader() {
        MultiLineHeaderRenderer headerRenderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = this.planTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setHeaderRenderer(headerRenderer);
            tableColumn.setCellRenderer(new PlanTableCellRenderer(this));
        }
    }

    private void createNullPlanTable() {
        this.delisAndToursInTable = new Object[this.delivererCount][this.columnHeader.length];
        for (int col = 0; col < this.columnHeader.length; ++col) {
            for (int row = 0; row < this.delisAndToursInTable.length; ++row) {
                this.delisAndToursInTable[row][col] = col == 0 ? new DelivererModelImpl(new Long(0L), null) : new TourModelImpl(new Long(0L), null);
            }
        }
        this.planTableModel.setDataVector(this.delisAndToursInTable, this.columnHeader);
    }

    public void addContentToTable() {
        this.clearSelectedTours();
        this.tourPositionInTable = new HashMap<TourModel, Tupel<Integer, Integer>>();
        Date currentDate = this.tourManagerCalendarGui.getCalendarGui().getCurrentDate();
        ArrayList<TourModel> toursWithDeliverer = new ArrayList<TourModel>();
        ArrayList<TourModel> toursWithoutDeliverer = new ArrayList<TourModel>();
        for (TourModel tour : this.tourManagerCalendarGui.getTourListGui().getPlannedToursInWeek(currentDate)) {
            if (tour.getPlannedStartTime() == null) continue;
            this.tourManagerCalendarGui.getTourListGui().getTourListModel().removeElementWithId(tour.getTempUUID());
            if (!TimeUtil.isSamedWeek(currentDate, tour.getPlannedStartTime())) continue;
            if (tour.getDeliverer() == null) {
                toursWithoutDeliverer.add(tour);
                continue;
            }
            toursWithDeliverer.add(tour);
        }
        int rowIndex = 0;
        for (DelivererModel deliverer : this.tourManagerCalendarGui.getDelivererGui().getAllDeliverers()) {
            boolean isTourExists = false;
            if (rowIndex >= this.delivererCount) {
                this.addNullRowInTable();
            }
            for (TourModel tour : toursWithDeliverer) {
                if (deliverer.getTempUUID() != tour.getDeliverer().getTempUUID()) continue;
                int col = this.getColumnIndexForWeekday(tour.getPlannedStartTime());
                GregorianCalendar dateOnColumn = this.tourManagerCalendarGui.getDateFromCol(col);
                if (!TimeUtil.isSamedDay(tour.getPlannedStartTime(), dateOnColumn.getTime())) continue;
                isTourExists = true;
                Tupel<Integer, Integer> tupel = new Tupel<Integer, Integer>(col, rowIndex);
                TourModel tourModel = (TourModel)this.delisAndToursInTable[tupel.getElement2()][col];
                if (tourModel != null && tourModel.getTempUUID() != 0L) {
                    if (++rowIndex >= this.delivererCount) {
                        this.addNullRowInTable();
                    }
                    tupel = new Tupel<Integer, Integer>(col, rowIndex);
                }
                this.delisAndToursInTable[tupel.getElement2().intValue()][0] = tour.getDeliverer();
                this.delisAndToursInTable[tupel.getElement2().intValue()][col] = tour;
                this.tourPositionInTable.put(tour, tupel);
            }
            if (!isTourExists) continue;
            ++rowIndex;
        }
        for (TourModel tour : toursWithoutDeliverer) {
            if (rowIndex >= this.delivererCount) {
                this.addNullRowInTable();
            }
            int col = this.getColumnIndexForWeekday(tour.getPlannedStartTime());
            GregorianCalendar dateOnColumn = this.tourManagerCalendarGui.getDateFromCol(col);
            if (!TimeUtil.isSamedDay(tour.getPlannedStartTime(), dateOnColumn.getTime())) continue;
            this.delisAndToursInTable[rowIndex][col] = tour;
            this.tourPositionInTable.put(tour, new Tupel<Integer, Integer>(col, rowIndex));
            ++rowIndex;
        }
        this.planTableModel.setDataVector(this.delisAndToursInTable, this.columnHeader);
        this.tourManagerCalendarGui.getTourListGui().getTourJList().repaint();
        this.planTableModel.fireTableDataChanged();
    }

    private int getColumnIndexForWeekday(Date date) {
        int dayOfWeek = TimeUtil.getDayOfWeek(date);
        if (dayOfWeek == 1) {
            dayOfWeek = 8;
        }
        return dayOfWeek - 1;
    }

    private String[] createColumnHeader() {
        this.calendar = new GregorianCalendar();
        int dayOfWeek = this.calendar.get(7);
        if (dayOfWeek == 1) {
            dayOfWeek = 8;
        }
        this.calendar.add(5, 1 - dayOfWeek);
        String[] columnHeader = new String[]{" \n \n" + ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.deliOrTech", new Serializable[0]) + "\n \n", this.getFormatedString(WeekdayName.D1.getName()), this.getFormatedString(WeekdayName.D2.getName()), this.getFormatedString(WeekdayName.D3.getName()), this.getFormatedString(WeekdayName.D4.getName()), this.getFormatedString(WeekdayName.D5.getName()), this.getFormatedString(WeekdayName.D6.getName()), this.getFormatedString(WeekdayName.D7.getName())};
        return columnHeader;
    }

    private String getFormatedString(String string) {
        this.calendar.add(5, 1);
        return " \n" + string + "\n" + this.calendar.get(5) + " - " + (this.calendar.get(2) + 1) + " - " + this.calendar.get(1) + "\n \n";
    }

    public boolean isInTable(Point location) {
        Point pointTable = this.planTable.getLocationOnScreen();
        int width = this.planTable.getWidth();
        int height = this.planTable.getRowHeight() * this.planTable.getRowCount();
        return location.x > pointTable.x && location.x < pointTable.x + width && location.y > pointTable.y && location.y < pointTable.y + height;
    }

    public Object getSelObject() {
        return this.getObjectInTable(this.planTable.getSelectedRow(), this.planTable.getSelectedColumn());
    }

    public Object getObjectInTable(int row, int col) {
        if (row == -1 || col == -1) {
            return null;
        }
        return this.planTableModel.getObjectAt(row, col);
    }

    public List<TourModel> getToursInRow(int row) {
        ArrayList<TourModel> toursInRow = new ArrayList<TourModel>();
        for (int col = 1; col < this.planTableModel.getColumnCount(); ++col) {
            if (((TourModel)this.getObjectInTable(row, col)).getTempUUID().equals(new Long(0L))) continue;
            toursInRow.add((TourModel)this.getObjectInTable(row, col));
        }
        return toursInRow;
    }

    public Collection<Date> getTourDatesInRow(int row) {
        LinkedList<Date> dates = new LinkedList<Date>();
        Date date = this.getCurrentWeek().getElement1();
        for (int col = 1; col < this.planTableModel.getColumnCount(); ++col) {
            if (!((TourModel)this.getObjectInTable(row, col)).getTempUUID().equals(new Long(0L))) {
                dates.add(date);
            }
            date = TimeUtil.add(date, 5, 1);
        }
        return dates;
    }

    public JTable getPlanTable() {
        return this.planTable;
    }

    public PlanTableModel getPlanTableModel() {
        return this.planTableModel;
    }

    public String[] getColumnHeader() {
        return this.columnHeader;
    }

    public void fireTourObjectChanged(DelivererModel deliverer, TourModel newTour) {
        if (deliverer != null && deliverer.getTempUUID() == 0L) {
            deliverer = null;
        }
        for (TourModel oldTour : this.tourManagerCalendarGui.getTourListGui().getAllTours()) {
            if (!newTour.getTempUUID().equals(oldTour.getTempUUID())) continue;
            oldTour.setName(newTour.getName());
            oldTour.setDeliverer(deliverer);
            if (newTour.getPlannedStartTime() == null || newTour.getPlannedStartTime().equals(oldTour.getPlannedStartTime())) continue;
            oldTour.setPlannedStartTime(newTour.getPlannedStartTime());
            int columnIndex = this.getColumnIndexForWeekday(oldTour.getPlannedStartTime());
            this.tourPositionInTable.put(oldTour, new Tupel<Integer, Integer>(columnIndex, this.findNullCell(deliverer, columnIndex, newTour.getPlannedStartTime())));
        }
    }

    private int findNullCell(DelivererModel deliverer, int columnIndex, Date plannedTime) {
        int[] rows = new int[this.planTableModel.getRowCount()];
        Set<TourModel> tourList = this.tourManagerCalendarGui.getTourListGui().getPlannedToursInWeek(plannedTime);
        for (TourModel tour : tourList) {
            if (this.tourPositionInTable.get(tour) == null) continue;
            int columnOfTour = this.tourPositionInTable.get(tour).getElement1();
            int rowOfTour = this.tourPositionInTable.get(tour).getElement2();
            if (rowOfTour != -1 && columnOfTour == columnIndex) {
                rows[rowOfTour] = -1;
                continue;
            }
            if (deliverer == null) continue;
            DelivererModel delivererInRow = tour.getDeliverer();
            if (delivererInRow != null) {
                if (delivererInRow.getTempUUID() != 0L && delivererInRow.getTempUUID() != deliverer.getTempUUID()) {
                    rows[rowOfTour] = -1;
                }
                if (delivererInRow.getTempUUID() != 0L || deliverer.getTempUUID() == 0L) continue;
                rows[rowOfTour] = -1;
                continue;
            }
            rows[rowOfTour] = -1;
        }
        int rowIndex = this.findNullRowIndex(rows);
        if (rowIndex >= this.planTableModel.getRowCount()) {
            this.addNullRowInTable();
        }
        return rowIndex;
    }

    private void addNullRowInTable() {
        this.planTableModel.addNullRow();
        Object[][] extended = new Object[this.delisAndToursInTable.length + 1][this.columnHeader.length];
        System.arraycopy(this.delisAndToursInTable, 0, extended, 0, this.delisAndToursInTable.length);
        this.delisAndToursInTable = extended;
        ++this.delivererCount;
    }

    private int findNullRowIndex(int[] rows) {
        for (int index = 0; index < rows.length; ++index) {
            if (rows[index] != 0) continue;
            return index;
        }
        return rows.length;
    }

    public void setTourPosition(TourModel tour, int dropCol, int dropRow) {
        if (dropCol == -1 || dropRow == -1) {
            this.tourPositionInTable.remove(tour);
        } else {
            this.tourPositionInTable.put(tour, new Tupel<Integer, Integer>(dropCol, dropRow));
        }
    }

    public void setDelivererPosition(DelivererModel deliverer, int dropRow) {
        this.delivererPositionInTable.put(deliverer, new Tupel<Integer, Integer>(0, dropRow));
    }

    public void addNullRow() {
        ++this.delivererCount;
        this.createPlanTable();
    }

    private void addToursInSelectedColumn(int selectedColumn) {
        HashMap<TourModel, Tupel<Integer, Integer>> oldValues = new HashMap<TourModel, Tupel<Integer, Integer>>(this.selectedToursInTable);
        for (int rowIndex = 0; rowIndex < this.planTableModel.getRowCount(); ++rowIndex) {
            TourModel tour;
            Object o = this.planTableModel.getObjectAt(rowIndex, selectedColumn);
            if (o == null || !(o instanceof TourModel) || (tour = (TourModel)o).getTempUUID().equals(0L)) continue;
            this.selectedToursInTable.put(tour, new Tupel<Integer, Integer>(rowIndex, selectedColumn));
        }
        this.fireTourSelectionChanged(new TourSelectionEvent(this, Collections.unmodifiableMap(oldValues), this.getSelectedToursInTable()));
        this.planTable.repaint(10L);
    }

    public void addToursInSelectedRow(int selectedRow) {
        HashMap<TourModel, Tupel<Integer, Integer>> oldValues = new HashMap<TourModel, Tupel<Integer, Integer>>(this.selectedToursInTable);
        for (int colIndex = 0; colIndex < this.planTableModel.getColumnCount(); ++colIndex) {
            TourModel tour;
            Object o = this.planTableModel.getObjectAt(selectedRow, colIndex);
            if (o == null || !(o instanceof TourModel) || (tour = (TourModel)o).getTempUUID().equals(0L)) continue;
            this.selectedToursInTable.put(tour, new Tupel<Integer, Integer>(selectedRow, colIndex));
        }
        this.fireTourSelectionChanged(new TourSelectionEvent(this, Collections.unmodifiableMap(oldValues), this.getSelectedToursInTable()));
    }

    public void updateSelectedTour(TourModel tourModel) {
        if (this.selectedToursInTable == null) {
            this.selectedToursInTable = new HashMap<TourModel, Tupel<Integer, Integer>>();
        }
        HashMap<TourModel, Tupel<Integer, Integer>> oldValues = new HashMap<TourModel, Tupel<Integer, Integer>>(this.selectedToursInTable);
        if (this.selectedToursInTable.containsKey(tourModel)) {
            this.selectedToursInTable.remove(tourModel);
        } else {
            this.selectedToursInTable.put(tourModel, new Tupel<Integer, Integer>(this.planTable.getSelectedRow(), this.planTable.getSelectedColumn()));
        }
        this.fireTourSelectionChanged(new TourSelectionEvent(this, Collections.unmodifiableMap(oldValues), this.getSelectedToursInTable()));
    }

    public void clearSelectedTours() {
        Map<TourModel, Tupel<Integer, Integer>> oldValues = this.getSelectedToursInTable();
        this.selectedToursInTable.clear();
        Map<TourModel, Tupel<Integer, Integer>> emptyMap = Collections.emptyMap();
        this.fireTourSelectionChanged(new TourSelectionEvent(this, oldValues, emptyMap));
    }

    public Map<TourModel, Tupel<Integer, Integer>> getSelectedToursInTable() {
        return Collections.unmodifiableMap(this.selectedToursInTable);
    }

    public void removeSelectIfExists(TourModel tourModel) {
        if (this.selectedToursInTable != null && this.selectedToursInTable.containsKey(tourModel)) {
            HashMap<TourModel, Tupel<Integer, Integer>> oldValues = new HashMap<TourModel, Tupel<Integer, Integer>>(this.selectedToursInTable);
            this.selectedToursInTable.remove(tourModel);
            this.fireTourSelectionChanged(new TourSelectionEvent(this, Collections.unmodifiableMap(oldValues), this.getSelectedToursInTable()));
        }
    }

    public void addTourSelectionListener(TourSelectionListener tourSelectionListener) {
        this.tourSelectionListenerList.add(TourSelectionListener.class, tourSelectionListener);
    }

    public void removeTourSelectionListener(TourSelectionListener tourSelectionListener) {
        this.tourSelectionListenerList.remove(TourSelectionListener.class, tourSelectionListener);
    }

    protected void fireTourSelectionChanged(TourSelectionEvent tourSelectionEvent) {
        for (TourSelectionListener tourSelectionListener : (TourSelectionListener[])this.tourSelectionListenerList.getListeners(TourSelectionListener.class)) {
            tourSelectionListener.selectionChanged(tourSelectionEvent);
        }
    }

    public Tupel<Date, Date> getCurrentWeek() {
        Date currentDate = this.tourManagerCalendarGui.getCalendarGui().getCurrentDate();
        return TimeUtil.getWeekTupel(currentDate);
    }
}

