/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.tour;

import de.datomino.peppergis.client.gui.renderer.AbstractTableRenderer;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.util.DelivererModelUtil;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.tourmanager.gui.tour.PlanTableModel;
import de.datomino.peppergis.tourmanager.gui.tour.TourPlanTableGui;
import de.datomino.peppergis.type.DelivererStatus;
import de.datomino.util.time.TimeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JTable;
import org.ktde.util.datatypes.Tupel;

public class PlanTableCellRenderer
extends AbstractTableRenderer {
    private TourPlanTableGui planTableGui;

    public PlanTableCellRenderer(TourPlanTableGui planTableGui) {
        this.planTableGui = planTableGui;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JList list = this.createJList(value, 2, table.getFont());
        list.setFont(table.getFont());
        list.setBorder(BorderFactory.createEmptyBorder());
        Map<TourModel, Tupel<Integer, Integer>> selectedToursInTable = this.planTableGui.getSelectedToursInTable();
        if (selectedToursInTable != null && selectedToursInTable.containsValue(new Tupel<Integer, Integer>(row, column))) {
            list.setBackground(Color.YELLOW);
        }
        boolean normal = true;
        PlanTableModel planTableModel = this.planTableGui.getPlanTableModel();
        Tupel<Date, Date> currentWeek = this.planTableGui.getCurrentWeek();
        if (column == 0 && value != null && !value.equals("")) {
            DelivererModel deliverer = (DelivererModel)planTableModel.getObjectAt(row, column);
            Tupel<Date, Date> absentTupel = DelivererModelUtil.getAbsentTupel(deliverer, currentWeek);
            if (absentTupel.getElement1() != null && absentTupel.getElement2() != null) {
                for (int i = 1; i < planTableModel.getColumnCount(); ++i) {
                    TourModel tour = (TourModel)planTableModel.getObjectAt(row, i);
                    if (tour == null || tour.getPlannedStartTime() == null || !tour.getPlannedStartTime().after(absentTupel.getElement1()) || !tour.getPlannedStartTime().before(absentTupel.getElement2())) continue;
                    normal = false;
                    break;
                }
            }
            if (this.hasMoreTours(deliverer, row)) {
                list.setForeground(Color.BLUE);
            }
            if (!DelivererModelUtil.isDelivererTourMappingValid(deliverer, TimeUtil.getWeekDays(currentWeek.getElement1()))) {
                list.setForeground(Color.ORANGE.darker().darker());
            }
            if (this.isDelivererDeletedInWeek(deliverer)) {
                Map<TextAttribute, ?> attributes = table.getFont().getAttributes();
                attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                list.setFont(new Font(attributes));
            }
        } else if (column != 0 && value != null && !value.equals("")) {
            Tupel<Date, Date> absentTupel;
            TourModel tour = (TourModel)planTableModel.getObjectAt(row, column);
            if (tour != null && tour.getPlannedStartTime() != null && (absentTupel = DelivererModelUtil.getAbsentTupel(tour.getDeliverer(), currentWeek)).getElement1() != null && absentTupel.getElement2() != null && tour.getPlannedStartTime().after(absentTupel.getElement1()) && tour.getPlannedStartTime().before(absentTupel.getElement2())) {
                normal = false;
            }
            if (TourModelUtil.hasBadTimeWindow(tour)) {
                normal = false;
            }
        }
        if (!normal) {
            list.setForeground(Color.RED);
        }
        return list;
    }

    private boolean hasMoreTours(DelivererModel deliverer, int currentRow) {
        boolean b = false;
        PlanTableModel planTableModel = this.planTableGui.getPlanTableModel();
        block0: for (int row = 0; row < planTableModel.getRowCount(); ++row) {
            DelivererModel otherDeliverer = (DelivererModel)planTableModel.getObjectAt(row, 0);
            if (row == currentRow || !deliverer.equals(otherDeliverer)) continue;
            for (int column = 1; column < planTableModel.getColumnCount(); ++column) {
                TourModel tour = (TourModel)planTableModel.getObjectAt(currentRow, column);
                TourModel otherTour = (TourModel)planTableModel.getObjectAt(row, column);
                if (tour == null || otherTour == null || tour.getTempUUID().equals(0L) || otherTour.getTempUUID().equals(0L)) continue;
                b = true;
                continue block0;
            }
        }
        return b;
    }

    private boolean isDelivererDeletedInWeek(DelivererModel deliverer) {
        boolean isDeleted = false;
        Tupel<Date, Date> week = this.planTableGui.getCurrentWeek();
        Date day = week.getElement1();
        Calendar cal = Calendar.getInstance();
        while (!day.after(week.getElement2())) {
            isDeleted |= DelivererModelUtil.getStatus(deliverer, day) == DelivererStatus.DELETED;
            cal.setTimeInMillis(day.getTime());
            cal.add(5, 1);
            day.setTime(cal.getTimeInMillis());
        }
        return isDeleted;
    }
}

