/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.tour;

import de.datomino.logistic.LogisticException;
import de.datomino.logistic.dto.OptimizationAlgorithmType;
import de.datomino.logistic.type.OptimizationType;
import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.communication.tour.SimpleTourRoutingContext;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.tourmanager.gui.AbstractRoutingWithComboBoxDialog;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.handler.TourManagerActions;
import de.datomino.peppergis.tourmanager.handler.action.routing.OptimiseTourWithComboBoxAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.ktde.util.StringUtil;

public class OptimiseSettingDialog
extends AbstractRoutingWithComboBoxDialog {
    private static final String START_POINT_PROPERTY_KEY = "tour.optimize.startPoint";
    private static final String END_POINT_PROPERTY_KEY = "tour.optimize.endPoint";
    private static final String START_FIX_PROPERTY_KEY = "tour.optimize.startFix";
    private static final String END_FIX_PROPERTY_KEY = "tour.optimize.endFix";
    private static final String OPTIMIZATION_TYPE_PROPERTY_KEY = "tour.optimize.optimizationType";
    private static final long serialVersionUID = -2146721382006904812L;
    private static boolean update;
    private OptimizationAlgorithmType algorithmType;

    public OptimiseSettingDialog(Collection<TourModel> tours, TourCaller tourCaller, RouteVehicleType routeVehicleType, RouteType routeType, boolean poiSelectionActive, Component parent, ModelEnviroment modelEnviroment) {
        super(tours, tourCaller, routeVehicleType, routeType, false, poiSelectionActive, parent, modelEnviroment);
    }

    @Override
    protected JPanel createSettingPanel() {
        this.algorithmType = TourManagerActions.tourOptimizer;
        int rows = 17;
        if (this.poiSelectionActive) {
            rows += 2;
        }
        if (this.saveSelectionActive) {
            ++rows;
        }
        JPanel settingPanel = new JPanel(new GridLayout(rows, 1));
        settingPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel startPointLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.start", new Serializable[0]));
        settingPanel.add(startPointLabel);
        this.startPointComboBox = new JComboBox<String>(TourModelUtil.OPTIMISESTARTITEMS);
        this.startPointComboBox.setActionCommand("startpoint");
        this.startPointComboBox.setFont(UIManager.getDefaults().getFont("TextField.font"));
        String prop = ModelEnviroment.getProperties().getProperty(START_POINT_PROPERTY_KEY);
        int selectIndex = 2;
        if (prop != null) {
            switch (prop) {
                case "NOLIMIT": {
                    selectIndex = 0;
                    break;
                }
                case "FIRSTFIX": {
                    selectIndex = 1;
                    break;
                }
                case "DEPOTASFIRST": {
                    selectIndex = 2;
                }
            }
        }
        this.startPointComboBox.setSelectedIndex(selectIndex);
        settingPanel.add(this.startPointComboBox);
        JLabel endPointLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.end", new Serializable[0]));
        settingPanel.add(endPointLabel);
        this.endPointComboBox = new JComboBox<String>(TourModelUtil.OPTIMISEENDITEMS);
        this.endPointComboBox.setActionCommand("endpoint");
        this.endPointComboBox.setFont(UIManager.getDefaults().getFont("TextField.font"));
        prop = ModelEnviroment.getProperties().getProperty(END_POINT_PROPERTY_KEY);
        selectIndex = 2;
        if (prop != null) {
            switch (prop) {
                case "NOLIMIT": {
                    selectIndex = 0;
                    break;
                }
                case "LASTFIX": {
                    selectIndex = 1;
                    break;
                }
                case "DEPOTASLAST": {
                    selectIndex = 2;
                }
            }
        }
        this.endPointComboBox.setSelectedIndex(selectIndex);
        settingPanel.add(this.endPointComboBox);
        super.addPoiComboBox(settingPanel);
        settingPanel.add(new JLabel(""));
        settingPanel.add(new JLabel("Fixierung am Anfang(exkl. Standort)"));
        int sizeOfStops = this.tours.iterator().next().iterateTourParts().next().countStops();
        prop = ModelEnviroment.getProperties().getProperty(START_FIX_PROPERTY_KEY);
        int fixInitValue = 0;
        try {
            fixInitValue = Math.max(Math.min(Integer.parseInt(prop), sizeOfStops), 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sizeOfStartBlockSpinner = new JSpinner(new SpinnerNumberModel(fixInitValue, 0, sizeOfStops, 1));
        this.sizeOfStartBlockSpinner.setEditor(new JSpinner.NumberEditor(this.sizeOfStartBlockSpinner, "0"));
        settingPanel.add(this.sizeOfStartBlockSpinner);
        settingPanel.add(new JLabel("Fixierung am Ende(exkl. Standort)"));
        prop = ModelEnviroment.getProperties().getProperty(END_FIX_PROPERTY_KEY);
        fixInitValue = 0;
        try {
            fixInitValue = Math.max(Math.min(Integer.parseInt(prop), sizeOfStops), 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sizeOfEndBlockSpinner = new JSpinner(new SpinnerNumberModel(fixInitValue, 0, sizeOfStops, 1));
        this.sizeOfEndBlockSpinner.setEditor(new JSpinner.NumberEditor(this.sizeOfEndBlockSpinner, "0"));
        this.sizeOfEndBlockSpinner.setSize(20, 20);
        settingPanel.add(this.sizeOfEndBlockSpinner);
        super.addStartTimeSelection(settingPanel);
        JLabel preferenceLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.preference", new Serializable[0]));
        settingPanel.add(preferenceLabel);
        ButtonGroup preferenceButtonGroup = new ButtonGroup();
        final JRadioButton withStreetButton = new JRadioButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.preference.withSide", new Serializable[0])){
            private static final long serialVersionUID = -8511359074783163721L;

            @Override
            public void actionPerformed(ActionEvent e) {
                OptimiseSettingDialog.this.algorithmType = TourManagerActions.sideTourOptimizer;
            }
        });
        preferenceButtonGroup.add(withStreetButton);
        final JRadioButton withoutStreetButton = new JRadioButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.preference.withoutSide", new Serializable[0])){
            private static final long serialVersionUID = 40547252921124667L;

            @Override
            public void actionPerformed(ActionEvent e) {
                OptimiseSettingDialog.this.algorithmType = TourManagerActions.tourOptimizer;
            }
        });
        preferenceButtonGroup.add(withoutStreetButton);
        ButtonGroup optimizerGroup = new ButtonGroup();
        JRadioButton defaultOptimizerButton = new JRadioButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.preference.noTimewindow", new Serializable[0])){
            private static final long serialVersionUID = -6102810645489054257L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (withoutStreetButton.isSelected()) {
                    OptimiseSettingDialog.this.algorithmType = TourManagerActions.tourOptimizer;
                } else {
                    OptimiseSettingDialog.this.algorithmType = TourManagerActions.sideTourOptimizer;
                }
                withStreetButton.setEnabled(true);
                withoutStreetButton.setEnabled(true);
            }
        });
        optimizerGroup.add(defaultOptimizerButton);
        JRadioButton twOptimizerButton = new JRadioButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.preference.timewindow", new Serializable[0])){
            private static final long serialVersionUID = -3793175836727593294L;

            @Override
            public void actionPerformed(ActionEvent e) {
                OptimiseSettingDialog.this.algorithmType = TourManagerActions.tourOptimizer.getTimeType();
                withStreetButton.setEnabled(false);
                withoutStreetButton.setEnabled(false);
            }
        });
        optimizerGroup.add(twOptimizerButton);
        prop = ModelEnviroment.getProperties().getProperty(OPTIMIZATION_TYPE_PROPERTY_KEY);
        boolean withStreet = false;
        boolean withoutStreet = true;
        boolean shortest = true;
        boolean tw = false;
        if (prop != null) {
            if (prop.startsWith("SHORTEST") && prop.endsWith("WITH_STREET")) {
                withoutStreet = false;
                withStreet = true;
            } else if (prop.startsWith("TIMEWINDOW")) {
                shortest = false;
                tw = true;
            }
        }
        withoutStreetButton.setSelected(withoutStreet);
        withStreetButton.setSelected(withStreet);
        defaultOptimizerButton.setSelected(shortest);
        twOptimizerButton.setSelected(tw);
        withoutStreetButton.setEnabled(shortest);
        withStreetButton.setEnabled(shortest);
        settingPanel.add(defaultOptimizerButton);
        withStreetButton.setBorder(new EmptyBorder(0, 20, 0, 0));
        settingPanel.add(withStreetButton);
        withoutStreetButton.setBorder(new EmptyBorder(0, 20, 0, 0));
        settingPanel.add(withoutStreetButton);
        settingPanel.add(twOptimizerButton);
        super.addSaveSelection(settingPanel);
        return settingPanel;
    }

    @Override
    protected JPanel createButtonPanel() {
        JButton optimiseButton = new JButton(new OptimiseTourWithComboBoxAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.optimise", new Serializable[]{""}), this, this.parent));
        JButton cancelButton = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.common.cancel", new Serializable[0])){
            private static final long serialVersionUID = 6620270720282784243L;

            @Override
            public void actionPerformed(ActionEvent e) {
                OptimiseSettingDialog.this.cancel();
            }
        });
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)optimiseButton, "West");
        buttonPanel.add((Component)cancelButton, "East");
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        return buttonPanel;
    }

    @Override
    protected void updateDialog() {
        OptimizationType currentOptimizationType = this.getCurrentOptimizationType(null, Collections.emptyList());
        if (currentOptimizationType.isStartFix() || currentOptimizationType.isEndFix()) {
            this.poiComboBox.setEnabled(true);
        } else {
            this.poiComboBox.setEnabled(false);
        }
        if (currentOptimizationType.isStartFix()) {
            ClientSwingUtil.setSpinnerEnable(this.sizeOfStartBlockSpinner, true);
        } else {
            ClientSwingUtil.setSpinnerEnable(this.sizeOfStartBlockSpinner, false);
        }
        if (currentOptimizationType.isEndFix()) {
            ClientSwingUtil.setSpinnerEnable(this.sizeOfEndBlockSpinner, true);
        } else {
            ClientSwingUtil.setSpinnerEnable(this.sizeOfEndBlockSpinner, false);
        }
    }

    protected void cancel() {
        update = false;
        this.dispose();
    }

    public static boolean createAndShow(Collection<TourModel> tours, TourCaller tourCaller, Component owner, RouteVehicleType routeVehicleType, RouteType routeType, boolean poiSelectionActive, TourManagerCalendarGui gui) {
        update = true;
        OptimiseSettingDialog optimiseSettingDialog = new OptimiseSettingDialog(tours, tourCaller, routeVehicleType, routeType, poiSelectionActive, owner, gui.getModelEnviroment());
        Point location = owner.getLocationOnScreen();
        optimiseSettingDialog.setLocation(location.x + 25, location.y + 25);
        optimiseSettingDialog.setModal(true);
        optimiseSettingDialog.pack();
        optimiseSettingDialog.setVisible(true);
        if (optimiseSettingDialog.algorithmType.isTimeType()) {
            OptimiseSettingDialog.checkTimeWindows(tours, gui, routeVehicleType, routeType);
        }
        return update;
    }

    private static void checkTimeWindows(Collection<TourModel> tours, TourManagerCalendarGui gui, RouteVehicleType routeVehicleType, RouteType routeType) {
        String badTwNames = "";
        HashSet<TourModel> badTimeWindow = new HashSet<TourModel>();
        for (TourModel tour : tours) {
            if (!TourModelUtil.hasBadTimeWindow(tour)) continue;
            badTimeWindow.add(tour);
            badTwNames = badTwNames + tour.getName() + "\n";
        }
        if (!badTimeWindow.isEmpty()) {
            String s = badTimeWindow.size() == 1 ? ModelEnviroment.getMessageResolver().resolveMessage("messages.question.cutTourWithBadTwSingular", new Serializable[]{badTwNames}) : ModelEnviroment.getMessageResolver().resolveMessage("messages.question.cutTourWithBadTwPlural", new Serializable[]{Integer.valueOf(badTimeWindow.size()), badTwNames});
            ModelEnviroment modelEnviroment = gui.getModelEnviroment();
            TourCaller tourCaller = modelEnviroment.getAllCaller().getTourCaller();
            UndoManager undoManager = modelEnviroment.getUndoManager();
            undoManager.startTransaction();
            switch (JOptionPane.showConfirmDialog(gui, s, "", 0)) {
                case 0: {
                    ArrayList<String> newTourNumbers = new ArrayList<String>(badTimeWindow.size());
                    for (TourModel tour : badTimeWindow) {
                        TourModel newTour = TourModelUtil.cutTourWithBadTw(tour, modelEnviroment);
                        gui.getTourListGui().addNewTour(newTour);
                        newTourNumbers.add(newTour.getName());
                        try {
                            tourCaller.calculateTour(tour, routeVehicleType, routeType, true, gui.getModelEnviroment(), null, true, SimpleTourRoutingContext.INSTANCE);
                        }
                        catch (LogisticException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    gui.getActions().repaint();
                    JOptionPane.showMessageDialog(gui, ModelEnviroment.getMessageResolver().resolveMessage("messages.tour.newCreatedTours", new Serializable[]{StringUtil.implode(newTourNumbers, ", ")}), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]), 1);
                    break;
                }
                default: {
                    for (TourModel tourModel : badTimeWindow) {
                        try {
                            tourCaller.calculateTour(tourModel, routeVehicleType, routeType, true, gui.getModelEnviroment(), null, true, SimpleTourRoutingContext.INSTANCE);
                        }
                        catch (LogisticException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        }
    }

    public OptimizationAlgorithmType getAlgorithmType() {
        return this.algorithmType;
    }
}

