/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.tour;

import de.datomino.peppergis.PeppergisConstants;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.MultiLineHeaderRenderer;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.DelivererModelUtil;
import de.datomino.peppergis.dto.lucene.SearchType;
import de.datomino.peppergis.dto.tour.DelivererSearchDto;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.gui.tour.TourSettingDialog;
import de.datomino.peppergis.util.StringComparator;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.ktde.util.datatypes.Holder;
import org.ktde.util.datatypes.Tupel;

public class DelivererSearchPane
extends JPanel {
    private static final long serialVersionUID = 3484281738249586424L;
    private static final int COL_BRANCH = 0;
    private static final int COL_DELIVERER_NUMBER = 1;
    private static final int COL_DELIVERER_NAME = 2;
    private static final int COL_STATUS = 3;
    private static final int COL_TOUR = 4;
    private Date date;
    private JTable delivererTable;
    private TourManagerCalendarGui tourManager;

    public DelivererSearchPane(Date date, TourManagerCalendarGui tourManager) {
        super(new BorderLayout());
        this.date = date;
        this.tourManager = tourManager;
        this.add(this.createSearchPane(), "North");
        this.add(this.createResultPane(), "Center");
    }

    private Component createSearchPane() {
        final DelivererSearchDto searchDto = new DelivererSearchDto(this.date);
        Holder<DelivererSearchDto> holder = new Holder<DelivererSearchDto>(searchDto);
        JPanel parameterPane = new JPanel(new SpringLayout());
        parameterPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.branch", new Serializable[0])));
        final JTextField branchName = ClientSwingUtil.createParameterTextField(50, null, true, "BranchName", holder, this);
        parameterPane.add(branchName);
        parameterPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.delivererNumber", new Serializable[0])));
        final JTextField delivererNumber = ClientSwingUtil.createParameterTextField(50, null, true, "DelivererNumber", holder, this);
        parameterPane.add(delivererNumber);
        parameterPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.delivererName", new Serializable[0])));
        final JTextField delivererName = ClientSwingUtil.createParameterTextField(50, null, true, "DelivererName", holder, this);
        parameterPane.add(delivererName);
        parameterPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.status", new Serializable[0])));
        final String[] statusItems = new String[3];
        statusItems[0] = null;
        statusItems[1] = ModelEnviroment.getMessageResolver().resolveMessage("de.datomino.peppergis.type.DelivererStatus.ACTIVE", new Serializable[0]);
        statusItems[1] = ModelEnviroment.getMessageResolver().resolveMessage("de.datomino.peppergis.type.DelivererStatus.INACTIVE", new Serializable[0]);
        final JComboBox<String> status = new JComboBox<String>(statusItems);
        status.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (e.getItem() == null) {
                        searchDto.setActive(null);
                    } else if (e.getItem().equals(statusItems[1])) {
                        searchDto.setActive(true);
                    } else if (e.getItem().equals(statusItems[2])) {
                        searchDto.setActive(false);
                    }
                }
            }
        });
        parameterPane.add(status);
        parameterPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.onlyWithoutTourOnDay", new Serializable[0])));
        final JCheckBox noTour = new JCheckBox(new AbstractAction(){
            private static final long serialVersionUID = 4421161470547075360L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                if (source.isSelected()) {
                    searchDto.setNoTour(true);
                } else {
                    searchDto.setNoTour(null);
                }
            }
        });
        parameterPane.add(noTour);
        SpringUtilities.makeCompactGrid(parameterPane, 5, 2, 5, 5, 5, 5);
        JPanel buttonPane = new JPanel(new FlowLayout(2));
        buttonPane.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.search", new Serializable[0])){
            private static final long serialVersionUID = -8988170048836442856L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DelivererSearchPane.this.loadDeliverers(searchDto);
            }
        }));
        buttonPane.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("buttons.clear", new Serializable[0])){
            private static final long serialVersionUID = 8961631333525924926L;

            @Override
            public void actionPerformed(ActionEvent e) {
                branchName.setText(null);
                delivererNumber.setText(null);
                delivererName.setText(null);
                status.setSelectedItem(null);
                noTour.setSelected(false);
            }
        }));
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)parameterPane, "Center");
        pane.add((Component)buttonPane, "South");
        return pane;
    }

    private Component createResultPane() {
        this.delivererTable = new JTable(new DelivererTableModel());
        this.delivererTable.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.delivererTable.getSelectionModel().setSelectionMode(0);
        this.delivererTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int selectedRow = DelivererSearchPane.this.delivererTable.getSelectedRow();
                    if (selectedRow < 0) {
                        return;
                    }
                    Object value = DelivererSearchPane.this.delivererTable.getValueAt(selectedRow, 1);
                    if (value != null && value instanceof TourModel) {
                        TourSettingDialog.createAndShowGUI(DelivererSearchPane.this.tourManager, (TourModel)value);
                    }
                }
            }
        });
        this.setTourTableStyle();
        return new JScrollPane(this.delivererTable);
    }

    private void loadDeliverers(DelivererSearchDto searchDto) {
        HashSet deliverers = new HashSet(this.tourManager.getDelivererGui().getAllDeliverers());
        Set<TourModel> dayTours = this.tourManager.getTourListGui().getPlannedToursInDay(searchDto.getDate());
        ArrayList<Tupel<DelivererModel, Object>> list = new ArrayList<Tupel<DelivererModel, Object>>();
        for (DelivererModel deliverer : deliverers) {
            BranchModel branch = deliverer.getBranch();
            if (!ClientFormUtil.matchs(branch == null ? null : branch.getName(), searchDto.getBranchName(), SearchType.WILD_CARD) || !ClientFormUtil.matchs(deliverer == null ? null : deliverer.getDelivererNumber(), searchDto.getDelivererNumber(), SearchType.WILD_CARD) || !ClientFormUtil.matchs(deliverer == null ? null : deliverer.getName(), searchDto.getDelivererName(), SearchType.WILD_CARD) || searchDto.getActive() != null && !(searchDto.getActive() & DelivererModelUtil.isDelivererActive(deliverer, searchDto.getDate()))) continue;
            TourModel found = null;
            for (TourModel tour : dayTours) {
                if (tour.getDeliverer() == null || !tour.getDeliverer().equals(deliverer)) continue;
                found = tour;
                break;
            }
            if (searchDto.getNoTour() != null && searchDto.getNoTour().booleanValue() && found != null) continue;
            list.add(new Tupel<DelivererModel, Object>(deliverer, found));
        }
        Collections.sort(list, new StringComparator<Tupel<DelivererModel, TourModel>>(true){

            @Override
            protected String getString(Tupel<DelivererModel, TourModel> o) {
                return o.getElement1().getDelivererNumber();
            }
        });
        DelivererTableModel dm = (DelivererTableModel)this.delivererTable.getModel();
        dm.deliverers = list;
        dm.fireTableDataChanged();
    }

    private void setTourTableStyle() {
        this.delivererTable.setRowHeight(40);
        this.delivererTable.setRowMargin(5);
        this.delivererTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.delivererTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.delivererTable.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.delivererTable.getColumnModel().getColumn(3).setPreferredWidth(100);
        this.delivererTable.getColumnModel().getColumn(4).setPreferredWidth(100);
        MultiLineHeaderRenderer headerHenderer = new MultiLineHeaderRenderer(){

            @Override
            protected int getCellHeight() {
                return 40;
            }
        };
        Enumeration<TableColumn> enumeration = this.delivererTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setHeaderRenderer(headerHenderer);
            tableColumn.setCellRenderer(new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    String s;
                    String string = s = value == null ? "" : value.toString();
                    if (value instanceof TourModel) {
                        s = ClientFormUtil.getStringDisplay(((TourModel)value).getName());
                    } else if (value instanceof DelivererModel) {
                        s = ClientFormUtil.getStringDisplay(((DelivererModel)value).getDelivererNumber());
                    }
                    JLabel label = new JLabel(s);
                    label.setOpaque(true);
                    label.setFont(table.getFont());
                    label.setBackground(isSelected ? PeppergisConstants.SELECTION_COLOR : Color.WHITE);
                    label.setBorder(BorderFactory.createEmptyBorder());
                    return label;
                }
            });
        }
    }

    public DelivererModel getSelectedDeliverer() {
        DelivererTableModel dm = (DelivererTableModel)this.delivererTable.getModel();
        int selectedRow = this.delivererTable.getSelectedRow();
        return selectedRow < 0 ? null : (DelivererModel)((Tupel)dm.deliverers.get(selectedRow)).getElement1();
    }

    private class DelivererTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = -1402586986645181404L;
        private List<Tupel<DelivererModel, TourModel>> deliverers = new ArrayList<Tupel<DelivererModel, TourModel>>();

        private DelivererTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.deliverers == null ? 0 : this.deliverers.size();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int columnIndex) {
            String header = "";
            switch (columnIndex) {
                case 0: {
                    header = ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.branch", new Serializable[0]);
                    break;
                }
                case 1: {
                    header = ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.delivererNumber", new Serializable[0]);
                    break;
                }
                case 2: {
                    header = ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.delivererName", new Serializable[0]);
                    break;
                }
                case 3: {
                    header = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.status", new Serializable[0]);
                    break;
                }
                case 4: {
                    header = ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.tour", new Serializable[0]);
                }
            }
            return header;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Tupel<DelivererModel, TourModel> tupel = this.deliverers.get(rowIndex);
            DelivererModel deliverer = tupel.getElement1();
            Object value = null;
            switch (columnIndex) {
                case 0: {
                    value = deliverer.getBranch() == null ? "" : ClientFormUtil.getStringDisplay(deliverer.getBranch().getName());
                    break;
                }
                case 1: {
                    value = deliverer;
                    break;
                }
                case 2: {
                    value = ClientFormUtil.getStringDisplay(deliverer.getName());
                    break;
                }
                case 3: {
                    value = DelivererSearchPane.this.date == null ? "" : ModelEnviroment.getMessageResolver().resolveMessageForEnum(DelivererModelUtil.getStatus(deliverer, DelivererSearchPane.this.date));
                    break;
                }
                case 4: {
                    value = tupel.getElement2();
                }
            }
            return value;
        }
    }
}

