/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.timeline;

import de.datomino.peppergis.PeppergisConstants;
import de.datomino.peppergis.client.gui.common.TimeDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.MultiLineHeaderRenderer;
import de.datomino.peppergis.client.manager.DelivererDialog;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.mobile.GeoTrackingModel;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.client.util.DelivererModelUtil;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.gui.timeline.TourTimeLinePane;
import de.datomino.peppergis.tourmanager.gui.tour.DelivererSearchDialog;
import de.datomino.peppergis.tourmanager.gui.tour.TourSearchDialog;
import de.datomino.peppergis.tourmanager.gui.tour.TourSettingDialog;
import de.datomino.peppergis.tourmanager.gui.tracking.TourTrackingResult;
import de.datomino.peppergis.tourmanager.handler.TourManagerJobManager;
import de.datomino.peppergis.tourmanager.handler.action.routing.ToursRoutingAction;
import de.datomino.peppergis.tourmanager.handler.job.RefreshTourTimeLineJob;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.util.StringComparator;
import de.datomino.util.swing.SwingUtils;
import de.datomino.util.time.TimeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TourTimeLineGui
extends JPanel {
    static final Logger LOGGER = LoggerFactory.getLogger(TourTimeLineGui.class);
    private static final long serialVersionUID = 3690519037909623185L;
    private static final int COL_TOUR = 0;
    private static final int COL_DELIVERER = 1;
    private static final int COL_DATE = 2;
    private TourManagerCalendarGui tourManager;
    protected JTable tourTable;
    private TourTimeLinePane timeLinePane;
    protected int timeBlockSize = 3600;
    protected int timeBlockCount = 12;
    private JFormattedTextField currentDate;
    protected Integer trackingIntervall = 900;
    protected boolean trackingTimeline = false;
    protected boolean serviceTimeline = false;
    private Set<TourModel> selectedTours = new HashSet<TourModel>();

    public TourTimeLineGui(TourManagerCalendarGui tourManager) {
        super(new BorderLayout());
        this.tourManager = tourManager;
        String blockSizeString = ModelEnviroment.getProperties().getProperty("tourmanager.timeLine.blockSize");
        String blockCountString = ModelEnviroment.getProperties().getProperty("tourmanager.timeLine.blockCount");
        try {
            this.timeBlockSize = Integer.parseInt(blockSizeString);
            this.timeBlockCount = Integer.parseInt(blockCountString);
        }
        catch (Exception e) {
            LOGGER.warn("Invalid time line properties - " + blockSizeString + "/" + blockCountString);
        }
        this.initialized();
    }

    private void initialized() {
        super.add(this.createNorthPane(), "North");
        JPanel centerPane = new JPanel(new BorderLayout());
        centerPane.add(this.createTourPane(), "West");
        Date now = new Date();
        centerPane.add(this.createTimeLinePane(now), "Center");
        super.add((Component)centerPane, "Center");
        this.loadToursInDate(now, true);
        String cron = "0 0/%% * 1/1 * ? *".replace("%%", "60");
        TourManagerJobManager.addJob("time line", RefreshTourTimeLineJob.class.getName(), cron, this.tourManager);
    }

    public List<TourTrackingResult> getTours() {
        TourTableModel dm = (TourTableModel)this.tourTable.getModel();
        return dm.tours;
    }

    public void repaintGui(boolean init, Date currentTime) {
        if (currentTime != null) {
            this.timeLinePane.setCurrentTime(currentTime);
        }
        this.loadToursInDate((Date)this.currentDate.getValue(), init);
    }

    private Component createNorthPane() {
        JPanel northPane = new JPanel(new FlowLayout(0));
        this.currentDate = new JFormattedTextField(new SimpleDateFormat(FormUtil.DATEFORMAT));
        this.currentDate.setValue(new Date());
        this.currentDate.setFont(UIManager.getFont("Label.font"));
        this.currentDate.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.currentDate.setEditable(false);
        this.currentDate.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Tupel<Date, Boolean> newTimeTupel;
                if (e.getClickCount() == 2 && e.getButton() == 1 && (newTimeTupel = TimeDialog.createAndShow((Date)TourTimeLineGui.this.currentDate.getValue(), FormUtil.DATEFORMAT, TourTimeLineGui.this.tourManager)).getElement2().booleanValue()) {
                    Date newTime = newTimeTupel.getElement1();
                    TourTimeLineGui.this.currentDate.setValue(newTime);
                    TourTimeLineGui.this.loadToursInDate(newTime, true);
                }
                super.mouseClicked(e);
            }
        });
        northPane.add(this.currentDate);
        northPane.add(new JLabel("        "));
        northPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.autoSync", new Serializable[0])));
        JComboBox<Integer> autoSync = new JComboBox<Integer>(new Integer[]{null, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60});
        autoSync.setSelectedItem(null);
        autoSync.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object selectedItem;
                if (e.getStateChange() == 1) {
                    TourManagerJobManager.pause("time line");
                    if (e.getItem() != null) {
                        String cron = "0 0/%% * 1/1 * ? *".replace("%%", e.getItem().toString());
                        TourManagerJobManager.modifyJobTime("time line", cron);
                        TourManagerJobManager.resumeJob("time line");
                    }
                } else if (e.getStateChange() == 2 && (selectedItem = ((JComboBox)e.getSource()).getSelectedItem()) == null) {
                    TourManagerJobManager.pause("time line");
                }
            }
        });
        northPane.add(autoSync);
        northPane.add(new JLabel("        "));
        northPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.timeInterval", new Serializable[0])));
        JComboBox<Integer> blockSize = new JComboBox<Integer>(new Integer[]{2, 5, 10, 15, 20, 30, 60});
        blockSize.setSelectedItem(15);
        blockSize.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    TourTimeLineGui.this.trackingIntervall = (Integer)e.getItem() * 60;
                    TourTimeLineGui.this.timeLinePane.setIncrement(TourTimeLineGui.this.trackingIntervall * 4);
                    TourTimeLineGui.this.timeLinePane.repaint(10L);
                }
            }
        });
        northPane.add(blockSize);
        northPane.add(this.createServiceSwitchPane());
        northPane.add(this.createTrackSwitchPane());
        return northPane;
    }

    private Component createServiceSwitchPane() {
        JPanel pane = new JPanel(new FlowLayout(0));
        final JPanel symbolPane = new JPanel(new FlowLayout(0));
        symbolPane.setVisible(false);
        JCheckBox active = new JCheckBox(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.timeLine.serviceActive", new Serializable[0])){
            private static final long serialVersionUID = 4029561533973840986L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    TourTimeLineGui.this.serviceTimeline = true;
                    symbolPane.setVisible(true);
                } else {
                    TourTimeLineGui.this.serviceTimeline = false;
                    symbolPane.setVisible(false);
                }
                TourTimeLineGui.this.timeLinePane.repaint(10L);
            }
        });
        JPanel activePane = new JPanel(new FlowLayout(0));
        activePane.add(active);
        pane.add(activePane);
        JLabel allDone = new JLabel("  ");
        allDone.setOpaque(true);
        allDone.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        allDone.setBackground(PeppergisConstants.SERVICE_ALL_DONE_COLOR);
        symbolPane.add(allDone);
        symbolPane.add(new JLabel("100%"));
        JLabel partiallyDone = new JLabel("  ");
        partiallyDone.setOpaque(true);
        partiallyDone.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        partiallyDone.setBackground(PeppergisConstants.SERVICE_PARTIALLY_DONE_COLOR);
        symbolPane.add(partiallyDone);
        symbolPane.add(new JLabel("50%"));
        JLabel notDone = new JLabel("  ");
        notDone.setOpaque(true);
        notDone.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        notDone.setBackground(PeppergisConstants.SERVICE_NOT_DONE_COLOR);
        symbolPane.add(notDone);
        symbolPane.add(new JLabel("0%"));
        JLabel none = new JLabel("  ");
        none.setOpaque(true);
        none.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        none.setBackground(PeppergisConstants.SERVICE_NONE_COLOR);
        symbolPane.add(none);
        symbolPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.noA", new Serializable[0])));
        JLabel openDone = new JLabel("  ");
        openDone.setOpaque(true);
        openDone.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        openDone.setBackground(PeppergisConstants.SERVICE_OPEN_COLOR);
        symbolPane.add(openDone);
        symbolPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("de.datomino.peppergis.type.NOT_DONE", new Serializable[0])));
        int height = 20;
        int width = 10;
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D big = bi.createGraphics();
        big.setColor(PeppergisConstants.SERVICE_CURRENT_COLOR);
        Line2D.Double p = new Line2D.Double();
        for (double x = (double)(-height); x < (double)width; x += (double)(height / 3)) {
            p.setLine(x, height, x + (double)height, 0.0);
            big.draw(p);
        }
        JLabel current = new JLabel();
        current.setOpaque(true);
        current.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        current.setBackground(PeppergisConstants.SERVICE_NONE_COLOR);
        current.setIcon(new ImageIcon(bi));
        symbolPane.add(current);
        symbolPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.service.status.current", new Serializable[0])));
        pane.add(symbolPane);
        return pane;
    }

    private Component createTrackSwitchPane() {
        JPanel pane = new JPanel(new FlowLayout(0));
        final JPanel symbolPane = new JPanel(new FlowLayout(0));
        symbolPane.setVisible(false);
        JCheckBox active = new JCheckBox(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.timeLine.trackActive", new Serializable[0])){
            private static final long serialVersionUID = -1998709927915737344L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    TourTimeLineGui.this.trackingTimeline = true;
                    symbolPane.setVisible(true);
                } else {
                    TourTimeLineGui.this.trackingTimeline = false;
                    symbolPane.setVisible(false);
                }
                TourTimeLineGui.this.timeLinePane.repaint(10L);
            }
        });
        JPanel activePane = new JPanel(new FlowLayout(0));
        activePane.add(active);
        pane.add(activePane);
        JLabel duly = new JLabel("    ");
        duly.setOpaque(true);
        duly.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        duly.setBackground(PeppergisConstants.TRACKING_DULY_COLOR);
        symbolPane.add(duly);
        symbolPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("buttons.ok", new Serializable[0])));
        symbolPane.add(new JLabel("  "));
        JLabel delayed = new JLabel("    ");
        delayed.setOpaque(true);
        delayed.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        delayed.setBackground(PeppergisConstants.TRACKING_DELAYED_COLOR);
        symbolPane.add(delayed);
        symbolPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tracking.delayed", new Serializable[0])));
        symbolPane.add(new JLabel("  "));
        JLabel missed = new JLabel("    ");
        missed.setOpaque(true);
        missed.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        missed.setForeground(PeppergisConstants.TRACKING_MISSED_COLOR);
        symbolPane.add(missed);
        symbolPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tracking.missed", new Serializable[0])));
        pane.add(symbolPane);
        return pane;
    }

    private Component createTourPane() {
        this.tourTable = new JTable(new TourTableModel());
        this.tourTable.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tourTable.getSelectionModel().setSelectionMode(0);
        this.tourTable.addMouseListener(new TourTableListener());
        this.setTourTableStyle();
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)this.tourTable.getTableHeader(), "North");
        pane.add((Component)this.tourTable, "Center");
        pane.add((Component)new JButton(new AbstractAction("+"){
            private static final long serialVersionUID = -1998709927915737344L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TourTimeLineGui.this.addTour();
            }
        }), "South");
        pane.setBorder(BorderFactory.createTitledBorder(""));
        return pane;
    }

    private void loadToursInDate(Date date, boolean init) {
        int sum = this.timeBlockSize * this.timeBlockCount;
        Date lastTime = TimeUtil.add(date, 13, sum + 86400);
        HashSet<Date> dates = new HashSet<Date>();
        Date d = TimeUtil.add(date, 5, -1);
        do {
            dates.add(d);
        } while (lastTime.after(d = TimeUtil.add(d, 5, 1)));
        Set<TourModel> tours = this.tourManager.getTourListGui().getPlannedToursInDay(dates.toArray(new Date[dates.size()]));
        ArrayList<7> filtered = new ArrayList<7>();
        for (TourModel tour : tours) {
            Date d1 = tour.getPlannedStartTime();
            Date d2 = TourModelUtil.getPlannedEndTime(tour);
            if (d1 == null || d2 == null || !TimeUtil.isSameDay(d1, date) && !TimeUtil.isSameDay(d2, date)) continue;
            TourTrackingResult result = new TourTrackingResult(tour, this.tourManager.getModelEnviroment()){

                @Override
                protected Date getCurrentTime() {
                    return TourTimeLineGui.this.timeLinePane.getCurrentTime();
                }
            };
            filtered.add(result);
        }
        Collections.sort(filtered, new StringComparator<TourTrackingResult>(true){

            @Override
            protected String getString(TourTrackingResult o) {
                return o.getTour().getName();
            }
        });
        TourTableModel dm = (TourTableModel)this.tourTable.getModel();
        dm.tours = filtered;
        dm.fireTableDataChanged();
        this.timeLinePane.setObjects(dm.tours, init ? TimeUtil.add(date, 13, -sum / 2) : null);
    }

    public void loadGeoTracks(Map<TourModel, List<GeoTrackingModel>> trackingMap) {
        TourTableModel dm = (TourTableModel)this.tourTable.getModel();
        for (TourTrackingResult r : dm.tours) {
            List<GeoTrackingModel> value;
            if (r.getTourTrackingList() == null || (value = trackingMap.get(r.getTour())) == null) continue;
            List<GeoTrackingModel> newList = r.getGeoTrackings();
            newList.addAll(value);
            r.createTourTrackingList(newList, r.getIntervall());
        }
    }

    private void addTour() {
        TourModel newTour = TourSearchDialog.createAndShow(this.tourManager);
        if (newTour != null) {
            TourTableModel dm = (TourTableModel)this.tourTable.getModel();
            TourTrackingResult newResult = new TourTrackingResult(newTour, this.tourManager.getModelEnviroment());
            dm.tours.add(newResult);
            dm.fireTableDataChanged();
            this.timeLinePane.setObjects(dm.tours, null);
            int newHours = 0;
            int newMinutes = 0;
            int newSeconds = 0;
            if (newTour.getPlannedStartTime() != null) {
                Calendar c = Calendar.getInstance();
                c.setTime(newTour.getPlannedStartTime());
                newHours = c.get(11);
                newMinutes = c.get(12);
                newSeconds = c.get(13);
            }
            Date newTime = TimeUtil.setTime((Date)this.currentDate.getValue(), newHours, newMinutes, newSeconds);
            HashSet<Object> c = new HashSet<Object>();
            c.add(newTour);
            this.timeLinePane.fireDragAndDrop(newTime, c);
            this.tourManager.getTourListGui().addNewTour(newTour);
            this.tourManager.getPlanTableGui().createPlanTable();
            this.repaint(10L);
        }
    }

    private void addDeliverer(TourModel tour) {
        DelivererModel newDeliverer = DelivererSearchDialog.createAndShow(tour.getPlannedStartTime(), this.tourManager);
        if (newDeliverer != null) {
            UndoManager undoManager = this.tourManager.getActions().getUndoManager();
            undoManager.startTransaction();
            tour.setDeliverer(newDeliverer);
            undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.message.tourUpdate", new Serializable[]{tour.getName()}));
            ((DefaultTableModel)this.tourTable.getModel()).fireTableDataChanged();
            this.repaint(10L);
        }
    }

    private void setTourTableStyle() {
        final TourTableModel tm = (TourTableModel)this.tourTable.getModel();
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>((TableModel)tm){

            @Override
            public void setSortKeys(List<? extends RowSorter.SortKey> sortKeys) {
                super.setSortKeys(sortKeys);
                ArrayList<TourTrackingResult> tours = new ArrayList<TourTrackingResult>();
                for (int row = 0; row < TourTimeLineGui.this.tourTable.getRowCount(); ++row) {
                    Object value = TourTimeLineGui.this.tourTable.getValueAt(row, 0);
                    if (value == null || !(value instanceof TourTrackingResult)) continue;
                    tours.add((TourTrackingResult)value);
                }
                TourTimeLineGui.this.timeLinePane.setObjects(tours, null);
            }
        };
        sorter.setStringConverter(new TableStringConverter(){

            @Override
            public String toString(TableModel model, int row, int column) {
                Object value = model.getValueAt(row, column);
                return value.toString();
            }
        });
        this.tourTable.setRowSorter((RowSorter<? extends TableModel>)sorter);
        this.tourTable.setRowHeight(40);
        this.tourTable.setRowMargin(5);
        this.tourTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.tourTable.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.tourTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        MultiLineHeaderRenderer headerHenderer = new MultiLineHeaderRenderer(){

            @Override
            protected int getCellHeight() {
                return 40;
            }
        };
        Enumeration<TableColumn> enumeration = this.tourTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setHeaderRenderer(headerHenderer);
            tableColumn.setCellRenderer(new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel label = new JLabel(TourTimeLineGui.this.tableObjectToString(value));
                    label.setOpaque(true);
                    label.setFont(table.getFont());
                    label.setBorder(BorderFactory.createEmptyBorder());
                    label.setHorizontalAlignment(0);
                    if (TourTimeLineGui.this.selectedTours.contains(((TourTrackingResult)tm.tours.get(row)).getTour())) {
                        label.setBackground(PeppergisConstants.SELECTION_COLOR);
                    }
                    return label;
                }
            });
        }
    }

    private void showPopupMenu(MouseEvent e) {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new ToursRoutingAction(this.tourManager, this.tourManager, this.tourManager.getBusyHandler()){
            private static final long serialVersionUID = 5779773124491159807L;

            @Override
            protected void repaintGui() {
                TourTimeLineGui.this.timeLinePane.clearCache(this.getTours());
            }

            @Override
            protected Collection<TourModel> getTours() {
                return TourTimeLineGui.this.selectedTours;
            }
        });
        popupMenu.show(this.tourTable, e.getX(), e.getY());
    }

    public void refresh(Collection<TourModel> tours) {
        this.timeLinePane.clearCache(tours);
        this.repaintGui(false, null);
    }

    private String tableObjectToString(Object value) {
        String s;
        String string = s = value == null ? "+" : value.toString();
        if (value instanceof TourModel) {
            s = ((TourModel)value).getName();
        } else if (value instanceof DelivererModel) {
            s = DelivererModelUtil.getDisplayString((DelivererModel)value);
        } else if (value instanceof Date) {
            s = TimeUtil.formatDate((Date)value, FormUtil.CLOCKFORMAT);
        }
        return s;
    }

    boolean updateStopSortOrder(Date time, StopModel stop) {
        StopModel s;
        Date arrival;
        boolean updated = false;
        TourModel tour = stop.getTourPart().getTour();
        StopModel pred = null;
        Iterator<StopModel> iterator = TourModelUtil.getAllStops(tour, true).iterator();
        while (iterator.hasNext() && ((arrival = (s = iterator.next()).getEstimatedTimeOfArrival()) == null || !arrival.after(time))) {
            pred = s;
        }
        if (pred == null) {
            TourPartModel firstPart = tour.getTourPartAt(0);
            if (!stop.equals(firstPart.getStopAt(0))) {
                firstPart.insertStop(stop, 0);
                updated = true;
            }
        } else {
            StopModel next;
            TourPartModel tourPart = pred.getTourPart();
            Integer predSortOrder = pred.getSortOrder();
            StopModel stopModel = next = predSortOrder == tourPart.countStops() - 1 ? null : tourPart.getStopAt(predSortOrder + 1);
            if (!stop.equals(pred) && !stop.equals(next)) {
                if (predSortOrder + 1 == tourPart.countStops()) {
                    tourPart.removeStop(stop);
                    tourPart.addStop(stop);
                } else {
                    tourPart.insertStop(stop, predSortOrder + 1);
                }
                updated = true;
            }
        }
        return updated;
    }

    private Component createTimeLinePane(Date currentTime) {
        this.timeLinePane = new TourTimeLinePane(this, currentTime, this.tourManager.getModelEnviroment());
        return this.timeLinePane;
    }

    public Set<TourModel> getSelectedTours() {
        return Collections.unmodifiableSet(this.selectedTours);
    }

    private class TourTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 6827017939562752476L;
        private List<TourTrackingResult> tours = new ArrayList<TourTrackingResult>();

        private TourTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.tours == null ? 0 : this.tours.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int columnIndex) {
            String header = "";
            switch (columnIndex) {
                case 0: {
                    header = ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.tour", new Serializable[0]);
                    break;
                }
                case 1: {
                    header = ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.deliverer", new Serializable[0]);
                    break;
                }
                case 2: {
                    header = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.time", new Serializable[0]);
                }
            }
            return header;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            TourTrackingResult tour = this.tours.get(rowIndex);
            Object value = null;
            switch (columnIndex) {
                case 0: {
                    value = tour.getTour();
                    break;
                }
                case 1: {
                    DelivererModel deliverer = tour.getTour().getDeliverer();
                    value = deliverer == null ? "+" : deliverer;
                    break;
                }
                case 2: {
                    Date date = tour.getTour().getPlannedStartTime();
                    value = date == null ? "" : date;
                }
            }
            return value;
        }
    }

    private class TourTableListener
    extends MouseAdapter {
        private TourTableListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int selectedRow = TourTimeLineGui.this.tourTable.rowAtPoint(e.getPoint());
            int selectedColumn = TourTimeLineGui.this.tourTable.columnAtPoint(e.getPoint());
            if (selectedRow < 0 || selectedColumn < 0) {
                return;
            }
            Object value = TourTimeLineGui.this.tourTable.getValueAt(selectedRow, selectedColumn);
            if (e.getButton() == 1) {
                if (value != null) {
                    if (e.getClickCount() == 1) {
                        if (value instanceof TourModel) {
                            if ((e.getModifiers() & 2) <= 0) {
                                TourTimeLineGui.this.selectedTours.clear();
                            }
                            if (TourTimeLineGui.this.selectedTours.contains(value)) {
                                TourTimeLineGui.this.selectedTours.remove(value);
                            } else {
                                TourTimeLineGui.this.selectedTours.add((TourModel)value);
                            }
                            TourTimeLineGui.this.tourTable.repaint(10L);
                        }
                    } else if (e.getClickCount() == 2) {
                        TourModel tour = (TourModel)TourTimeLineGui.this.tourTable.getValueAt(selectedRow, 0);
                        switch (selectedColumn) {
                            case 0: {
                                TourSettingDialog.createAndShowGUI(TourTimeLineGui.this.tourManager, tour);
                                break;
                            }
                            case 1: {
                                if (value instanceof String && value.toString().equals("+")) {
                                    TourTimeLineGui.this.addDeliverer(tour);
                                    break;
                                }
                                new DelivererDialog(SwingUtils.findWindowParent(TourTimeLineGui.this.tourManager), TourTimeLineGui.this.tourManager.getModelEnviroment(), (DelivererModel)value, false);
                                break;
                            }
                            case 2: {
                                Tupel<Date, Boolean> result = TimeDialog.createAndShow((Date)value, FormUtil.CLOCKFORMAT, TourTimeLineGui.this.tourManager);
                                if (!result.getElement2().booleanValue()) break;
                                HashSet<Object> c = new HashSet<Object>();
                                c.add(tour);
                                TourTimeLineGui.this.timeLinePane.fireDragAndDrop(result.getElement1(), c);
                            }
                        }
                    }
                }
            } else if (e.getButton() == 3) {
                if (TourTimeLineGui.this.selectedTours.isEmpty() && value != null && value instanceof TourModel) {
                    TourTimeLineGui.this.selectedTours.add((TourModel)value);
                }
                if (!TourTimeLineGui.this.selectedTours.isEmpty()) {
                    TourTimeLineGui.this.showPopupMenu(e);
                }
            }
        }
    }
}

