/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.stop.locationcapturing;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.mobile.AccountModel;
import de.datomino.peppergis.client.model.mobile.LocationCapturingModel;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.Wgs84Factory;

public class LocationCapturingTableModel
implements TableModel {
    private List<LocationCapturingModel> locationCapturings;
    private List<TableModelListener> tableModelListeners = new LinkedList<TableModelListener>();

    public LocationCapturingTableModel() {
        this.locationCapturings = Collections.emptyList();
    }

    @Override
    public int getRowCount() {
        return this.locationCapturings.size();
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String key = null;
        switch (columnIndex) {
            case 0: {
                key = "address.postcode";
                break;
            }
            case 1: {
                key = "address.city";
                break;
            }
            case 2: {
                key = "address.district";
                break;
            }
            case 3: {
                key = "address.street";
                break;
            }
            case 4: {
                key = "address.housenumber";
                break;
            }
            case 5: {
                key = "address.housenumberExt";
                break;
            }
            case 6: {
                key = "gis.coordinate.longitude";
                break;
            }
            case 7: {
                key = "gis.coordinate.latitude";
                break;
            }
            case 8: {
                key = "gui.deliverer.deliverer";
            }
        }
        return ModelEnviroment.getMessageResolver().resolveMessage(key, new Serializable[0]);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 6 || columnIndex == 7) {
            return Double.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        LocationCapturingModel locationCapturingModel = this.locationCapturings.get(rowIndex);
        Object value = null;
        switch (columnIndex) {
            case 0: {
                value = locationCapturingModel.getPostcode();
                break;
            }
            case 1: {
                value = locationCapturingModel.getCity();
                break;
            }
            case 2: {
                value = locationCapturingModel.getDistrict();
                break;
            }
            case 3: {
                value = locationCapturingModel.getStreet();
                break;
            }
            case 4: {
                value = locationCapturingModel.getHousenumber();
                break;
            }
            case 5: {
                value = locationCapturingModel.getHousenumberExtension();
                break;
            }
            case 6: {
                Coordinate coordinateX = locationCapturingModel.getGeoLocation().getCoordinate();
                coordinateX = Wgs84Factory.INSTANCE.createCoordinate(coordinateX);
                value = coordinateX.getX();
                break;
            }
            case 7: {
                Coordinate coordinateY = locationCapturingModel.getGeoLocation().getCoordinate();
                coordinateY = Wgs84Factory.INSTANCE.createCoordinate(coordinateY);
                value = coordinateY.getY();
                break;
            }
            case 8: {
                AccountModel account = locationCapturingModel.getAccount();
                DelivererModel deliverer = null;
                if (account != null) {
                    deliverer = account.getDeliverer();
                }
                value = deliverer != null ? deliverer.getDelivererNumber() + " - " + deliverer.getName() : "";
            }
        }
        return value;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.tableModelListeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.tableModelListeners.remove(l);
    }

    public void fireTableModelChanged(TableModelEvent e) {
        for (TableModelListener tableModelListener : this.tableModelListeners) {
            tableModelListener.tableChanged(e);
        }
    }

    public void setLocationCapturings(List<LocationCapturingModel> locationCapturings) {
        this.locationCapturings = locationCapturings;
        this.fireTableModelChanged(new TableModelEvent(this));
    }

    public LocationCapturingModel getLocationCapturingAt(int index) {
        return this.locationCapturings.get(index);
    }

    public void removeElementAt(int index) {
        this.locationCapturings.remove(index);
        this.fireTableModelChanged(new TableModelEvent(this, index, index, -1, -1));
    }
}

