/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.stop;

import de.datomino.peppergis.client.gui.AbstractFilterTable;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.common.EnumItem;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.AbstractTableRenderer;
import de.datomino.peppergis.client.model.tour.ServiceTicketStopRelationModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TimeWindowModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.common.PrimitiveUtil;
import de.datomino.util.comparator.ComparatorUtil;
import de.datomino.util.message.MessageResolver;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableColumn;
import org.apache.commons.collections.ComparatorUtils;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class UnsortedStopPane
extends JPanel {
    private static final long serialVersionUID = 1664742272421701315L;
    private static final int COLUMN_COUNT = 12;
    private AbstractFilterTable<StopModel> stopTable;
    private TourManagerCalendarGui tourManagerCalendarGui;
    private EnumComboBox<Sort> sortComboBox;
    private JSpinner startDate;
    private JSpinner endDate;
    private JTextField startPostcode;
    private JTextField endPostcode;
    private Component parent;

    public UnsortedStopPane(TourManagerCalendarGui tourManagerCalendarGui, Component parent) {
        super(new BorderLayout());
        this.tourManagerCalendarGui = tourManagerCalendarGui;
        this.parent = parent;
        this.initialize();
    }

    private void initialize() {
        this.stopTable = new UnsortedStopTable(this.tourManagerCalendarGui.getUnsortedStops(), 12, null){
            private static final long serialVersionUID = -8056432951620985317L;

            @Override
            public Class<?> getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return Integer.class;
                    }
                }
                return super.getColumnClass(column);
            }
        };
        JScrollPane stopListScrollPane = new JScrollPane(this.stopTable);
        this.add((Component)stopListScrollPane, "Center");
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel orderPanel = new JPanel(new SpringLayout());
        orderPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.sort", new Serializable[0])));
        this.sortComboBox = new EnumComboBox<Sort>(Sort.class, false);
        this.sortComboBox.addActionListener(new SortActionListener());
        orderPanel.add(this.sortComboBox);
        SpringUtilities.makeCompactGrid(orderPanel, 1, 2, 2, 2, 2, 2);
        JPanel dateFilterPanel = new JPanel(new SpringLayout());
        dateFilterPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("gui.date.date", "messages.default.from"), new String[0])));
        FilterChangedListener filterChangedListener = new FilterChangedListener();
        this.startDate = new JSpinner(new SpinnerDateModel(new Date(0L), null, null, 5));
        this.startDate.setEditor(new JSpinner.DateEditor(this.startDate, ClientFormUtil.DATEFORMAT));
        this.startDate.addChangeListener(filterChangedListener);
        dateFilterPanel.add(this.startDate);
        dateFilterPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.to", new Serializable[0])));
        this.endDate = new JSpinner(new SpinnerDateModel(new Date(), null, null, 5));
        this.endDate.setEditor(new JSpinner.DateEditor(this.endDate, ClientFormUtil.DATEFORMAT));
        this.endDate.addChangeListener(filterChangedListener);
        dateFilterPanel.add(this.endDate);
        SpringUtilities.makeCompactGrid(dateFilterPanel, 1, 4, 2, 2, 2, 2);
        JPanel plzFilterPanel = new JPanel(new SpringLayout());
        TextFilterChangedListener textFilterChangedListener = new TextFilterChangedListener();
        plzFilterPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("address.postcode", "messages.default.from"), new String[0])));
        this.startPostcode = new JTextField(3);
        this.startPostcode.getDocument().addDocumentListener(textFilterChangedListener);
        plzFilterPanel.add(this.startPostcode);
        plzFilterPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.to", new Serializable[0])));
        this.endPostcode = new JTextField(3);
        this.endPostcode.getDocument().addDocumentListener(textFilterChangedListener);
        plzFilterPanel.add(this.endPostcode);
        SpringUtilities.makeCompactGrid(plzFilterPanel, 1, 4, 2, 2, 2, 2);
        JPanel filterPanel = new JPanel(new FlowLayout());
        filterPanel.add(dateFilterPanel);
        filterPanel.add(plzFilterPanel);
        filterPanel.add(orderPanel);
        topPanel.add((Component)filterPanel, "West");
        this.add((Component)topPanel, "North");
    }

    private boolean inUnsortedStopFilter(StopModel stop) {
        boolean b = true;
        if (this.startDate != null && this.endDate != null) {
            b = stop.isTimeWindowsEmpty();
            Date lower = (Date)this.startDate.getValue();
            Date upper = (Date)this.endDate.getValue();
            for (TimeWindowModel timeWindowModel : stop.iterableTimeWindows()) {
                if (timeWindowModel == null) continue;
                Date lowerT = timeWindowModel.getStartTime();
                Date upperT = timeWindowModel.getEndTime();
                if (lowerT.compareTo(lower) < 0 || upperT.compareTo(upper) > 0) continue;
                b = true;
            }
        }
        if (b && this.startPostcode != null && this.endPostcode != null) {
            String startPostcode = StringUtil.emptyToNull(this.startPostcode.getText());
            String endPostcode = StringUtil.emptyToNull(this.endPostcode.getText());
            if (startPostcode != null || endPostcode != null) {
                String postcode;
                LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(stop.getLocation());
                String string = postcode = locationWrapper == null ? null : locationWrapper.getPostcode();
                if (postcode != null && (startPostcode != null && startPostcode.compareTo(postcode.substring(0, Math.min(postcode.length(), startPostcode.length()))) > 0 || endPostcode != null && endPostcode.compareTo(postcode.substring(0, Math.min(postcode.length(), endPostcode.length()))) < 0)) {
                    b = false;
                }
            }
        }
        return b;
    }

    public void addStop(StopModel stop) {
        stop.setEstimatedTimeOfArrival(null);
        stop.setStreetMileageMetersFromTourStart(0);
        this.tourManagerCalendarGui.getUnsortedStops().add(stop);
        this.stopTable.setOs(this.tourManagerCalendarGui.getUnsortedStops());
        if (this.stopTable.inColumnFilters(stop)) {
            this.stopTable.reload(false);
        }
    }

    public void removeStop() {
        this.tourManagerCalendarGui.getUnsortedStops().remove(this.getSelectedStop());
        this.refreshUnsortedStops();
    }

    public StopModel getSelectedStop() {
        int selectedRow = this.stopTable.getSelectedRow();
        if (selectedRow < 0 || this.stopTable.getModel().getRowCount() <= selectedRow) {
            return null;
        }
        Tupel value = (Tupel)this.stopTable.getModel().getValueAt(this.stopTable.convertRowIndexToModel(selectedRow), 0);
        return (StopModel)value.getElement2();
    }

    public void refreshUnsortedStops() {
        this.stopTable.setOs(this.tourManagerCalendarGui.getUnsortedStops());
        this.stopTable.reload(false);
    }

    public AbstractFilterTable<StopModel> getStopTable() {
        return this.stopTable;
    }

    public JPanel getPanelWithTitel() {
        return ClientSwingUtil.createPanelForComponent(this, ModelEnviroment.getMessageResolver().resolveMessage("gui.location.unsortedLocation", new Serializable[0]));
    }

    private class UnsortedStopTable
    extends AbstractFilterTable<StopModel> {
        private static final long serialVersionUID = 7933651459598379217L;

        private UnsortedStopTable(Collection<StopModel> os, int columnCount, Collection<Integer> columnWithoutFilter) {
            super(os, columnCount, columnWithoutFilter, UnsortedStopPane.this.parent);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected Object[] createRowData(StopModel o, int row) {
            Object[] rowData = new Object[12];
            try {
                void var9_13;
                rowData[0] = new Tupel<String, StopModel>(String.valueOf(row + 1), o);
                rowData[1] = StopModelUtil.getStopDisplay(o, false);
                LocationWrapper wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(o.getLocation());
                rowData[2] = wrapper == null ? "" : wrapper.getCountry().getIso3166_2();
                rowData[3] = wrapper == null ? "" : wrapper.getPostcode();
                rowData[4] = wrapper == null ? "" : wrapper.getCity();
                rowData[5] = wrapper == null ? "" : wrapper.getDistrict();
                rowData[6] = wrapper == null ? "" : wrapper.getStreet();
                rowData[7] = wrapper == null ? "" : wrapper.getHousenumber();
                rowData[8] = wrapper == null ? "" : wrapper.getHousenumberExtension();
                SimpleDateFormat dateFormat = new SimpleDateFormat(FormUtil.DATEFORMAT);
                Date dateFrom = null;
                Date dateTo = null;
                for (TimeWindowModel timeWindowModel : o.iterableTimeWindows()) {
                    if (dateFrom == null || dateFrom.after(timeWindowModel.getStartTime())) {
                        dateFrom = timeWindowModel.getStartTime();
                    }
                    if (dateTo != null && !dateTo.before(timeWindowModel.getEndTime())) continue;
                    dateTo = timeWindowModel.getEndTime();
                }
                rowData[9] = dateFrom == null ? "" : dateFormat.format(dateFrom);
                rowData[10] = dateTo == null ? "" : dateFormat.format(dateTo);
                HashSet<String> serviceNumbers = new HashSet<String>();
                for (ServiceTicketStopRelationModel rel : o.iterableServiceStopRelations()) {
                    serviceNumbers.add(rel.getServiceTicket().getService().getServiceNumber());
                }
                String string = "";
                for (String s : serviceNumbers) {
                    void var9_15;
                    if (!StringUtil.isBlank((String)var9_13)) {
                        String string2 = (String)var9_13 + "/";
                    }
                    String string3 = (String)var9_15 + s;
                }
                rowData[11] = var9_13;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return rowData;
        }

        @Override
        protected String[] createColumnHeader() {
            String[] columnHeader = new String[this.columnCount];
            columnHeader[0] = " \n#\n \n \n";
            MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
            columnHeader[1] = this.getFormatedString(messageResolver.resolveMessage("gui.stop.stops", new Serializable[0]));
            columnHeader[2] = this.getFormatedString(messageResolver.resolveMessage("address.country", new Serializable[0]));
            columnHeader[3] = this.getFormatedString(messageResolver.resolveMessage("address.postcode", new Serializable[0]));
            columnHeader[4] = this.getFormatedString(messageResolver.resolveMessage("address.city", new Serializable[0]));
            columnHeader[5] = this.getFormatedString(messageResolver.resolveMessage("address.district", new Serializable[0]));
            columnHeader[6] = this.getFormatedString(messageResolver.resolveMessage("address.street", new Serializable[0]));
            columnHeader[7] = this.getFormatedString(messageResolver.resolveMessage("address.housenumber", new Serializable[0]));
            columnHeader[8] = this.getFormatedString(messageResolver.resolveMessage("address.housenumberExt", new Serializable[0]));
            columnHeader[9] = this.getFormatedString(messageResolver.resolveMessage("messages.default.dateFrom", new Serializable[0]));
            columnHeader[10] = this.getFormatedString(messageResolver.resolveMessage("messages.default.dateTo", new Serializable[0]));
            columnHeader[11] = this.getFormatedString(messageResolver.resolveMessage("gui.stop.client.name", new Serializable[0]));
            return columnHeader;
        }

        private String getFormatedString(String string) {
            return " \n" + string + "\n \n";
        }

        @Override
        protected void setTableStyle() {
            this.setCellSelectionEnabled(false);
            this.setRowHeight(40);
            this.setRowMargin(5);
            this.getColumnModel().getColumn(0).setPreferredWidth(20);
            this.getColumnModel().getColumn(1).setPreferredWidth(50);
            this.getColumnModel().getColumn(2).setPreferredWidth(15);
            this.getColumnModel().getColumn(3).setPreferredWidth(50);
            this.getColumnModel().getColumn(4).setPreferredWidth(100);
            this.getColumnModel().getColumn(5).setPreferredWidth(100);
            this.getColumnModel().getColumn(6).setPreferredWidth(200);
            this.getColumnModel().getColumn(7).setPreferredWidth(50);
            this.getColumnModel().getColumn(8).setPreferredWidth(50);
            this.getColumnModel().getColumn(9).setPreferredWidth(50);
            this.getColumnModel().getColumn(10).setPreferredWidth(50);
            this.getColumnModel().getColumn(11).setPreferredWidth(50);
            AbstractTableRenderer cellRenderer = new AbstractTableRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel label = new JLabel(value == null ? "" : value.toString());
                    if (column == 0 && value instanceof Tupel) {
                        label.setText(((String)((Tupel)value).getElement1()).toString());
                    }
                    label.setFont(table.getFont());
                    label.setHorizontalAlignment(0);
                    label.setBorder(BorderFactory.createEmptyBorder());
                    return label;
                }
            };
            Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn tableColumn = enumeration.nextElement();
                tableColumn.setCellRenderer(cellRenderer);
            }
            super.setTableStyle();
        }

        @Override
        public boolean inColumnFilters(StopModel o) {
            boolean b = super.inColumnFilters(o);
            return b ? UnsortedStopPane.this.inUnsortedStopFilter(o) : b;
        }

        @Override
        protected int compareO(StopModel o1, StopModel o2) {
            EnumItem item = UnsortedStopPane.this.sortComboBox == null ? null : (EnumItem)UnsortedStopPane.this.sortComboBox.getSelectedItem();
            Sort sort = Sort.NAME;
            if (item != null) {
                sort = (Sort)((Object)item.getT());
            }
            int i = 0;
            switch (sort) {
                case NAME: {
                    i = this.compareName(o1, o2);
                    break;
                }
                case ADDRESS: {
                    LocationWrapper locationWrapper1 = LocationWrapperFactory.INSTANCE.createLocationWrapper(o1.getLocation());
                    LocationWrapper locationWrapper2 = LocationWrapperFactory.INSTANCE.createLocationWrapper(o2.getLocation());
                    if (locationWrapper1 == null) {
                        return -1;
                    }
                    if (locationWrapper2 == null) {
                        return 1;
                    }
                    i = ComparatorUtil.compareMultipleValueChain(new ComparatorUtil.CompareUnit<String>(ComparatorUtils.naturalComparator(), StringUtil.nullToEmpty(locationWrapper1.getCountry() == null ? "" : locationWrapper1.getCountry().getIso3166_2()), StringUtil.nullToEmpty(locationWrapper2.getCountry() == null ? "" : locationWrapper2.getCountry().getIso3166_2())), new ComparatorUtil.CompareUnit<String>(ComparatorUtils.naturalComparator(), StringUtil.nullToEmpty(locationWrapper1.getPostcode()), StringUtil.nullToEmpty(locationWrapper2.getPostcode())), new ComparatorUtil.CompareUnit<String>(ComparatorUtils.naturalComparator(), StringUtil.nullToEmpty(locationWrapper1.getCity()), StringUtil.nullToEmpty(locationWrapper2.getCity())), new ComparatorUtil.CompareUnit<String>(ComparatorUtils.naturalComparator(), StringUtil.nullToEmpty(locationWrapper1.getDistrict()), StringUtil.nullToEmpty(locationWrapper2.getDistrict())), new ComparatorUtil.CompareUnit<String>(ComparatorUtils.naturalComparator(), StringUtil.nullToEmpty(locationWrapper1.getStreet()), StringUtil.nullToEmpty(locationWrapper2.getStreet())), new ComparatorUtil.CompareUnit<Integer>(ComparatorUtils.naturalComparator(), PrimitiveUtil.nullToZero(locationWrapper1.getHousenumber()), PrimitiveUtil.nullToZero(locationWrapper2.getHousenumber())), new ComparatorUtil.CompareUnit<String>(ComparatorUtils.naturalComparator(), StringUtil.nullToEmpty(locationWrapper1.getHousenumberExtension()), StringUtil.nullToEmpty(locationWrapper2.getHousenumberExtension())));
                    i = i == 0 ? this.compareName(o1, o2) : i;
                }
            }
            return i;
        }

        private int compareName(StopModel o1, StopModel o2) {
            return StopModelUtil.getStopDisplay(o1, false).compareTo(StopModelUtil.getStopDisplay(o2, false));
        }

        @Override
        protected String getValueString(Object value, int row, int column) {
            String s = super.getValueString(value, row, column);
            if (column == 0) {
                Tupel tupel = (Tupel)value;
                s = String.valueOf(tupel.getElement1());
            }
            return s;
        }

        @Override
        protected Comparator<?> getRowSorterComparator(int column) {
            switch (column) {
                case 0: {
                    return new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            return Integer.parseInt(o1) - Integer.parseInt(o2);
                        }
                    };
                }
            }
            return super.getRowSorterComparator(column);
        }
    }

    private class TextFilterChangedListener
    implements DocumentListener {
        private TextFilterChangedListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            UnsortedStopPane.this.stopTable.reload(false);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            UnsortedStopPane.this.stopTable.reload(false);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            UnsortedStopPane.this.stopTable.reload(false);
        }
    }

    private class FilterChangedListener
    implements ChangeListener {
        private FilterChangedListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            UnsortedStopPane.this.stopTable.reload(false);
        }
    }

    private class SortActionListener
    implements ActionListener {
        private SortActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UnsortedStopPane.this.stopTable.reload(false);
        }
    }

    private static enum Sort {
        NAME,
        ADDRESS;

    }
}

