/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.stop;

import de.datomino.peppergis.client.gui.Pausable;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.MultiLineHeaderRenderer;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.client.model.base.ServiceTicketModel;
import de.datomino.peppergis.client.model.tour.ServiceTicketStopRelationModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TimeWindowModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.tourmanager.gui.stop.StopTableCellRenderer;
import de.datomino.peppergis.tourmanager.gui.stop.StopTableModel;
import de.datomino.peppergis.tourmanager.gui.stop.StopTableTimeWindowCellEditor;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.apache.commons.lang.time.DateUtils;
import org.ktde.util.datatypes.Tupel;

public class StopTablePanel {
    private static int TABLECOLCOUNT = 8;
    private TourModel tour;
    private StopTableModel stopTableModel;
    private JTable stopTable;
    private boolean editable;
    private List<Tupel<Integer, Integer>> invalidEstimatedTime;
    private ModelEnviroment modelEnviroment;
    private Set<StopModel> selectedStops = new HashSet<StopModel>();
    private Pausable pausableDialog;

    public StopTablePanel(TourModel tour, boolean editable, ModelEnviroment modelEnviroment) {
        this.modelEnviroment = modelEnviroment;
        this.tour = tour;
        this.editable = editable;
        this.stopTableModel = new StopTableModel(this, this.tour);
        this.stopTableModel.setDataVector(this.createDataVector(), this.createColumnHeader());
        this.stopTable = new JTable(this.stopTableModel);
        this.setTourTableStyle();
    }

    private void setTourTableStyle() {
        this.stopTable.setCellSelectionEnabled(false);
        this.stopTable.setRowHeight(40);
        this.stopTable.setRowMargin(5);
        this.stopTable.getColumnModel().getColumn(0).setPreferredWidth(80);
        this.stopTable.getColumnModel().getColumn(1).setPreferredWidth(130);
        this.stopTable.getColumnModel().getColumn(2).setPreferredWidth(140);
        this.stopTable.getColumnModel().getColumn(3).setPreferredWidth(200);
        this.stopTable.getColumnModel().getColumn(4).setPreferredWidth(400);
        this.stopTable.getColumnModel().getColumn(5).setPreferredWidth(250);
        this.stopTable.getColumnModel().getColumn(6).setPreferredWidth(172);
        this.stopTable.getColumnModel().getColumn(7).setPreferredWidth(100);
        StopTableCellRenderer cellRenderer = new StopTableCellRenderer(this);
        MultiLineHeaderRenderer headerHenderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = this.stopTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setHeaderRenderer(headerHenderer);
            tableColumn.setCellRenderer(cellRenderer);
        }
        if (this.editable) {
            this.createTimeWindwsComboBox();
        }
    }

    private String[] createColumnHeader() {
        String[] columnHeader = new String[TABLECOLCOUNT];
        columnHeader[0] = " \n#\n \n";
        columnHeader[1] = this.getFormatedString(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.line", new Serializable[0]));
        columnHeader[2] = this.getFormatedString(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.durationOnLocation", new Serializable[0]) + "(hh:mm:ss)");
        columnHeader[3] = ModelEnviroment.getProperties().getProperty("stopName") != null && ModelEnviroment.getProperties().getProperty("stopName").equals("stopName") ? this.getFormatedString("Name") : this.getFormatedString("Kundenname");
        columnHeader[4] = this.getFormatedString(ModelEnviroment.getMessageResolver().resolveMessage("address.address", new Serializable[0]));
        columnHeader[5] = this.getFormatedString(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.timewindow", new Serializable[0]));
        columnHeader[6] = this.getFormatedString(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.estimatedTime", new Serializable[0]));
        columnHeader[7] = this.getFormatedString(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.sortOrder", new Serializable[0]));
        return columnHeader;
    }

    public JScrollPane createScrollPane() {
        JScrollPane scrollPane = new JScrollPane(this.stopTable);
        return scrollPane;
    }

    public void updateStopTable() {
        this.stopTableModel.setDataVector(this.createDataVector(), this.createColumnHeader());
        this.setTourTableStyle();
    }

    public void createTimeWindwsComboBox() {
        StopTableTimeWindowCellEditor stopTableTimeWindowCellEditor = new StopTableTimeWindowCellEditor(this.stopTable);
        int rowIndex = 0;
        for (int i = 0; i < this.tour.countTourParts(); ++i) {
            TourPartModel tourPartModel = this.tour.getTourPartAt(i);
            if (this.tour.countTourParts() != 1) {
                ++rowIndex;
            }
            for (int j = 0; j < tourPartModel.countStops(); ++j) {
                StopModel stopModel = tourPartModel.getStopAt(j);
                if (stopModel.getPoi() != null) {
                    ++rowIndex;
                    continue;
                }
                stopTableTimeWindowCellEditor.setEditorAt(rowIndex, stopModel);
                if (!stopModel.isTimeWindowsEmpty()) {
                    this.stopTableModel.setValueAt(StopModelUtil.timeWindowToString(stopModel.iterateTimeWindows().next()), rowIndex, 5);
                }
                ++rowIndex;
            }
        }
        this.stopTable.getColumnModel().getColumn(5).setCellEditor(stopTableTimeWindowCellEditor);
    }

    private String getFormatedString(String string) {
        return " \n" + string + "\n \n";
    }

    private Object[][] createDataVector() {
        this.invalidEstimatedTime = new ArrayList<Tupel<Integer, Integer>>();
        Object[][] dataVector = this.tour.countTourParts() == 1 ? new Object[TourModelUtil.countStopsOfTour(this.tour)][TABLECOLCOUNT] : new Object[TourModelUtil.countStopsOfTour(this.tour) + this.tour.countTourParts()][TABLECOLCOUNT];
        int index = 0;
        Iterator<TourPartModel> tourPartIter = this.tour.iterateTourParts();
        while (tourPartIter.hasNext()) {
            TourPartModel tourPart = tourPartIter.next();
            if (this.tour.countTourParts() != 1) {
                dataVector[index] = this.tourPartToRowData(tourPart);
                ++index;
            }
            Iterator<StopModel> stopIter = tourPart.iterateStops();
            int idIndex = 1;
            while (stopIter.hasNext()) {
                dataVector[index] = this.stopToRowData(stopIter.next(), idIndex++, index);
                ++index;
            }
        }
        return dataVector;
    }

    public void removeStopInTable(int selRow) {
        StopModel selStop = this.stopTableModel.getStopAt(selRow);
        this.stopTableModel.removeRow(selRow);
        this.stopTableModel.removeStopModel(selStop, selRow);
    }

    public void addStopRowInTable(StopModel selStop, Point dropPoint) {
        Point pointTable = this.stopTable.getParent().getLocationOnScreen();
        Point pointInTable = new Point((int)(dropPoint.getX() - pointTable.getX()), (int)(dropPoint.getY() - pointTable.getY()));
        int rowAtPoint = this.stopTable.rowAtPoint(pointInTable);
        Integer tourPartSortOrder = rowAtPoint < 0 ? null : this.stopTableModel.getPositionInTourParts(rowAtPoint).getElement1();
        this.stopTableModel.addStopModel(selStop, tourPartSortOrder == null ? 0 : tourPartSortOrder);
        this.updateStopTable();
    }

    private Object[] tourPartToRowData(TourPartModel tourPartModel) {
        Object[] rowData = new String[TABLECOLCOUNT];
        rowData[0] = tourPartModel.getName() == null ? ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.part", new Serializable[0]) : tourPartModel.getName();
        rowData[1] = "";
        rowData[2] = "";
        rowData[3] = "";
        rowData[4] = "";
        rowData[5] = "";
        rowData[6] = "";
        rowData[7] = "";
        return rowData;
    }

    private Object[] stopToRowData(StopModel stopModel, int id, int row) {
        Object[] rowData = new Object[TABLECOLCOUNT];
        if (stopModel == null) {
            return rowData;
        }
        rowData[0] = new Tupel<String, StopModel>(String.valueOf(id), stopModel);
        rowData[1] = ClientFormUtil.getNumberString(stopModel.getStreetMileageMetersFromTourStart());
        rowData[2] = ClientFormUtil.getSecondTimeString(stopModel.getEstimatedDurationSeconds());
        if (ModelEnviroment.getProperties().getProperty("stopName") != null && ModelEnviroment.getProperties().getProperty("stopName").equals("stopName")) {
            rowData[3] = stopModel.getName();
        } else {
            CustomerModel customer = null;
            Iterator<ServiceTicketStopRelationModel> iter = stopModel.iterateServiceStopRelations();
            while (iter.hasNext()) {
                ServiceTicketModel serviceTicket = iter.next().getServiceTicket();
                customer = serviceTicket == null ? null : serviceTicket.getCustomer();
            }
            rowData[3] = customer == null ? "" : customer.getName();
        }
        rowData[4] = LocationModelUtil.getAddressString(stopModel.getLocation());
        if (stopModel.getPoi() != null) {
            rowData[5] = "";
        } else {
            TimeWindowModel timeWindowModel = StopModelUtil.getCurrentTimeWindow(stopModel);
            Object object = rowData[5] = timeWindowModel == null ? "" : StopModelUtil.timeWindowToString(timeWindowModel);
        }
        if (stopModel.getEstimatedTimeOfArrival() == null) {
            rowData[6] = "";
        } else {
            Integer duration = stopModel.getEstimatedDurationSeconds();
            if (duration == null) {
                duration = 0;
            }
            Date leaveTime = DateUtils.addSeconds(stopModel.getEstimatedTimeOfArrival(), duration);
            rowData[6] = String.valueOf(ClientFormUtil.dateToString(stopModel.getEstimatedTimeOfArrival()) + " - " + ClientFormUtil.dateToString(leaveTime));
            if (StopModelUtil.hasBadTimeWindow(stopModel)) {
                this.invalidEstimatedTime.add(new Tupel<Integer, Integer>(row, 6));
            }
        }
        rowData[7] = ClientFormUtil.getNumberString(stopModel.getImportOrder());
        return rowData;
    }

    public StopModel getSelStopModel() {
        int selRow = this.stopTable.getSelectedRow();
        if (selRow > -1 && selRow < this.stopTableModel.getRowCount()) {
            return this.getStopModelInTableAt(selRow);
        }
        return null;
    }

    public int getSelectedRow() {
        return this.stopTable.getSelectedRow();
    }

    public StopModel getStopModelInTableAt(int selRow) {
        return this.stopTableModel.getStopAt(selRow);
    }

    public boolean isInTable(Point location) {
        Point pointTable = this.stopTable.getParent().getLocationOnScreen();
        return location.x > pointTable.x && location.x < pointTable.x + this.stopTable.getParent().getWidth() && location.y > pointTable.y && location.y < pointTable.y + this.stopTable.getParent().getHeight();
    }

    public TourModel getTour() {
        return this.tour;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public JTable getStopTable() {
        return this.stopTable;
    }

    public List<Tupel<Integer, Integer>> getInvalidEstimatedTime() {
        return this.invalidEstimatedTime;
    }

    public ModelEnviroment getModelEnviroment() {
        return this.modelEnviroment;
    }

    public Pausable getPausableDialog() {
        return this.pausableDialog;
    }

    public void setPausableDialog(Pausable pausableDialog) {
        this.pausableDialog = pausableDialog;
    }

    public void repaint(long l) {
        this.stopTable.repaint(l);
    }

    public Set<StopModel> getSelectedStops() {
        return this.selectedStops;
    }
}

