/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.stop;

import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.tourmanager.gui.stop.StopTablePanel;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.ktde.util.datatypes.Tupel;

public class StopTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = -8535356176370178039L;
    private TourModel tour;
    private StopTablePanel stopTablePanel;

    public StopTableModel(StopTablePanel stopTablePanel, TourModel tour) {
        this.tour = tour;
        this.stopTablePanel = stopTablePanel;
    }

    public Class<? extends Object> getColumnClass(int columnIndex) {
        return this.getValueAt(0, columnIndex).getClass();
    }

    public void reorder(int fromIndex, int toIndex) {
        if (toIndex < 0) {
            return;
        }
        StopModel fromStop = this.getStopAt(fromIndex);
        if (fromStop == null || fromStop.getPoi() != null) {
            return;
        }
        Tupel<Integer, Integer> toPosition = this.getPositionInTourParts(toIndex);
        if (toPosition.getElement2() == -1) {
            TourPartModel tourPart = this.tour.getTourPartAt(toPosition.getElement1());
            fromStop.setTourPart(tourPart);
            tourPart.addStop(fromStop);
        } else {
            TourPartModel tourPart = this.tour.getTourPartAt(toPosition.getElement1());
            int minIndex = -1;
            int i = 0;
            while (i < tourPart.countStops() && tourPart.getStopAt(i).getPoi() != null) {
                minIndex = i++;
            }
            int maxIndex = tourPart.countStops();
            int i2 = tourPart.countStops() - 1;
            while (i2 > 0 && tourPart.getStopAt(i2).getPoi() != null) {
                maxIndex = i2--;
            }
            fromStop.setTourPart(tourPart);
            if (fromStop.getPoi() == null) {
                if (toPosition.getElement2() <= minIndex) {
                    toPosition.setElement2(minIndex + 1);
                } else if (toPosition.getElement2() >= maxIndex) {
                    toPosition.setElement2(maxIndex - 1);
                }
            } else if (toPosition.getElement2() > minIndex && toPosition.getElement2() < maxIndex) {
                if (fromIndex >= maxIndex) {
                    toPosition.setElement2(maxIndex);
                } else {
                    toPosition.setElement2(minIndex);
                }
            }
            this.tour.getTourPartAt(toPosition.getElement1()).insertStop(fromStop, toPosition.getElement2());
        }
        fromStop.setStreetMileageMetersFromTourStart(null);
        fromStop.setEstimatedTimeOfArrival(null);
        fromStop.setStopStatus(null);
        this.stopTablePanel.createTimeWindwsComboBox();
        this.stopTablePanel.updateStopTable();
    }

    public void setRowtAt(Vector<Object> row, int rowIndex) {
        this.getDataVector().setElementAt(row, rowIndex);
    }

    public void addStopModel(StopModel stopModel, int tourPartSortOrder) {
        stopModel.setStreetMileageMetersFromTourStart(null);
        stopModel.setEstimatedTimeOfArrival(null);
        stopModel.setStopStatus(null);
        TourPartModel tourPart = this.tour.getTourPartAt(tourPartSortOrder);
        if (tourPart.isStopsEmpty()) {
            tourPart.addStop(stopModel);
            return;
        }
        StopModel lastStop = tourPart.getStopAt(tourPart.countStops() - 1);
        if (lastStop.getPoi() != null) {
            tourPart.insertStop(stopModel, tourPart.countStops() - 1);
        } else {
            tourPart.addStop(stopModel);
        }
    }

    public void removeStopModel(StopModel stopModel, int rowIndex) {
        Tupel<Integer, Integer> position = this.getPositionInTourParts(rowIndex);
        this.tour.getTourPartAt(position.getElement1()).removeStop(stopModel);
        stopModel.setTourPart(null);
        stopModel.setEstimatedTimeOfArrival(null);
        stopModel.setStreetMileageMetersFromTourStart(null);
        stopModel.setStopStatus(null);
    }

    public StopModel getStopAt(int rowIndex) {
        Tupel<Integer, Integer> position = this.getPositionInTourParts(rowIndex);
        if (position.getElement2() == -1) {
            return null;
        }
        return this.tour.getTourPartAt(position.getElement1()).getStopAt(position.getElement2());
    }

    public Tupel<Integer, Integer> getPositionInTourParts(int rowIndex) {
        Tupel<Integer, Integer> position = new Tupel<Integer, Integer>(-1, -1);
        if (this.tour.countTourParts() == 1) {
            position.setElement1(0);
            position.setElement2(rowIndex);
            return position;
        }
        for (int i = 0; i < this.tour.countTourParts(); ++i) {
            position.setElement1(i);
            position.setElement2(0);
            if (--rowIndex < this.tour.getTourPartAt(i).countStops()) {
                position.setElement2(rowIndex);
                break;
            }
            rowIndex -= this.tour.getTourPartAt(i).countStops();
        }
        return position;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 5 && this.stopTablePanel.isEditable();
    }
}

